/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

static GeomClass *aQuadMethods = NULL;

/* these are known only to the library, not the user */
extern Quad *QuadCopy( Quad * );
extern Quad *QuadDelete( Quad * );
extern Geom *QuadCreate ( va_list);

int QuadPresent = 1;

static char quadName[] = "quad";

char *
QuadName()
{
	return quadName;
}

GeomClass *
QuadMethods()
{
    if( !aQuadMethods ) {
	aQuadMethods = GeomClassCreate(quadName);

	aQuadMethods->name = QuadName;
        aQuadMethods->methods = (GeomMethodsFunc *)QuadMethods;
	aQuadMethods->copy = (GeomCopyFunc *)QuadCopy;
	aQuadMethods->create = (GeomCreateFunc *)QuadCreate;
        aQuadMethods->fload = (GeomFLoadFunc *)QuadFLoad;
	aQuadMethods->fsave = (GeomFSaveFunc *)QuadFSave;
	aQuadMethods->Delete = (GeomDeleteFunc *)QuadDelete;
        aQuadMethods->bound = (GeomBoundFunc *)QuadBound;
	aQuadMethods->boundsphere = 
	  (GeomBoundSphereFunc *)QuadSphere;
        aQuadMethods->evert = (GeomEvertFunc *)QuadEvert;
        aQuadMethods->draw = (GeomDrawFunc *)QuadDraw;
	aQuadMethods->pick = (GeomPickFunc *) QuadPick;
	aQuadMethods->transform = (GeomTransformFunc *) QuadTransform;
	aQuadMethods->transformto = (GeomTransformToFunc *) QuadTransformTo;
    }
    return aQuadMethods;
}
