/*
 * Grace - Graphics for Exploratory Data Analysis
 * 
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 * 
 * Copyright (c) 1991-95 Paul J Turner, Portland, OR
 * Copyright (c) 1996-98 GRACE Development Team
 * 
 * Maintained by Evgeny Stambulchik <fnevgeny@plasma-gate.weizmann.ac.il>
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * Set page layout and background color
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>

#include "globals.h"
#include "protos.h"
#include "motifinc.h"

static Widget page_frame;
static Widget page_panel;

/*
 * Panel item declarations
 */
static Widget *page_color_item;

static void update_page(void);
static void define_page_proc(Widget w, XtPointer client_data, XtPointer call_data);


/*
 * Create the draw Frame and the draw Panel
 */
void create_page_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget buts[2];

    set_wait_cursor();
    if (page_frame == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	page_frame = XmCreateDialogShell(app_shell, "Page options", NULL, 0);
	handle_close(page_frame);
	page_panel = XmCreateRowColumn(page_frame, "page_rc", NULL, 0);
	page_color_item = CreateColorChoice(page_panel, "Page colour");

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, page_panel, NULL);

	CreateCommandButtons(page_panel, 2, buts, label1);
	XtAddCallback(buts[0], XmNactivateCallback,
		      (XtCallbackProc) define_page_proc, (XtPointer) 0);
	XtAddCallback(buts[1], XmNactivateCallback,
		   (XtCallbackProc) destroy_dialog, (XtPointer) page_frame);

	XtManageChild(page_panel);
    }
    XtRaise(page_frame);
    update_page();
    unset_wait_cursor();
}


/*
 * Event and Notify proc declarations
 */

static void update_page(void)
{
    if (page_frame) {
	SetChoice(page_color_item, getbgcolor());
    }
}

/*
 * define the draw options
 */
static void define_page_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    setbgcolor ((int) GetChoice(page_color_item));

    XtUnmanageChild(page_frame);
    drawgraph();
}
