/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#if !filename_h
#define filename_h 1

#include <stdio.h>

/* Search path for configuration files. */
extern const char *config_path;

void init_filename (void);

const char *blp_getenv (const char *);
const char *getenv_default (const char *key, const char *def);
char *interp_vars (const char *, const char *(*)(const char *));

char *tilde_expand (const char *);
char *search_path (const char *name, const char *path, const char *prepend);

char *gnu_getcwd (void);
char *normalize_filename (const char *);
int absolute_filename_p (const char *name);

char *readlink_malloc (const char *);
int file_exists (const char *);

FILE *open_file (const char *fn, const char *mode);
int close_file (FILE *, const char *fn);

char *blp_dirname (const char *fn);
char *prepend_dir (const char *file, const char *dir);

/* Extended file routines. */
struct file_ext;
typedef int (*file_callback) (struct file_ext *);
/* File callbacks may not return zero to indicate failure unless they
   set errno to a sensible value. */
typedef struct file_ext
  {
    char *filename;		/* Filename. */
    const char *mode;		/* Open mode, i.e, "wb". */
    FILE *file;			/* File. */
    int *sequence_no;		/* Page number, etc. */
    void *param;		/* User data. */
    file_callback postopen;	/* Called after FILE opened. */
    file_callback preclose;	/* Called before FILE closed. */
  }
file_ext;

int open_file_ext (file_ext *f);
int close_file_ext (file_ext *f);

int is_special_filename (const char *filename);

#endif /* filename_h */
