/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: scale_plot.c,v 1.3 1998/03/11 03:02:29 lance Exp $ */
#include <stdio.h>
#include <string.h>

#include "data.h"
#include "xwin.h"

/* setup in Plot struct plot parts listed below
   double **scale;
   double **shift;
   Data ***start;
   Data ***end;
   int zoom_count;
   int num_zoom;
   double **z_scale;
   double **z_shift;
 */

int get_window_size(Display *display, Window window,
				 unsigned int *width,
				 unsigned int *height)
{
  Window root_return;
  int x_return, y_return;
  unsigned int border_width_return;
  unsigned int depth_return;
  static unsigned int w = 0, h = 0;

  XGetGeometry(display, window,
	       &root_return, &x_return, &y_return,
	       width, height, &border_width_return,
	       &depth_return);

  if(w != *width || h != *height)
    {
      w = *width;
      h = *height;
      return 1;
    }
  return 0;
}

void scale_plot(PlotXwins *win, Plot *plot, unsigned int *w, unsigned int *h)
{
  unsigned int height,width;
  static unsigned int oldheight = 0, oldwidth = 0;
  int i,j,k;
  double max[2], min[2];

  get_window_size(win->display,win->plotwin,&width,&height);
  *w = width; *h = height;
  if(width == oldwidth && height == oldheight)/* no size change so no scaling needed */
    return;
  if(SAME_SCALE & plot->flag)
    {
      max[X] = plot->max[plot->list[0][X]];
      max[Y] = plot->max[plot->list[0][Y]];
      min[X] = plot->min[plot->list[0][X]];
      min[Y] = plot->min[plot->list[0][Y]];         
      for(i=1;i<plot->num_plots;i++)
	{
	  for(j=0;j<2;j++) /* X = 0, Y = 1 in data.h */
	    {
	      if(max[j] < plot->max[plot->list[i][j]])
		max[j] = plot->max[plot->list[i][j]];
	      if(min[j] > plot->min[plot->list[i][j]])
		min[j] = plot->min[plot->list[i][j]];
	    }
	}
    }
  for(i=0;i<plot->num_plots;i++)
    {
      if(SAME_SCALE & plot->flag)
	{
	  if(max[X] == min[X])
	    max[X] = min[X] + 1.0;
	  if(max[Y] == min[Y])
	    max[Y] = min[Y] + 1.0;
	  plot->scale[i][X] = width/(max[X] - min[X]);
	  plot->scale[i][Y] = height/(min[Y] - max[Y]);
	  plot->shift[i][X] = -plot->scale[i][X]*min[X];
	  plot->shift[i][Y] = -plot->scale[i][Y]*max[Y];
	}
      else 
	{
	  if(plot->max[plot->list[i][X]] == plot->min[plot->list[i][X]])
	    {
	      plot->scale[i][X] = width/(
		(plot->max[plot->list[i][X]] +(i+1)) - (plot->min[plot->list[i][X]]-(plot->num_plots-i))
				     );
	      plot->shift[i][X] = -plot->scale[i][X]*(plot->min[plot->list[i][X]]-(plot->num_plots-i));
	    }
	  else
	    {
	      
	      plot->scale[i][X] = width/(
		plot->max[plot->list[i][X]] - plot->min[plot->list[i][X]]
				     );
	      plot->shift[i][X] = -plot->scale[i][X]*plot->min[plot->list[i][X]];
	    }
	  if(plot->min[plot->list[i][Y]] == plot->max[plot->list[i][Y]])
	    {
	      plot->scale[i][Y] = height/(
		 (plot->min[plot->list[i][Y]] -(plot->num_plots-i)) - (plot->max[plot->list[i][Y]]+(i+1))
		 );
	      plot->shift[i][Y] = -plot->scale[i][Y]*(plot->max[plot->list[i][Y]]+(i+1));
	    }
	  else
	    {
	      plot->scale[i][Y] = height/(
		 plot->min[plot->list[i][Y]] - plot->max[plot->list[i][Y]]
		 );
	      plot->shift[i][Y] = -plot->scale[i][Y]*plot->max[plot->list[i][Y]];

	    }
	  
	}
    }
  plot->z_scale[0][X] = FRACTION_WINDOW_USE;
  plot->z_scale[0][Y] = FRACTION_WINDOW_USE; 
  plot->z_shift[0][X] = (1.0 - FRACTION_WINDOW_USE)*width/2.0;
  plot->z_shift[0][Y] = (1.0 - FRACTION_WINDOW_USE)*height/2.0;
  if(oldwidth != 0 && oldheight != 0)
   {
     double fh,fw;
     
     fh = 1.0/oldheight; fh *= height;
     fw = 1.0/oldwidth;  fw *= width;
     for(i=1;i<=plot->zoom_count;i++)
      {
	plot->z_shift[i][X] *= fw;
	plot->z_shift[i][Y] *= fh;
      }
   }
  oldwidth = width;
  oldheight = height;
}
