\name{poly.orth}
\title{Orthogonal Polynomials}
\usage{
poly.orth(x, degree = length(unique(x)) - 1, 
          nam = paste("P", 1:degree, sep = ""))
}
\arguments{
\item{x}{A numeric vector of abscissae.  When evaluated at \code{x} the
polynomials will generate an orthonormal set.}
\item{degree}{Maximum degree requried.  The default is one fewer than
the number of distinct values in x, which is maximum possible.}
\item{nam}{Names vector for the components of the list result}
}
\description{
Construct the orthogonal polynomials on a given vector, \code{x}, up to a
specified degree.

This function uses \code{poly()} to evaluate the polynomial basis,
\code{poly.raw} to re-evaluate the same polynomial basis at a minimum
abscissa set, and \code{poly.value()} to determine the polynomial basis.
}
\value{
A list of objects of class ``polynomial'' of degree 1, 2, \dots, degree.
}
\seealso{
poly.value, poly.from.value, poly, poly.raw.
}
\examples{
x <- rep(1:4, 1:4)        # x with repititions for weighting
x # [1] 1 2 2 3 3 3 4 4 4 4
polx <- poly.orth(x, 3)		# calculate orthogonal polynomials.
polx
## $P1:
## -0.9486833 + 0.3162278*x 
## $P2:
## 2.139203 - 1.863177*x + 0.3450328*x^2 
## $P3:
## -5.831564 + 8.80369*x - 3.803194*x^2 + 0.4930066*x^3 
as.data.frame(lapply(polx, poly.value, x)) # orthonormal basis
##           P1         P2          P3 
## 1 -0.6324555  0.6210590 -0.33806170
## 2 -0.3162278 -0.2070197  0.50709255
## 2 -0.3162278 -0.2070197  0.50709255
## 3  0.0000000 -0.3450328 -0.33806170
## 3  0.0000000 -0.3450328 -0.33806170
## 3  0.0000000 -0.3450328 -0.33806170
## 4  0.3162278  0.2070197  0.08451543
## 4  0.3162278  0.2070197  0.08451543
## 4  0.3162278  0.2070197  0.08451543
## 4  0.3162278  0.2070197  0.08451543
round(crossprod(.Last.value), 10)       # check orthonormality
##    P1 P2 P3 
## P1  1  0  0
## P2  0  1  0
## P3  0  0  1
}
