"crosscorr.plot" <-
function (x, combine.chains = F, col = topo.colors(10), auto.layout = F) 
{
        x <- as.mcmc(x)
        Nvar <- nvar(x)
        pcorr <- crosscorr(x, combine.chains = combine.chains)
        if (is.matrix(pcorr)) 
                pcorr <- array(pcorr, dim = c(dim(pcorr), 1))
        dens <- ((pcorr + 1) * length(col))%/%2 + (pcorr < 1) + 
                (pcorr < -1)
        cutoffs <- format(seq(from = 1, to = -1, length = length(col) + 
                1), digits = 2)
        leg <- paste("(", cutoffs[-1], ",", cutoffs[-length(cutoffs)], 
                "]", sep = "")
        oldpar <- NULL
        if (auto.layout) 
                oldpar <- par(mfrow = set.mfrow(Nchains = nchain(x), 
                        Nparms = nvar(x)))
        oldpar <- c(oldpar, set.scale())
        on.exit(par(oldpar))
        par(pty = "s")
        for (i in 1:dim(pcorr)[3]) {
                plot(0, 0, type = "n", xlim = c(0, Nvar), ylim = c(0, 
                        Nvar), xlab = "", ylab = "", xaxt = "n", 
                        yaxt = "n")
                axis(1, at = c(1:Nvar) - 0.5, labels = abbreviate(colnames(x), 
                        minlength = 7))
                axis(2, at = 1:Nvar - 0.5, labels = abbreviate(colnames(x), 
                        minlength = 7)[Nvar:1])
                for (cl in 1:Nvar) {
                        for (rw in 1:(Nvar - cl + 1)) polygon(y = c(cl - 
                                1, cl - 1, cl, cl, cl - 1), x = c(rw - 
                                1, rw, rw, rw - 1, rw - 1), col = col[dens[nrow(dens) - 
                                cl + 1, rw, i]])
                }
                oldpar <- c(oldpar, par(adj = 0.5))
                legend(Nvar, Nvar, legend = leg, fill = col[length(col):1], 
                        xjust = 1, cex = par("cex"), y.intersp = 1.2 * 
                                par("cex"))
                if (!combine.chains) 
                        title(dimnames(x)[[3]][i])
                if (i != dim(pcorr)[3] && mpause2()) 
                        break
        }
        if (combine.chains) 
                title("Combined")
}
