\name{crosscorr.plot}
\title{Plot image of correlation matrix}

\usage{function (x, combine.chains = F, col = topo.colors(10))}

\arguments{
\item{x}{an mcmc object}
\item{combine.chains}{flag to calculate single correlation for all chains}
\item{col}{color palette to use}
}

\description{
\code{crosscorr.plot} provides an image of the correlation matrix for
each Markov chain in \code{x} or, if \code{combine.chains} = T, for
all chains combined.

The range [-1,1] is divided into a number of equal-length categories
given by the length of \code{col} and assigned the corresponding color.
By default, topographic colours are used as this makes it easier to
distinguish positive and negative correlations.
}

\seealso{
\code{\link{crosscorr}}, \code{\link{image}}, \code{\link{topo.colors}}.
}
