/* aind.f -- translated by f2c (version 19960717).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"


/*  Copyright (C) 1997 Berwin A. Turlach <berwin@alphasun.anu.edu.au> */

/*  This program is free software; you can redistribute it and/or modify */
/*  it under the terms of the GNU General Public License as published by */
/*  the Free Software Foundation; either version 2 of the License, or */
/*  (at your option) any later version. */

/*  This program is distributed in the hope that it will be useful, */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/*  GNU General Public License for more details. */

/*  You should have received a copy of the GNU General Public License */
/*  along with this program; if not, write to the Free Software */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, */
/*  USA. */

/*  this routine checks whether Aind has valid entries, i.e., */
/*    1) 1<= Aind(1,i) <= n for i=1,...,q (number of constraints) */
/*    2) 1<= Aind(j,i) <= n for j=2,...,Aind(1,i)+1, i=1,...,q */

/*  Aind is a m times q matrix constructed in Splus */

/* Subroutine */ int aind_(ind, m, q, n, ok)
integer *ind, *m, *q, *n;
logical *ok;
{
    /* System generated locals */
    integer ind_dim1, ind_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j;

    /* Parameter adjustments */
    ind_dim1 = *m;
    ind_offset = ind_dim1 + 1;
    ind -= ind_offset;

    /* Function Body */
    *ok = FALSE_;
    i__1 = *q;
    for (i__ = 1; i__ <= i__1; ++i__) {
	if (ind[i__ * ind_dim1 + 1] < 1 || ind[i__ * ind_dim1 + 1] > *n) {
	    return 0;
	}
	i__2 = ind[i__ * ind_dim1 + 1] + 1;
	for (j = 2; j <= i__2; ++j) {
	    if (ind[j + i__ * ind_dim1] < 1 || ind[j + i__ * ind_dim1] > *n) {
		return 0;
	    }
	}
    }
    *ok = TRUE_;
    return 0;
} /* aind_ */

