/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/* 
 * PwP.h - Private definitions for Pw widget
 * 
 */

#ifndef _XawPwP_h
#define _XawPwP_h

/***********************************************************************
 *
 * Pw Widget Private Data
 *
 ***********************************************************************/

#include "Pw.h"
#include <X11/Xmu/Converters.h>

/* New fields for the Pw widget class record */
typedef struct {int empty;} PwClassPart;

/* Full class record declaration */
typedef struct _PwClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    PwClassPart	pw_class;
} PwClassRec;

extern PwClassRec pwClassRec;

/* New fields for the Pw widget record */
typedef struct {
    /* resources */
    Dimension   h_space, v_space;

#if 0	/* Box stuff */
    /* private state */
    Dimension	preferred_width, preferred_height;
    Dimension	last_query_width, last_query_height;
    XtGeometryMask last_query_mode;
#endif
} PwPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _PwRec {
    CorePart	    core;
    CompositePart   composite;
    PwPart 	    pw;
} PwRec;

#endif /* _XawPwP_h */
