#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc edit_data {} { cmd_read }

proc cmd_apply { name } {

  global tnpath
  source $tnpath/vtn/global.tcl

  if { $switch } { 
    puts "In proc CMD_APPLY" 
    puts "name: $name"
  }

  set define_list ""
  set define_strings_list ""
  catch {destroy $w_vtnmbar_edit_data}
  global edittask 
  set edittask $name

  if       { $edittask == "edit_by_index" || $edittask == "edit_by_name" } {

    set w_vtnmbar_edit_data_edit .w_vtnmbar_edit_data_edit
    catch {destroy $w_vtnmbar_edit_data_edit}
    toplevel $w_vtnmbar_edit_data_edit
    wm title $w_vtnmbar_edit_data_edit "edit data"
    wm geometry $w_vtnmbar_edit_data_edit 500x500
    wm geometry $w_vtnmbar_edit_data_edit $window_offset
    focus  $w_vtnmbar_edit_data_edit

#     main frame
    set f $w_vtnmbar_edit_data_edit.frame
    frame $f -relief groove -borderwidth 2
    pack $f -expand 1 -fill both

#     ready
    frame $f.framespecial -relief flat
    pack $f.framespecial -side bottom -pady 2m -fill x
    button $f.framespecial.ready -text "Ready" -command { 
      destroy $w_vtnmbar_edit_data_edit
      cmd_read 
    }
    button $f.framespecial.help -text "Help" -command {
      help "Data item list. Double click to activate editing.\n\nData item entry. Enter data item name, data item index (if required) and data item values. Then press return. Do not enter data item values to skip the data item alltogether."
    }
    pack $f.framespecial.ready -side left -anchor w
    pack $f.framespecial.help -side right -anchor e

#     entry of data item
    frame $f.frameitem -relief flat
    pack $f.frameitem -side bottom -pady 2m -fill x -anchor w
    label $f.frameitem.lab -text "Data item entry: "
    entry $f.frameitem.ent -textvariable line -relief sunken -width 50
    pack $f.frameitem.lab -side left -anchor w
    pack $f.frameitem.ent -side left -fill x -expand 1 -anchor w
    bind $f.frameitem.ent <Return> {
      convert_line
      set line_list [ split $line ]
      set first_word [ lindex $line_list 0 ]
      set second_word [ lindex $line_list 1 ]
      set ok 0
      for {set imember 0} {$imember<$cmd_array_length} {incr imember} {
         set cmd_array_member $cmd_array($imember)
        if { $first_word == $cmd_array_member } {set ok 1}
      }
      if { $ok } {
        set cmd_array_member $first_word
        set data_array_index [set data_array_index_$cmd_array_member]
        if { $data_array_index == 1 } {
          set index $second_word
          set remainder_list [ lrange $line_list 2 end ]
          set remainder [ join $remainder_list ]
        } else {
          set index 0
          set remainder_list [ lrange $line_list 1 end ]
          set remainder [ join $remainder_list ]
        }
        set data_array_values data_array_values_$cmd_array_member
        if { $remainder == "" } {
          unset [set data_array_values]($index)
        } else {
          set [set data_array_values]($index) $remainder
        }
        cmd_apply_editlist $edittask
      }
    }

    cmd_apply_editlist $edittask

  } elseif { $edittask == "delete" } {

    for {set imember 0} {$imember<$cmd_array_length} {incr imember} {
      set cmd_array_member $cmd_array($imember)
      set cmd_array_member_list $cmd_array_list($imember)
      set ok 1
      for {set level 0} {$level<$cmd_array_member_part_list_length} {incr level} {
        set s1 [lindex $cmd_array_member_part_list $level]
        set s2 [lindex $cmd_array_member_list $level]
        set eq [string compare $s1 $s2]
        if { $eq!=0 } { set ok 0 }
      }
      if { $ok } {
        set data_array_values data_array_values_$cmd_array_member
        set active_indices [array names $data_array_values]
        foreach index $active_indices {
          set data_array_index [set data_array_index_$cmd_array_member]
          set tmp [set data_array_values]($index)
          unset $tmp
        }
      }
    }
    cmd_read

  } elseif { $edittask == "ready" } {

  } elseif { $edittask == "back" } {

    if { $cmd_array_member_part_list_length>0 } {
      incr cmd_array_member_part_list_length -1
      set cmd_array_member_part_list \
        [lreplace $cmd_array_member_part_list end end]
      cmd_read
    }

  } else {

    incr cmd_array_member_part_list_length
    lappend cmd_array_member_part_list $name
    cmd_read

  }

  if { $switch } { 
    puts "cmd_array_member_part_list: $cmd_array_member_part_list"
    puts "cmd_array_member_part_list_length: $cmd_array_member_part_list_length"
    puts "In proc CMD_APPLY"
  }

}

#

proc cmd_apply_editlist { name } {

  global tnpath
  source $tnpath/vtn/global.tcl

  if { $switch } { puts "In proc CMD_APPLY_EDITLIST" }

#     main frame
  set f $w_vtnmbar_edit_data_edit.frame

#   highest_index of selected data
  set highest_index 0
  for {set imember 0} {$imember<$cmd_array_length} {incr imember} {
    set cmd_array_member $cmd_array($imember)
    set cmd_array_member_list $cmd_array_list($imember)
    set ok 1
    for {set level 0} {$level<$cmd_array_member_part_list_length} {incr level} {
      set s1 [lindex $cmd_array_member_part_list $level]
      set s2 [lindex $cmd_array_member_list $level]
      set eq [string compare $s1 $s2]
      if { $eq!=0 } { set ok 0 }
    }
    if { $ok } {
      set maximum 0
      set data_array_values data_array_values_$cmd_array_member
      set active_indices [array names $data_array_values]
      foreach index $active_indices { 
        if { $index>$maximum } {set maximum $index}
      }
      if { $maximum>$highest_index } { set highest_index $maximum }
    }
  }
  if { $switch } { puts "highest_index: $highest_index" }

#   listbox of all selected data
  catch {destroy $f.framelist}
  frame $f.framelist -relief flat
  pack $f.framelist -fill both -side top -expand 1

  label $f.framelist.lab -text "Data item list: "
  pack $f.framelist.lab -side top

  listbox $f.framelist.list \
    -relief raised -yscrollcommand "$f.framelist.scroll set"
  scrollbar $f.framelist.scroll -command "$f.framelist.list yview"
  pack $f.framelist.scroll -side right -fill y
  pack $f.framelist.list -side left -fill both -expand 1
  bind $f.framelist.list <Double-1> { set line [selection get] }

  set ilist 0
  set w_vtnmbar_edit_data_listnames ""
  if { $name == "edit_by_index" } {
    set max_outer $highest_index
    set max_inner [expr $cmd_array_length-1]
  } else {
    set max_outer [expr $cmd_array_length-1]
    set max_inner $highest_index
  }
  for {set outer 0} {$outer<=$max_outer} {incr outer} {
    set anything 0
    for {set inner 0} {$inner<=$max_inner} {incr inner} {
      if { $name == "edit_by_index" } {
        set index $outer
        set imember $inner
      } else {
        set imember $outer
        set index $inner
      }
      set cmd_array_member $cmd_array($imember)
      set cmd_array_member_list $cmd_array_list($imember)
      set ok 1
      for {set level 0} {$level<$cmd_array_member_part_list_length} {incr level} {
        set s1 [lindex $cmd_array_member_part_list $level]
        set s2 [lindex $cmd_array_member_list $level]
        set eq [string compare $s1 $s2]
        if { $eq!=0 } { set ok 0 }
      }
      if { $ok } {
        set data_array_values data_array_values_$cmd_array_member
        set tmp [set data_array_values]($index)
        set exists [info exists $tmp]
        if { $exists } {
          set data_array_index [set data_array_index_$cmd_array_member]
          set tmp [set data_array_values]($index)
          if { $data_array_index == "1" } {
            $f.framelist.list insert end "$cmd_array_member $index [set $tmp]"
            lappend w_vtnmbar_edit_data_listnames "$cmd_array_member"
            set w_vtnmbar_edit_data_listindices($ilist) $index
          } else {
            $f.framelist.list insert end "$cmd_array_member [set $tmp]"
            lappend w_vtnmbar_edit_data_listnames "$cmd_array_member"
            set w_vtnmbar_edit_data_listindices($ilist) -1
          }
          incr ilist
          set anything 1
        }
      }
    }
    if { $anything } { $f.framelist.list insert end " " }
  }

  if { $switch } { puts "Out proc CMD_APPLY_EDITLIST" }

}

#


proc cmd_read {} {

  run only_initia foreground
  data_initialise

  global tnpath
  source $tnpath/vtn/global.tcl

  set last_name ""
  set cmd_array_member_part [join $cmd_array_member_part_list _]

  if { $switch } {
    puts "In proc CMD_READ"
    puts "cmd_array_member_part: $cmd_array_member_part"
    puts "cmd_array_member_part_list: $cmd_array_member_part_list"
    puts "cmd_array_member_part_list_length: $cmd_array_member_part_list_length"
  }

  set w_vtnmbar_edit_data .vtnmbar.edit.menu.data
  catch {destroy $w_vtnmbar_edit_data}

  toplevel $w_vtnmbar_edit_data
  wm title $w_vtnmbar_edit_data "data "
  wm geometry $w_vtnmbar_edit_data $window_offset

  set f $w_vtnmbar_edit_data.frame
  frame $f -relief groove -borderwidth 2
  pack $f -expand 1 -fill both

#   loop over all commands
  frame $f.framecmd -relief flat -borderwidth 2
  pack $f.framecmd -pady 2m -anchor w
  for {set imember 0} {$imember<$cmd_array_length} {incr imember} {
    if { $switch } {puts "imember: $imember"}
    set cmd_array_member $cmd_array($imember)
    set cmd_array_member_list $cmd_array_list($imember)
    set cmd_array_member_list_length [llength $cmd_array_member_list]
    if { $switch } { 
      puts "cmd_array_member: $cmd_array_member"
      puts "cmd_array_member_list: $cmd_array_member_list"
      puts "cmd_array_member_list_length: $cmd_array_member_list_length"
    }
    if { $cmd_array_member == $cmd_array_member_part } {
      button $f.framecmd.$cmd_array_member -text $cmd_array_member -command "cmd_apply edit_by_index"
      pack $f.framecmd.$cmd_array_member -side top -fill x
    }
    if { $cmd_array_member_list_length>$cmd_array_member_part_list_length } {
#       test if each part of a command fits the command name up to now
      for {set level 0; set ok 1} {$level<$cmd_array_member_part_list_length} {incr level} {
        if { $switch } {puts "level: $level"}
        set s1 [lindex $cmd_array_member_part_list $level]
        set s2 [lindex $cmd_array_member_list $level]
        set eq [string compare $s1 $s2]
        if { $eq!=0 } { set ok 0 }
      }
      if { $switch } {puts "ok: $ok"}
#       generate button for next part of a command
      if { $ok } {
        set name [lindex $cmd_array_member_list $cmd_array_member_part_list_length]
        if { $name!=$last_name } {
          if       { $cmd_array_member_part == $cmd_array_member } {
            button $f.framecmd.$name -text [set name] -command "cmd_apply edit_by_index"
          } elseif { $cmd_array_member_part_list_length == 0 } {
            button $f.framecmd.$name -text [set name]_* -command "cmd_apply $name"
          } else {
            button $f.framecmd.$name -text [set cmd_array_member_part]_[set name]_* -command "cmd_apply $name"
          }
          pack $f.framecmd.$name -side top -fill x
          set last_name $name
        }
      }
    }
  }

  frame $f.framespecial1 -relief flat -borderwidth 2
  pack $f.framespecial1 -side bottom -pady 2m -fill x
  button $f.framespecial1.ready -text "Ready" -command "cmd_apply ready"
  button $f.framespecial1.back -text "Back" -command "cmd_apply back"
  button $f.framespecial1.help -text "Help" -command {
    help "Clicking on data_* goes one selection level deeper.\n\nClicking on data (without _*) selects data to edit.\n\nEdit by index: edits current selection ordered by index.\n\nEdit by name: edits current selection ordered by name.\n\nDelete all: delete all data for current selection.\n\nReady: ready editing data.\n\nBack: goes one selection level up."
  }
  pack $f.framespecial1.ready $f.framespecial1.back -side left -anchor w
  pack $f.framespecial1.help -side right -anchor e

  frame $f.framespecial2 -relief flat -borderwidth 2
  pack $f.framespecial2 -side bottom -pady 2m -fill x
  button $f.framespecial2.editindex -text "Edit by index" -command "cmd_apply edit_by_index"
  button $f.framespecial2.editname -text "Edit by name" -command "cmd_apply edit_by_name"
  button $f.framespecial2.delete -text "Delete all" -command "cmd_apply delete"
  pack $f.framespecial2.editindex  $f.framespecial2.editname \
    $f.framespecial2.delete -side left -anchor w

  if { $switch } { puts "Out proc CMD_READ" }

}
