/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

/* color sequence for color clist
blue  0 
dark blue 1
light blue 2 
brown 3 
dark cyan 4 
cyan 5 
gold 6 
dark gray 7 
gray 8 
dark green 9 
light green 10 
green 11 
lavender 12 
magenta 13 
orange 14 
pink 15 
purple 16 
red 17 
salmon 18 
turquoise 19 
wheat 20 
white 21 
yellow 22
black 23
light gray 24 */


#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <ctype.h>


/*****************************************************************************************/
void edit_options_color_changed()
{
	extern int edit_options_save_flag;
	
	set_object_color();
	edit_options_save_flag = 1;
}
/*****************************************************************************************/
void edit_options_object_changed()
{
	
	get_object_color();
}
/*********************************************************************************/
void ok_save_options()
{
	extern int edit_options_save_flag, chartflag;
	
	if (edit_options_save_flag)
	{
		save_options();
		if (chartflag)
			draw();
	}
}
/*********************************************************************************/
void no_save_options()
{
	extern int edit_options_save_flag;
	extern GtkWidget *yesno_window;
	
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
	edit_options_save_flag = 0;
	exit_edit_options_window();
}
/*********************************************************************************/
void yes_save_options()
{
	extern GtkWidget *yesno_window;
	extern int chartflag;
	
	
	save_options();
	if (chartflag)
		draw();
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
	exit_edit_options_window();
}
/*********************************************************************************/
void exit_edit_options_window()
{
    	extern GtkWidget *edit_options_window, *yesno_yes_button, *yesno_no_button;
    	extern GtkWidget *yesno_window;
	extern int edit_options_save_flag, edit_options_flag;
	
	
	if (yesno_window)
		return;	
	if (edit_options_save_flag)
	{
		show_yesno_window("Changes have not been saved. Save changes?");
      		gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (yes_save_options), NULL);
      		gtk_signal_connect (GTK_OBJECT (yesno_no_button), "clicked",
			    GTK_SIGNAL_FUNC (no_save_options), NULL);
      		return;
	}
	if (edit_options_window)
		gtk_widget_destroy(edit_options_window);
	edit_options_flag = 0;
}
/*****************************************************************************************/
void edit_options_changed()
{
	extern int edit_options_save_flag;
	
	edit_options_save_flag = 1;
}
/***************************************************************************/
void save_options()
{
	int tint, tint2, tint3;
	char tstring[250], *tstringpointer;
	extern GtkWidget *enable_top_check, *enable_bottom_check;
    	extern GtkWidget *enable_ch_check, *enable_cl_check, *enable_ld_check;
    	extern GtkWidget *enable_lc_check, *enable_nc_check, *enable_date_check;
    	extern GtkWidget *enable_open_check, *enable_high_check, *enable_low_check;
    	extern GtkWidget *enable_close_check, *enable_volume_check, *enable_openi_check;
    	extern GtkWidget *bars_value_entry, *pixmaps_entry, *proxy_entry, *port_entry;
	extern int edit_options_save_flag, open_file_flag, chartflag;
	extern struct record3 config;
	extern struct record2 header;
	extern char *error_message;
	
	
	
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(pixmaps_entry));
	if (tstringpointer == NULL) {
	  RETURN_ERR(gs_nothing_entered);
	}
	else
		sscanf(tstringpointer, "%s", config.pixmap_path);
	
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(bars_value_entry));
	if (tstringpointer == NULL)
		config.bars = 0;
	else
	{
		sscanf(tstringpointer, "%s", tstring);
		tint = strlen(tstring);
		for (tint2 = 0; tint2 < tint; tint2++)
		{
			tint3 = isdigit(tstring[tint2]);
			if (tint3 == 0)
			  RETURN_ERR(gs_invalid_entry);

		}
		config.bars = atoi(tstring);
	}
	if (GTK_TOGGLE_BUTTON(enable_top_check)->active)
	{
		if (config.top_enable_flag == 0)
			show_info_bar();
		config.top_enable_flag = 1;
	}
	else
	{
		if (config.top_enable_flag)
			hide_info_bar();
		config.top_enable_flag = 0;
	}
	if (GTK_TOGGLE_BUTTON(enable_bottom_check)->active)
	{
		if (config.bottom_enable_flag == 0)
			show_data_bar();
		config.bottom_enable_flag = 1;
	}
	else
	{
		if (config.bottom_enable_flag == 1)
			hide_data_bar();
		config.bottom_enable_flag = 0;
	}
	if (GTK_TOGGLE_BUTTON(enable_ch_check)->active)
		config.contract_high_flag = 1;
	else
		config.contract_high_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_cl_check)->active)
		config.contract_low_flag = 1;
	else
		config.contract_low_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_ld_check)->active)
		config.last_date_flag = 1;
	else
		config.last_date_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_lc_check)->active)
		config.last_close_flag = 1;
	else
		config.last_close_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_nc_check)->active)
		config.net_change_flag = 1;
	else
		config.net_change_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_date_check)->active)
		config.date_flag = 1;
	else
		config.date_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_open_check)->active)
		config.open_flag = 1;
	else
		config.open_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_high_check)->active)
		config.high_flag = 1;
	else
		config.high_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_low_check)->active)
		config.low_flag = 1;
	else
		config.low_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_close_check)->active)
		config.close_flag = 1;
	else
		config.close_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_volume_check)->active)
		config.volume_flag = 1;
	else
		config.volume_flag = 0;
	if (GTK_TOGGLE_BUTTON(enable_openi_check)->active)
		config.openi_flag = 1;
	else
		config.openi_flag = 0;
		
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(proxy_entry));
	if (tstringpointer != NULL)
		sscanf(tstringpointer, "%s", config.proxy);
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(port_entry));
	if (tstringpointer != NULL)
		config.port = atoi(tstringpointer);	
		
	edit_options_save_flag = 0;
	save_config();
	if (chartflag)
	{
		update_stats_bar();
		tint = open_file_flag;
		open_file_flag = 1;
		load_file(header.symbol);
		open_file_flag = tint;
		draw();
	}
}
/*****************************************************************************/
void edit_options()
{
	int tint;
	GdkPixmap *color = NULL;
	GdkBitmap *mask;
	GtkStyle *style;
	char tstring[250], *text[] = {"Color"};
	extern GList *object_list;
	GtkWidget *frame, *frame2, *frame3, *frame4, *hbox, *hbox2, *hbox4, *hbox5;
    	GtkWidget *notebook, *ok_button, *cancel_button, *nbox, *label, *label2, *help_button;
    	GtkWidget *vbox, *vbox2, *vbox3, *vbox4, *vbox5, *vbox6, *vbox7, *vbox8, *vbox9, *label3;
    	GtkWidget *label4, *label5, *label6, *label7, *frame6, *frame8;
    	extern GtkWidget *edit_options_window, *enable_top_check, *enable_bottom_check;
    	extern GtkWidget *enable_ch_check, *enable_cl_check, *enable_ld_check;
    	extern GtkWidget *enable_lc_check, *enable_nc_check, *enable_date_check;
    	extern GtkWidget *enable_open_check, *enable_high_check, *enable_low_check;
    	extern GtkWidget *enable_close_check, *enable_volume_check, *enable_openi_check;
    	extern GtkWidget *bars_value_entry, *object_combo, *pixmaps_entry;
    	extern GtkWidget *proxy_entry, *port_entry, *color_clist, *main_window;
	extern int edit_options_flag, edit_options_save_flag;
	extern struct record3 config;
    
	
        if (edit_options_flag)
        	return;
        	
        edit_options_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (edit_options_window), "destroy",
			    GTK_SIGNAL_FUNC (exit_edit_options_window), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_options_window), "delete_event",
			    GTK_SIGNAL_FUNC (exit_edit_options_window), NULL);
        gtk_window_set_title (GTK_WINDOW (edit_options_window), "Edit Options");
        gtk_container_border_width (GTK_CONTAINER (edit_options_window), 0);
        gtk_window_position(GTK_WINDOW (edit_options_window), GTK_WIN_POS_CENTER);
	gtk_widget_set_usize(GTK_WIDGET (edit_options_window), 0, 0);
	
	nbox = gtk_hbox_new (FALSE, 10);
        gtk_container_add (GTK_CONTAINER (edit_options_window), nbox);
        gtk_container_border_width (GTK_CONTAINER (nbox), 10);
        gtk_widget_show (nbox);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
     	gtk_box_pack_start (GTK_BOX (nbox), notebook, TRUE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (notebook), 0);
      	gtk_widget_show(notebook);
      	
      	vbox = gtk_vbutton_box_new ();
      	gtk_vbutton_box_set_spacing_default(5);
      	gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      	gtk_box_pack_start (GTK_BOX (nbox), vbox, FALSE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
      	gtk_widget_show (vbox);
      	
      	ok_button = gtk_button_new_with_label("Save");
      	gtk_box_pack_start (GTK_BOX (vbox), ok_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
			    GTK_SIGNAL_FUNC (ok_save_options), NULL);
	gtk_widget_show (ok_button);
      	
      	cancel_button = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (exit_edit_options_window), NULL);
      	gtk_widget_show (cancel_button);
      	
      	help_button = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (vbox), help_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    GTK_SIGNAL_FUNC (help_edit_options_window), NULL);
      	gtk_widget_show (help_button);
      	
      	/*** status page ***/
      	
      	vbox2 = gtk_vbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
        gtk_widget_show (vbox2);
        
        frame = gtk_frame_new("Enable Status Bars:");
      	gtk_container_border_width (GTK_CONTAINER (frame), 0);
      	gtk_box_pack_start (GTK_BOX (vbox2), frame, FALSE, TRUE, 0);
      	gtk_widget_show(frame);
      	
      	vbox3 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame), vbox3);
        gtk_container_border_width (GTK_CONTAINER (vbox3), 5);
        gtk_widget_show (vbox3);
        
        enable_top_check = gtk_check_button_new_with_label("Enable stats status bar");
        gtk_box_pack_start (GTK_BOX (vbox3), enable_top_check, FALSE, TRUE, 0);
        if (config.top_enable_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_top_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_top_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_top_check);
        
        enable_bottom_check = gtk_check_button_new_with_label("Enable data status bar");
        gtk_box_pack_start (GTK_BOX (vbox3), enable_bottom_check, FALSE, TRUE, 0);
        if (config.bottom_enable_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_bottom_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_bottom_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_bottom_check);
        
        hbox = gtk_hbox_new (FALSE, 10);
        gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox), 0);
        gtk_widget_show (hbox);
        
        frame2 = gtk_frame_new("Stats Bar Fields:");
      	gtk_container_border_width (GTK_CONTAINER (frame2), 0);
      	gtk_box_pack_start (GTK_BOX (hbox), frame2, TRUE, TRUE, 0);
      	gtk_widget_show(frame2);
      	
      	vbox4 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame2), vbox4);
        gtk_container_border_width (GTK_CONTAINER (vbox4), 5);
        gtk_widget_show (vbox4);
      	
        enable_ch_check = gtk_check_button_new_with_label("Contract High");
        gtk_box_pack_start (GTK_BOX (vbox4), enable_ch_check, FALSE, TRUE, 0);
        if (config.contract_high_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_ch_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_ch_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_ch_check);
        
        enable_cl_check = gtk_check_button_new_with_label("Contract Low");
        gtk_box_pack_start (GTK_BOX (vbox4), enable_cl_check, FALSE, TRUE, 0);
        if (config.contract_low_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_cl_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_cl_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_cl_check);
        
        enable_ld_check = gtk_check_button_new_with_label("Last Date");
        gtk_box_pack_start (GTK_BOX (vbox4), enable_ld_check, FALSE, TRUE, 0);
        if (config.last_date_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_ld_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_ld_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_ld_check);
        
        enable_lc_check = gtk_check_button_new_with_label("Last Close");
        gtk_box_pack_start (GTK_BOX (vbox4), enable_lc_check, FALSE, TRUE, 0);
        if (config.last_close_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_lc_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_lc_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_lc_check);
        
        enable_nc_check = gtk_check_button_new_with_label("Net Change");
        gtk_box_pack_start (GTK_BOX (vbox4), enable_nc_check, FALSE, TRUE, 0);
        if (config.net_change_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_nc_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_nc_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_nc_check);
        
        frame3 = gtk_frame_new("Data Bar Fields:");
        gtk_box_pack_start (GTK_BOX (hbox), frame3, TRUE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (frame3), 0);
      	gtk_widget_show(frame3);
      	
      	vbox5 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame3), vbox5);
        gtk_container_border_width (GTK_CONTAINER (vbox5), 5);
        gtk_widget_show (vbox5);
      	
        enable_date_check = gtk_check_button_new_with_label("Date");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_date_check, FALSE, TRUE, 0);
        if (config.date_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_date_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_date_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_date_check);
        
        enable_open_check = gtk_check_button_new_with_label("Open");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_open_check, FALSE, TRUE, 0);
        if (config.open_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_open_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_open_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_open_check);
        
        enable_high_check = gtk_check_button_new_with_label("High");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_high_check, FALSE, TRUE, 0);
        if (config.high_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_high_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_high_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_high_check);
        
        enable_low_check = gtk_check_button_new_with_label("Low");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_low_check, FALSE, TRUE, 0);
        if (config.low_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_low_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_low_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_low_check);
        
        enable_close_check = gtk_check_button_new_with_label("Close");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_close_check, FALSE, TRUE, 0);
        if (config.close_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_close_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_close_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_close_check);
        
        enable_volume_check = gtk_check_button_new_with_label("Volume");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_close_check, FALSE, TRUE, 0);
        if (config.volume_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_volume_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_volume_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_volume_check);
        
        enable_openi_check = gtk_check_button_new_with_label("Open Interest");
        gtk_box_pack_start (GTK_BOX (vbox5), enable_openi_check, FALSE, TRUE, 0);
        if (config.openi_flag)
        	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(enable_openi_check), TRUE);
        gtk_signal_connect (GTK_OBJECT (enable_openi_check), "toggled",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(enable_openi_check);
      	
      	label = gtk_label_new("Status Bars");
      	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox2, label);
      	
      	/*** chart page ***/
	
	vbox6 = gtk_vbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (vbox6), 10);
        gtk_widget_show (vbox6);
	      	
      	frame4 = gtk_frame_new("Default data points to load:");
      	gtk_box_pack_start (GTK_BOX (vbox6), frame4, FALSE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (frame4), 0);
      	gtk_widget_show(frame4);
      	
      	hbox2 = gtk_hbox_new (FALSE, 10);
        gtk_container_add (GTK_CONTAINER (frame4), hbox2);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 5);
        gtk_widget_show (hbox2);
        
        bars_value_entry = gtk_entry_new();
        gtk_box_pack_start (GTK_BOX (hbox2), bars_value_entry, TRUE, TRUE, 0);
        sprintf(tstring, "%d", config.bars);
        gtk_entry_set_text(GTK_ENTRY(bars_value_entry), tstring);
        gtk_signal_connect (GTK_OBJECT (bars_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(bars_value_entry);
      	
      	label2 = gtk_label_new("Charts");
      	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox6, label2);
      	
      	/*** colors page ***/
      	
      	vbox7 = gtk_vbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (vbox7), 10);
        gtk_widget_show (vbox7);
        
        object_combo = gtk_combo_new ();
      	gtk_combo_set_popdown_strings (GTK_COMBO (object_combo), object_list);
      	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(object_combo)->entry), "Background");
      	gtk_box_pack_start (GTK_BOX (vbox7), object_combo, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (GTK_COMBO(object_combo)->entry), "changed",
			    GTK_SIGNAL_FUNC(edit_options_object_changed), NULL);
      	gtk_widget_show (object_combo);
      	
      	color_clist = gtk_clist_new_with_titles (1, text);
      	gtk_clist_set_column_width(GTK_CLIST(color_clist), 0, 40);
      	gtk_clist_set_selection_mode (GTK_CLIST (color_clist), GTK_SELECTION_SINGLE);
       	gtk_clist_set_policy(GTK_CLIST(color_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
       	gtk_box_pack_start (GTK_BOX (vbox7), color_clist, FALSE, TRUE, 0);
       	gtk_signal_connect (GTK_OBJECT(color_clist), "select_row",
			    GTK_SIGNAL_FUNC(edit_options_color_changed), NULL);
	gtk_widget_set_usize(GTK_WIDGET (color_clist), 0, 200);
      	gtk_widget_show (color_clist);
      	
      	
      	for (tint = 0; tint < 25; tint++)
		gtk_clist_append (GTK_CLIST (color_clist), NULL);
      	style = gtk_widget_get_style(color_clist);
      	
      	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_blue.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 0, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_dark blue.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 1, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_light blue.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 2, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_brown.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 3, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_dark cyan.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 4, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_cyan.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 5, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_gold.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 6, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_dark gray.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 7, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_gray.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 8, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_dark green.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 9, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_light green.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 10, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_green.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 11, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_lavender.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 12, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_magenta.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 13, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_orange.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 14, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_pink.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 15, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_purple.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 16, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_red.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 17, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_salmon.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 18, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_turquoise.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 19, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_wheat.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 20, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_white.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 21, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_yellow.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 22, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_black.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 23, 0, color, mask);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_light gray.xpm");
      	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	gtk_clist_set_pixmap(GTK_CLIST(color_clist), 24, 0, color, mask);
      	
      	label3 = gtk_label_new("Colors");
      	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox7, label3);
      	
      	/*** pixmaps page ***/
      	
      	vbox8 = gtk_vbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (vbox8), 10);
        gtk_widget_show (vbox8);
        
        frame6 = gtk_frame_new("Path to gstalker pixmaps:");
      	gtk_container_border_width (GTK_CONTAINER (frame6), 0);
      	gtk_box_pack_start (GTK_BOX (vbox8), frame6, FALSE, TRUE, 0);
      	gtk_widget_show(frame6);
      	
      	hbox4 = gtk_hbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (hbox4), 5);
        gtk_container_add (GTK_CONTAINER (frame6), hbox4);
        gtk_widget_show (hbox4);
      	
      	pixmaps_entry = gtk_entry_new();
        gtk_box_pack_start (GTK_BOX (hbox4), pixmaps_entry, TRUE, TRUE, 0);
        gtk_entry_set_text(GTK_ENTRY(pixmaps_entry), config.pixmap_path);
        gtk_signal_connect (GTK_OBJECT (pixmaps_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(pixmaps_entry);
      	
      	label4 = gtk_label_new("Pixmaps");
      	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox8, label4);
      	
      	
      	/*** quotes page ***/
      	
      	vbox9 = gtk_vbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (vbox9), 10);
        gtk_widget_show (vbox9);
        
      	frame8 = gtk_frame_new("Proxy Server");
      	gtk_box_pack_start (GTK_BOX (vbox9), frame8, FALSE, TRUE, 0);
      	gtk_widget_show(frame8);
        
      	hbox5 = gtk_hbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (hbox5), 5);
        gtk_container_add (GTK_CONTAINER (frame8), hbox5);
        gtk_widget_show (hbox5);
        
 	label5 = gtk_label_new("Host");       
 	gtk_box_pack_start (GTK_BOX (hbox5), label5, FALSE, TRUE, 0);
      	gtk_widget_show(label5);
      	
      	proxy_entry = gtk_entry_new();
        gtk_box_pack_start (GTK_BOX (hbox5), proxy_entry, TRUE, TRUE, 0);
        gtk_entry_set_text(GTK_ENTRY(proxy_entry), config.proxy);
        gtk_signal_connect (GTK_OBJECT (proxy_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(proxy_entry);
        
        label6 = gtk_label_new("Port");       
 	gtk_box_pack_start (GTK_BOX (hbox5), label6, FALSE, TRUE, 0);
      	gtk_widget_show(label6);
      	
      	port_entry = gtk_entry_new();
        gtk_box_pack_start (GTK_BOX (hbox5), port_entry, TRUE, TRUE, 0);
        sprintf(tstring, "%d", config.port);
        gtk_entry_set_text(GTK_ENTRY(port_entry), tstring);
        gtk_widget_set_usize(GTK_WIDGET (port_entry), 50, 0);
        gtk_signal_connect (GTK_OBJECT (port_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_options_changed), NULL);
        gtk_widget_show(port_entry);
      	
      	label7 = gtk_label_new("Quotes");
      	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox9, label7);
      	
      	GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(ok_button);
      	edit_options_flag = 1;
      	get_object_color();
      	gtk_widget_show(edit_options_window);
      	edit_options_save_flag = 0;
}