/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

unsigned debug_level=3;

#ifdef DEBUG

#include <stdio.h>
#include <stdarg.h>
#include <glib.h>

#include "debug.h"

#ifndef HAVE_VSNPRINTF
extern char* g_vsprintf (const gchar *fmt, va_list *args, va_list *args2);
#endif

void bs_printf(unsigned level, char *format, ...)
{
  char buff[BS_BUFFLEN];

#ifdef HAVE_VSNPRINTF
  va_list args;

  if (debug_level < level)
    return;

  va_start (args, format);
  vsnprintf (buff, BS_BUFFLEN, format, args);
  va_end (args);

#else
  gchar *printed;
  va_list args, args2;

  if (debug_level < level)
    return;

  va_start (args, format);
  va_start (args2, format);

  printed = g_vsprintf (format, &args, &args2);
  strncpy (buff, printed, BS_BUFFLEN);
  buff[BUFFLEN-1] = '\0';

  va_end (args2);
  va_end (args);

#endif             

  fprintf(BS_DEBUG_FILE, "%s\n", buff);

  return;
}

#else

void bs_printf(unsigned level, char *format, ...)
{}

#endif /* DEBUG */
