/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * writecn.c,v 3.2 1998/03/19 14:21:39 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

int writecn(fd,ptr,nbytes)
int fd;
char *ptr;
int nbytes;
{
	int nleft, nwritten, i, j, c;
	char buffer[256], *s;
	
	/* log(8,"writecn: fd %d, nbytes %d", fd, nbytes ); */
	nleft = nbytes;
	while (nleft > 0){
		if( tbcp_enabled ){
			s = buffer;
			for( j = i = 0; i < nleft && j < sizeof(buffer)-2; ++i ){
				switch( (c = ((unsigned char *)ptr)[i])  ){
				case 0x01: case 0x03: case 0x04: case 0x05:
				case 0x11: case 0x13: case 0x14: case 0x1B: case 0x1C:
					s[j++] = 0x01;
					c = c ^ 0x40;
					break;
				}
				s[j++] = c;
			}
			while( j > 0 ){
				nwritten = write( fd, s, j);
				if (nwritten == 0) {
					/* logerr(4,"writecn wrote nothing"); */
				} else if(nwritten < 0) {
					logerr(4,"writecn failure");
					return( -1 );
				}
				j -= nwritten;
				s += j;
			}
			nleft -= i;
			ptr += i;
		} else {
			nwritten = write( fd, ptr, nleft);
			/* log(8,"writecn: wrote %d", nwritten ); */
			if (nwritten == 0) {
				/* logerr(4,"writecn wrote nothing"); */
			} else if(nwritten < 0) {
				logerr(4,"writecn failure");
				return( nbytes-nleft );
			}
			nleft -= nwritten;
			ptr += nwritten;
		}
	}
	return(nbytes);
}
