/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <errno.h>
#include <stdio.h>
#include "mvJob.h"

mvJob::mvJob(FileAccess *session,const char *from,const char *to) : SessionJob(session)
{
   failed=0;
   session->Rename(from,to);
}

int mvJob::Do()
{
   if(Done())
      return STALL;

   int res=session->Done();
   if(res==Ftp::IN_PROGRESS)
      return STALL;
   if(res==Ftp::OK)
   {
      session->Close();
      return MOVED;
   }
   if(res==Ftp::DO_AGAIN)
      return STALL;
   fprintf(stderr,"%s\n",session->StrError(res));
   failed=1;
   session->Close();
   return MOVED;
}

void  mvJob::PrintStatus(int v)
{
   SessionJob::PrintStatus(v);
   if(Done())
      return;
   printf("\t[%s]\n",session->CurrentStatus());
}

void  mvJob::ShowRunStatus(StatusLine *s)
{
   if(Done())
      s->Show("");
   else
      s->Show("[%s]",session->CurrentStatus());
}

void  mvJob::SayFinal()
{
   if(failed)
      return;
   // xgettext:c-format
   printf(_("rename successful\n"));
}
