/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: rglob.cc,v 1.2 1998/09/06 17:30:18 lav Exp $ */

#include <config.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <stdlib.h>

#include "xalloca.h"
#include "ftpclass.h"
#include "rglob.h"
#include "xmalloc.h"
#include "LsCache.h"

static
int   count_slashes(const char *name,int len)
{
   int n=0;
   while(len--)
      n+=(*name++=='/');
   return n;
}

static bool path_match(const char *name,int len,const char *pat)
{
   if(len>=1 && *name=='/')
   {
      if(*pat!='/')
	 return false;
      pat++;
      name++;
      len--;
   }
   for(;;)
   {
      while(*pat)
      {
	 while(*pat=='/')
	    pat++;
	 if(pat[0]=='.' && (pat[1]=='/' || pat[1]==0))
	    pat++;
	 else
	    break;
      }

      if(len<=0)
	 break;

      if(name[0]=='/')
      {
	 name++;
	 len--;
      }
      else if(name[0]=='.' && (len==1 || name[1]=='/'))
      {
	 name+=2;
	 len-=2;
      }
      else if(name[0]=='.' && name[1]=='.' && (len==2 || name[2]=='/'))
      {
	 if(!(pat[0]=='.' && pat[1]=='.' && (pat[2]==0 || pat[2]=='/')))
	    return false;
	 name+=3;
	 len-=3;
	 pat+=2;
      }
      else
      {
	 if(*pat==0)
	    return false;
	 while(*pat && *pat!='/')
	    pat++;
	 while(len>0 && *name!='/')
	 {
	    len--;
	    name++;
	 }
      }
   }
   return *pat==0;
}

RemoteGlob::RemoteGlob(FileAccess *session,char *n_pattern,Ftp::open_mode n_mode)
{
   list=0;
   list_size=0;
   list_alloc=0;
   pattern=n_pattern;
   mode=n_mode;
   f=session;
   inbuf=0;
   buf=0;
   flags=0;
   extra_slashes=0;
   from_cache=false;
   use_cache=true;
   state=INITIAL;
   ptr=buf;
   err_code=f->OK;
}
RemoteGlob::~RemoteGlob()
{
   for(int i=0; i<list_size; i++)
      free(list[i]);
   free(list);
   if(f)
      f->Close();
   xfree(buf);
}

int   RemoteGlob::Do()
{
   int	 num_of_slashes=count_slashes(pattern,strlen(pattern));
   int	 res;
   char	 *nl;
   int   m=STALL;

   if(state==DONE)
      return m;

   if(state==INITIAL)
   {
      if(use_cache && LsCache::Find(f,pattern,mode,&buf,&inbuf))
      {
	 from_cache=true;
      	 ptr=buf;
      }
      else
	 f->Open(pattern,mode);
      state=GETTING_DATA;
      m=MOVED;
   }

   if(!from_cache)
   {
      char tmpbuf[0x1000];
      res=f->Read(tmpbuf,sizeof(tmpbuf));
      if(res==Ftp::DO_AGAIN)
	 return m;
      if(res<0)
      {
	 err_code=res;
	 state=DONE;
	 return MOVED;
      }

      if(res==0)
      {
	 // EOF
	 f->Close();

	 LsCache::Add(f,pattern,mode,buf,inbuf);

	 f=0;
	 state=DONE;
	 return MOVED;
      }
      int offs=ptr-buf;
      buf=(char*)xrealloc(buf,inbuf+res);
      ptr=buf+offs;
      memcpy(buf+inbuf,tmpbuf,res);
      inbuf+=res;
   }

   while((nl=(char*)memchr(ptr,'\n',inbuf-(ptr-buf))))
   {
      int len=nl-ptr;
      if(nl[-1]=='\r')
	 len--;

      // workaround for some ftp servers
      if(ptr[0]=='.' && ptr[1]=='/')
      {
	 ptr+=2;
	 len-=2;
      }
      else if(ptr[0]=='/' && ptr[1]=='/')
      {
	 ptr++;
	 len--;
      }

      if(flags&RESTRICT_SLASHES
	    && count_slashes(ptr,len)>num_of_slashes+extra_slashes)
      	 goto next;

      if(flags&RESTRICT_PATH
	    && !path_match(ptr,len,pattern))
	 goto next;

      // insert new file name into list
      if(list_size>=list_alloc-1)
      {
	 if(list_alloc==0)
	    list_alloc=32;
	 list=(char**)xrealloc(list,(list_alloc*=2)*sizeof(*list));
      }
      list[list_size]=(char*)xmalloc(len+1);
      memcpy(list[list_size],ptr,len);
      list[list_size][len]=0;
      list[++list_size]=0;
   next:
      ptr=nl+1;
   }

   if(from_cache)
      state=DONE;

   return MOVED;
}
