/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/
#ifndef MSERVER_H
#define MSERVER_H

#include <pwd.h>

typedef int bool;
#define false 0
#define true 1

#define MAXCOMMAND 100
#define MAXDATA 1024
#define HASHELEMENTS 101

#ifdef USE_HASH
struct htab {
   struct htab *child;
   struct htab *parent;
   char key[MAXCOMMAND];
   char data[MAXDATA];
};
#else
/* structure representing a single parameter entry, with a key and its value */
struct param_t
{
    char* key;
    char* val;
};

/* structure containing a database of all parameter entries */
struct param_dbase_t
{
    int num_param;
    int space_for_param;
    struct param_t *param;
};
#endif

int getstat(void);

bool config_init (const char *name);
void config_close_save (void);
void config_clear (void);
void config_refresh (int);
void config_getvalue (const char *key, char *value, int maxchar);
bool config_getvalue_bool (const char *key, bool defval);
int config_getvalue_int (const char *key);
void config_getvalue_default (const char *key, char *value, char *defval, int maxchar);
int config_setvalue (const char *key, const char *value);

#ifdef USE_HASH
unsigned int hash(const char *);
struct htab *addhash(const char *, const char *);
struct htab *findhash(const char *);
int delhash(const char *);
void inittab(void);
#else
/* prototypes */
void init_param_dbase(struct param_dbase_t* dbase);
void param_dbase_setval(struct param_dbase_t* dbase, const char* key, const char *val);
char* param_dbase_getval(const struct param_dbase_t* dbase, const char* key);
void clear_param_dbase(struct param_dbase_t* dbase);
#endif

int gettoken(char *);

void ungetch(int);
int getch(void);

void mserver_serve(void);

void mserver_list(void);
void mserver_kill(void);
void mserver_dial(char *);
void mserver_cinfo(char *);
void mserver_time(void);
void mserver_stat(void);

void mserver_info_var (char *);
void mserver_info_file (char *);

void mserver_halt(int);
void mserver_halt_all(void);

bool cfile_write(char *);
void cfile_unlink();

bool parse_pppd(void);
bool parse_pppd_init(void);

int util_system (const char *);
void util_sleep (int);

bool auth_check(const char *);
bool auth_checkip(const char *);
bool auth_checkip_backend(const char *, const char *);
bool auth_checkuser(const char *);
void auth_setpass (const char*);
void auth_setuser (const char*);
struct passwd *auth_getpwent(const char*);

int sock_host(int fd, char addr_string[], int limit);

#endif
