# Password setting and checking library.

package Password;

# Returns a crypted password
sub encrypt {
	my $password=shift;
	
	my @valid = map (chr,((ord('.')..ord('9')),(ord('A')..ord('Z')),(ord('a')..ord('z'))));
	my $salt = $valid[rand($#valid+1)].$valid[rand($#valid+1)];
	
	return crypt($password,$salt)
}

# Pass it a plaintext password and a crypted one, returns true
# if the plaintext password is ok.
sub check {
	my $plaintext=shift;
	my $crypted=shift;

	if (crypt($plaintext, $crypted) eq $crypted) {
		return 1;
	}
	else {
		return undef;
	}
}

1
