.TH PFTP 1L "GNU File Transfer Utilities" "FSF" \" -*- nroff -*-
.SH NAME
pftp \- file transfer program
.SH SYNOPSIS
.br
Server:
.B pftp
[portnumber] [OPTIONS]
.br
.br
Client:
.B pftp
[portnumber] [OPTIONS] [hostname] [files]
.BR
.SH DESCRIPTION
This manual page
documents the GNU version of
.BR pftp .
.BR pftp
copies files from host to host.  All line feed characters contained in
file and directory names are transfered to underline characters.  There
is no authorization mechanism necessary but possible.  Up to five
connections are possible at a time.  If pftp is started by inetd the
number of connections is unlimited.  First the server has to be started
at the destination host with a port number in the range of 1025 and at
least 32767.  Thereafter the client may send files to the port of the
destination host.  See section
.BR EXAMPLES
for further information.

.SS OPTIONS
.TP
.I "\-"
The client sends all standard input to the destination host.
If the client and the server are started with this option, the
server sends all bytes to standard output.  If on the other
hand the server was started with this option, but the client
sends regular files, the server copies all files within the
first connection and exits afterwards. If only the client was
started with the option, the server copies the received stream
to a file called
.IR Stream.x .
.IR x
is an increasing number beginning at 1.  The default buffer size for
`-' is BUFSIZ (probably 1024).  
.TP
.I "\-a"
Always overwrite existing files. (Server option only)
.TP
.I "\-b[NUM]"
Same as `-' except that all sent data is buffered.  You may set the
buffer size with `NUM'.
.BR pftp
does not limit this value.  So whatever your system supports you may
set (see
.BR BUGS ).
Values between one and 32767 are always possible.  The default buffer
size for `-b' is 4096.
.TP
.I "\-bb"
Same as `-b32767'.
.TP
.I "\-B"
Sets the maximum net buffer size, i.e. package size, specified by
variable
.IR PFTPNETBUF
(see
.BR ENVIRONMENT ).
The default maximum net buffer size is 32767.  This applies not to data
sent from standard input (see `-b').
.TP
.I "\-c hostnames"
Connections are accepted from clients with specified host names only.
All other clients are simply refused. Host names can also be given
as numbers which are looked up in your
.BR pftp
resource file (see
.BR RESOURCES ).
If no host names are specified the environment variable
.IR PFTPCLIENTS
is read instead (see
.BR ENVIRONMENT ).
You may also specify domain names:  All client host names that begin
with a dot are supposed to be domain names.
(Server option only)
.TP
.I "\-d[=DIR]"
The daemon works just like the server started from inetd (see `-i' ).
There are just two differences:  First the daemon keeps running (see
.BR BUGS )
and second the daemon may be started by a normal user.  If your system
has shadow password you have to set the variable
.IR PFTPPASS
unless the daemon is running with root  privileges.
The client needs this option to send data to the daemon.
.TP
.I "\-e"
Create a normal Unix (MD5) password with crypt().  You may need the
password if you want to set the variable
.IR PFTPPASS .
.TP
.I "\-f[n]"
Filter all files before sending them over the network, i.e. the
standard output of the filter on the client side is connected to the
standard input of the filter on the server side.  The filters are
specified by
.IR PFTPCFILTER
respectively
.IR PFTPSFILTER
(see
.BR ENVIRONMENT ).
.TP
.I "\-i[=DIR]"
Start
.BR pftp
from `/etc/inetd.conf' by inetd.  You do need a system pftp resource file
which is located in `/etc/pftp.conf'.  If there is no resource file the
connection is closed.  The following lines may be specified in
`/etc/inetd.conf' (see
.BR inetd (8))
and `/etc/services' (see
.BR services (5))
in order to start the
.BR pftp
server by inetd with the capability to copy files as well as
directories and to accept specified clients only:
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
for `/etc/inetd.conf' (all on one line):
pftp stream  tcp  nowait  root
/usr/local/bin/pftp pftp -irc
.sp
for `/etc/services':
pftp     27/tcp
.fi
.RE
.sp
.TP
.I ""
At first
.BR pftp
reads the system resource file located in `/etc/pftp.conf' and gets the
user name and the number of the filter program to be used from the
client.  Both is send raw through the net,  i.e. a port sniffer may see
them.  Then
.BR pftp
starts two subprocesses and changes their setuid/setgid bits to
the user's setuid/setgid bits--root is denied by default (see
.BR PFTPNOROOT ).
Now the password is send filtered through the net.  Thus it is up to you
to decide which level of security you need.  The server changes the
directory to DIR if given by the client or to the user's home directory
and sets the environment variables `HOME' and `USER' appropriately.  The
user must have a
.BR pftp
resource file in his/her home directory from which the filter program is
to be read.
.sp
The client needs this option to send data to the server
started by inetd and to set the destination directory DIR which is set to
the remote user's home directory if =DIR is omitted.  The port
number is set to 27.  The port number found in the
.BR pftp
resource file is
ignored.
.TP
.I "\-l"
List host names from file `.pftprc' and send files. Cannot be used in
standard input mode!  (Client option only)
.TP
.I "\-m[=FILE]"
In combination with `-n' the message file FILE will be added to the data.
If =FILE is omitted: interactively edit a message file (see
.IR PFTPEDITOR ).
.TP
.I "\-N"
Peek for new data in the upload directory.
.TP
.I "\-n"
If no further options are given starts the simple
.BR pftp
file and directory manager.  Else: Send data to another user.  The other
user must have set the variable
.IR PFTPRECEIVE
to the absolute path of an upload directory (see
.BR ENVIRONMENT ).
On the remote host
.BR pftp
has to be started by inetd (see `-i') or run
as a daemon (see `-d').
.TP
.I "\-n=SUBJECT"
Same as `-n' but also add subject line SUBJECT to the data.
.TP
.I "\-nn"
Same as `-n' but interactively ask for a subject line and add that line
to the data.
.TP
.I "\-NUM"
Choose host NUM from host name list. (Client option only)
.TP
.I "\-oN1oN2..."
Seek the N1th offset from the beginning of the first file, the N2th offset
from the beginning of the second file etc.  If a file is incomplete
received then you may try to send just the missing part of the file, i.e.
N1 respectively N2 is the size of the incomplete file. I suggest to
truncate the incomplete file by a several bytes at first. Then start the
server in the appropriate directory and choose `a' when the
server asks you. Nevertheless this option is still experimental! (Client option only)
.TP
.I "\-q"
Silent mode.  Unless a serious error occurs no output will be delivered.
By default all existing files are skipped.  If option `-a' is given on
command line all existing files are overwritten.  If the environment variable
.IR PFTPSLOG
is set to the absolute path of a log file, the server
logs all data normally written to stderr
(see
.BR ENVIRONMENT ).
This option was meant for shell skripts and the like.
.TP
.I "\-r"
If the server and the client are started with this option,
all files received from the client are copied into the
appropriate directories. If necessary
.BR pftp
creates new directories within the current directory, i.e.
the directory where the server was started from. If only
the client is started with this option, all files sent by
the client are copied into the current directory.
.TP
.I "\-s"
Always skip existing files. (Server option only)
.TP
.I "\-W"
Sets bandwidth in bytes per second specified in variable
.IR PFTPBANDWID .
(Client option only)
.TP
.I "\-w"
Displays the warranty.
.PP
.SS EXAMPLES
In order to send two files start the server with a port number at
your choice at the destination host (port numbers between 1025 and
32767 are always legal unless they are in use\-\-then simply choose
another port number):
.sp
.RS +.5i
pftp 1234
.RE
.sp
Then start the client with the same port number at the origin host:
.sp
.RS +.5i
pftp 1234 destinationhost file1 file2
.RE
.sp
The server is waiting for connections until you kill it, e.g. with ^C.
.PP
Now we want to copy the current directory including all subdirectories.
Start the server at the destination host with option `-r':
.sp
.RS +.5i
pftp 1234 -r
.RE
.sp
And analogeously start the client with the same option:
.sp
.RS +.5i
pftp 1234 -r destinationhost .
.RE
.sp
I suggest to create the file `.pftprc' to start
.BR pftp
with a default port number. See section
.BR RESOURCES
for further details.
.sp
To send standard input using the default port number  start the server with
option `-' and redirect the standard output wherever you want to:
.sp
.RS +.5i
pftp - > file
.RE
.sp
The client is started as usual but this time with option `-':
.sp
.RS +.5i
pftp - destinationhost_or_host_number < file
.RE
.sp
Imagine you want to send files to a pftp server started by inetd and
upload the files in the directory `$HOME/misc' where `$HOME' is the
remote user's home directory.  If the remote host name is for example
listed in your host name list as number one you may want to use the
following
.sp
.RS +.5i
pftp -1i=misc files
.RE
.sp
If your host name list entry does not contain the remote user's login
name and maybe the password you will be asked for login name and
password.
.sp
Now lets send data to a friend of whom you have no password.  The
destination host is listed in your host name list as number 7.  Further
more you want to use a filter program for the connection and also send not
merely files but also directories.  Thus all you have to type is 
.sp
.RS +.5i
pftp -7frn data
.RE
.sp
where data is files and directories.  In this case the first filter
listed in your filter variable will be used which is the opposite filter
program of the other user's first filter program.
.sp
.SH RESOURCES
There are two resource files
.BR pftp
may read in.  The system resource file `/etc/pftp.conf' is read in when
pftp is started as a server by inetd or if started as a daemon by root.
The user's resource file `~/.pftprc' is read otherwise.  Both files have
the following format:  At first all needed variables have to be specified
and at the end of the file goes the host name list.  Host names may be
followed by a port number (in the same line).  If no port number is given
the default one set with
.IR PFTPPORT
is used.
Variables are set in the resource file like the following:
.sp
.RS +.5i
.ta 0.5i 1.0i
.nf
PFTPPORT 1234
.fi
.RE
.sp
A host name list entry may look like one of these:
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
username:passwd@hostname port
username:passwd@hostname
username@hostname port
username@hostname
hostname port
hostname
.fi
.RE
.sp
username is the name of the remote user if you send data to the daemon or
to the server started by inetd.  passwd is remote user's password.  If
you send data to the normal server username and passwd are ignored. Of
course the password is not shown if
.BR pftp
was started with `-l'.  Empty lines and all comments between a `#' and
the end of a line are ignored.
.sp
.SH ENVIRONMENT
Variables denoted with `<*>' may also be set as environment variables.
Command line settings have highest priority; environment variables have
higher priority than variables specified in the resource file.
.TP
.I PFTPBANDWID <*>
Holds value of bandwidth (see `-W') in bytes per second.  By default
.BR pftp
sends as fast
as possible.
.TP
.I PFTPCFILTER and PFTPSFILTER <*>
If on the client side variable
.IR PFTPCFILTER
and on the server side variable
.IR PFTPSFILTER
hold names of filter programs with possible options the filters will
be used if `-f' is given on command line.  The variables may hold
several filters.  All filter programs have to be seperated by a colon.
You may choose a specific filter program with `-fn' where n is the
number of the filter program.  The first filter program has number 1.
If n is not given the first filter program will be used.  In order to
list all client filters set n to C, to list all server filters set n
to S.  Keep in mind that the filter on the client side is just the
opposite of the filter on the server side!
.TP
.I PFTPCLIENTS <*>
May hold all client host names that are accepted.  The names are
seperated by spaces.  So if `-c' follows no host name that variable is
read instead.  Of course the client may fake its host name as long as
a user has root privileges and hacks the client's source code.  But
since the server does not create files or directories in upper
directories no user should have a real interest to make an effort to
hack the source code.  For security reasons you may choose an
encryption filter for the connection with option `-fn'.  The special
host name `.unkown_host' allows every remote host to connect if remote
host's host name cannot be resolved or the nameserver is unreachable.
.TP
.I PFTPEDITOR <*>
Holds the name of the editor.  The default editor is `vi'.
.TP
.I PFTPLOG <*>
If the environment variable
.IR PFTPLOG
is set to the absolute path of an error file, the client logs all error
messages that occur while sending files in the error file.  Since the
client does not exit on errors concerning unreadable or empty files and
directories, it might be useful to log the error messages.  So you can
send these mostly few files afterwards.
.TP
.I PFTPLOGFILE
If set to 1 and
.BR PFTPSLOG
is set logs also all file and directory names being transfered.
.TP
.I PFTPNETBUF <*>
Sets the maximum net buffer size in bytes (see `-B') unless you send data
from standard input (see `-b').
.TP
.I PFTPNOROOT
If set to 0 allows root `login' when
.BR pftp
is running as a daemon with root privileges (see `-d') or was started by
inetd (see `-i').  The default setting is 1.
.TP
.I PFTPPAGER <*>
Holds the name of the pager.  The default pager is
.BR pftp's
internal pager.
.TP
.I PFTPPASS
If set to an encrypted normal Unix password (MD5) it is used instead of
the user's system password (see `-e').  If your system has shadow
password and you want to run the daemon without root privileges you do
need this variable to be set.  You may set it to `*' in order to deny
uploading at all.
.TP
.I PFTPPORT
Holds the default port number.
.TP
.I PFTPRECEIVE
Holds the absolute path of an upload directory for files and directories
sent by other users (see `-n').  If this variable is unset no other user
will be aloud to upload files and directories.
.TP
.I PFTPSLOG <*>
If set to the absolute path of a log file the daemon as well as
the server started by inetd log all connections.
.TP
.I PFTPSORTBY
Determines sorting order within the pfm.  May be set to `a' for
alphabetical (this is the default setting), `s' for size, and `t' for
time.
.TP
.I PFTPUPLIMIT
Sets a limit in kilo bytes to the upload directory (see
.BR PFTPRECEIVE ).
The size defaults to 2048 kilo bytes.
.SH AUTHOR
Ben Schluricke
.SH DEDICATION
This program is dedicated to
.BR "Heather O'Rourke" .
.SH "SEE ALSO"
ftp(1), rcp(1), scp(1)
.SH BUGS
Setting the buffer size to zero may crash older systems.  So you should
use a buffer size of zero for test purposes only.  Most newer systems set
a buffer size of zero to one by default.
.sp
FreeBSD's and Sun's OS do not notice when a child process exits.  Thus
when starting the daemon (see `-d') the number of zombies increases with
every new connection.  If you then terminate the daemon all zombies have
gone.  By now I couldn't find a work around that feature. Sorry!
You may see the latest bug report and the latest version of pftp at
`http://star.trek.org/~pftp'.

If you find any bug, please drop me an e-mail.
.sp
.RS +.5i
bhor0533@lehr.chem.TU-Berlin.DE
.RE
.sp
Every comment via e-mail will be appreciated!
