/* filename: rlpr-rfc1179.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlpr-rfc1179.h,v 1.1 1997/02/22 21:41:08 meem Exp meem $
 * contents: constants and limits listed in rfc 1179
 *
 * Time-stamp: <1997/02/23 04:10 -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPR_RFC1179_H
#define RLPR_RFC1179_H

/* NOTHING IN THIS HEADER FILE SHOULD NEED TO BE CHANGED */

/* these are needed by all rlpr clients and also by rlprd.  in some sense,
 * rlprd really is just another lpd client, so their definitions go here.
 */

#define LO_LPD_DST_PORT         721      /* INCLUSIVE */
#define HI_LPD_DST_PORT         731      /* INCLUSIVE */
#define LPD_DST_PORT            515

enum { DONE = 0, PRINTQ, RECVJ, SENDQS, SENDQL, REMJ };
enum { ABORTJ = 1, RECVCF = 2, RECVDF = 3};

#define MAX_STR_LEN       255
#define MAX_USER_LEN      31
#define MAX_SOURCE_LEN    131
#define MAX_JOB_LEN       99
#define MAX_CLASS_LEN     31
#define MAX_TITLE_LEN     79
#define MAX_HOST_LEN      31
#define MAX_FILE_LEN      64	      /* not defined in rfc 1179 */
#define MAX_QUEUE_LEN     64	      /* not defined in rfc 1179 */

#define DEFAULT_WIDTH           "132"
#define DEFAULT_WIDTH_NO_PARAM  "80" 
#define DEFAULT_INDENT_NO_PARAM "8"   /* not defined in rfc 1179 */

#endif  /* RLPR_RFC1179_H */
