'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH Tnm::syslog n "December 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::syslog \- Write messages to the system logger.
.SH SYNOPSIS
.BI Tnm::syslog " level message"
.BE

.SH DESCRIPTION
The \fBTnm::syslog\fR command allows a Tcl script to write a \fImessage\fR
to the system logger. Further processing of the message depends on the
priority \fIlevel\fR of the message and the configuration of the
system message logging facility. Allowed priority levels are:
.TP 16
.SB emergency
A panic condition.  This is normally broadcast to all users.
.TP
.SB alert
A condition that should be corrected immediately,
such as a corrupted system database.
.TP
.SB critical
Critical conditions, such as hard device errors.
.TP
.SB error
Errors messages.
.TP
.SB warning
Warning messages.
.TP
.SB notice
Conditions that are not error conditions,
but that may require special handling.
.TP
.SB info
Informational messages.
.TP
.SB debug
Messages that contain information
normally of use only when debugging a program.
.PP
Not all system message logging facilities support all priority
levels. The Tnm extension will automatically convert these priorities
into levels understood by the local system message logging facility
if needed.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
