
# Description:  The following procedures and commands help you to
#               manage lists of channel operators of certain channels.
#               Please see the comments below!
#               
# Date:         03.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
#               06.10.97  Small changes to output-messages.
#               30.09.97  Command `/gad' was improved.
#               25.07.97  Command `/gad' was added.
#                         See also install-instructions!
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/chops.tcl'
#               2. edit arrays `chop_file' and `chop_sources'
#                  (see the examples below)
#               3. reload your tkircrc or restart tkirc


# chop_file & chop_sources:
#          For each of your preferred channels you can add an element to
#          array `chop_file' and one to array `chop_sources'.
#          If a user with a matching address to an element of
#          `chop_sources(<channel>)' promotes someone else to channel
#          operator, the address of this new channel operator will be
#          logged to file `$chop_file(<channel>)'. Please see the examples
#          below!
#
#          NOTE: The indices of these arrays have to be lowercase!
#
global chop_file chop_sources
set chop_file(\#tkirc) "~/.tkirc/chops-tkirc"
set chop_sources(\#tkirc) {
    "atte@gecko.north.de"
}

# on_join_chops: The saved list of known channel operators will 
#                automatically be loaded, when you join that certain
#                channel.
proc on_join_chops { } {
  global on_args chop_file choplist nickname

  set lo "[string tolower "$on_args(channel)"]"
  if {[strcmp "$nickname" "$on_args(nick)"] == 0} {
    if {[info exists chop_file($lo)]} {
      print2crap "+++ Loading choplist for channel $on_args(channel)..."
      set choplist($lo) ""
      set file "[OpenFile "$chop_file($lo)" r]"
      if {[string length "$file"]} {
        while {[gets $file line] >= 0} {
	  set line "[string trim "$line" " "]"
	  if {"$line" != "" && "[string index "$line" 0]" != "#"} {
	    lappend choplist($lo) "$line"
	  }
        }
        close $file
      }
    }
  }
}

# on_modechange_chops: The list of known channel operators will
#                      automatically be extended when a member of
#                      `chan_sources(<channel>)' gives someone a `+o'.
proc on_modechange_chops { } {
  global on_args chop_sources chop_file choplist ctcp_nooplist

  set lo "[string tolower "$on_args(to)"]"
  if {[strcmp "+o" "$on_args(mode)"] == 0 \
    && [info exists chop_sources($lo)] \
    && [info exists chop_file($lo)] \
    && [info exists choplist($lo)]} {

    for {set i 0} {$i < [llength "$chop_sources($lo)"]} {incr i} {
      if {[strmatch "[lindex "$chop_sources($lo)" $i]" "[StripAddressPrefix "$on_args(address)"]"]} {
	set address "[AddressOfNick "$on_args(argument)"]"
	if {[string length "$address"]} {
	  if {[info exists ctcp_nooplist] && [ctcp_nooptest "$address"]} {
	    return
	  }
	  set file "[OpenFile "$chop_file($lo)" a]"
	  if {[string length "$file"]} {
	    for {set i 0} {$i < [llength "$choplist($lo)"]} {incr i} {
	      if {[strmatch "[lindex "$choplist($lo)" $i]" "$address"]} {
		close $file
		return
	      }
	    }
	    print2crap "+++ New operator found ($address) for channel $on_args(to)"
	    lappend choplist($lo) "$address"
	    puts $file "# $on_args(nick)!$on_args(address)  ([longdate])"
	    puts $file "$address"
	    close $file
	    return
	  }
	}
      }
    }
  }
}

# on_command_loadchoplist: When you've edited the choplist-file of a channel, 
#                          you should execute this command (`/loadchoplist')
#                          to update the list in memory.
proc on_command_loadchoplist {window arguments} {
  global on_args chop_sources chop_file choplist win

  set len [lLength "$arguments"]
  if {$len < 1} {
    print2crap "+++ Usage: /loadchoplist <channel>"
    return
  }

  set channel "[lIndex "$arguments" 0]"
  if {"$channel" == "*"} {
    set channel "$win($window,actual)"
  }
  set lo "[string tolower "$channel"]"

  if {[info exists chop_file($lo)]} {
    print2crap "+++ Loading choplist for channel $channel..."
    set file "[OpenFile "$chop_file($lo)" r]"
    if {[string length "$file"]} {
      set choplist($lo) ""
      while {[gets $file line] >= 0} {
	set line "[string trim "$line" " "]"
	if {"$line" != "" && "[string index "$line" 0]" != "#"} {
	  lappend choplist($lo) "$line"
	}
      }
      close $file
    }
  } else {
    print2crap "+++ No choplist-file found for channel $channel"
  }
}

# on_command_chops: This command (`/chops') will show you known channel
#                   operators of a certain channel without `+o'.
proc on_command_chops {window arguments} {
  global chan win choplist ctcp_nooplist

  set len [lLength "$arguments"]
  if {$len < 1} {
    print2crap "+++ Usage: /chops <channel>"
    return
  }

  set count 0
  set channel "[lIndex "$arguments" 0]"
  if {"$channel" == "*"} {
    set channel "$win($window,actual)"
  }
  set lo "[string tolower "$channel"]"

  set cnum [GetChannelNumber "$channel"]
  if {$cnum != -1} {
    if {[info exists choplist($lo)]} {
      set len [llength "$chan($cnum,addresses)"]
      for {set i 0} {$i < [llength "$choplist($lo)"]} {incr i} {
        for {set j 0} {$j < $len} {incr j} {
	  if {[strmatch "[lindex "$choplist($lo)" $i]" "[lindex "$chan($cnum,addresses)" $j]"]} {
	    if {[info exists ctcp_nooplist] && [ctcp_nooptest "[lindex "$chan($cnum,addresses)" $j]"]} {
	      continue
	    }
	    if {[lindex "$chan($cnum,olist)" $j] == 0} {
	      if {$count == 0} {
	        print2crap "+++ Known CHOPs without @ on channel $channel:"
	      }
	      print2crap "+++ - [lindex "$chan($cnum,nicks)" $j] ([lindex "$choplist($lo)" $i])"
	      incr count
	    }
	  }
	}
      }
      if {$count == 0} {
        print2crap "+++ No known CHOPs without @ found on channel $channel"
      }
    } else {
      print2crap "+++ No list of CHOPs available for channel $channel"
    }
  } else {
    print2crap "+++ You are not on channel $channel"
  }
}

# on_command_gad: tkirc automatically gets addresses of users when they join 
#                 one of your channels or when you make a /whois on them.
#                 The command `/gad' will get the lacking user-addresses of
#                 a given channel (maybe of users which joined that channel
#                 before).
#                 Be careful, because on channels with many users this 
#                 command will make a lot of traffic and could take a 
#                 while!
proc on_command_gad {window arguments} {
  global chan win choplist crapwindow

  set len [lLength "$arguments"]
  if {$len < 1} {
    print2crap "+++ Usage: /gad <channel>"
    return
  }

  set channel "[lIndex "$arguments" 0]"
  if {"$channel" == "*"} {
    set channel "$win($window,actual)"
  }

  set cnum [GetChannelNumber "$channel"]
  if {[info exists chan($cnum,addresses)]} {
    set len [llength "$chan($cnum,addresses)"]
    for {set i 0} {$i < $len} {incr i} {
      if {[string length "[lindex "$chan($cnum,addresses)" $i]"] == 0} {
        AddToWhoQueue "$channel" "$crapwindow" "+++ gad: Trying to get the user-addresses of channel $channel..." "+++ gad: All user-addresses of channel [expand "$channel"] available"
	return
      }
    }
    print2crap "+++ gad: All user-addresses of channel $channel already available"
  }
}
