/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "style.h"
#include "xchat.h"
#include <time.h>

extern struct xchatprefs prefs;
extern GSList *sess_list;
extern struct dialog firstdialog;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GdkColor colors[];

extern unsigned long dcc_write_chat(char *nick, char *text);
struct dialog *new_dialog(struct server *serv, char *nick);
extern void dcc_send_filereq(struct session *sess, char *nick);
extern void PrintTextRaw(GtkWidget *textwidget, unsigned char *text, char, char, GdkFont *normal, GdkFont *bold);


struct dialog *find_dialog(struct server *serv, char *nick)
{
   struct dialog *dial = &firstdialog;
   do
   {
      if(dial->used && dial->serv == serv)
      {
	 if(!strcasecmp(nick, dial->nick)) return(dial);
      }
      dial = dial->next;
   } while(dial);
   return 0;
}

int add_to_dialog(struct server *serv, char *outbuf, char *nick, char *text, char *ip, int notice)
{
   struct dialog *dial = find_dialog(serv, nick);
   if(!dial)
   {
      if((prefs.flags&(1<<PREFS_AUTODIALOG)) && !notice) dial = new_dialog(serv, nick);
   }
   if(!dial) return(FALSE);

   if(notice)
     sprintf(outbuf, "\00312-\00313%s\00312- \003 %s\n", nick, text);
   else
     sprintf(outbuf, CHANNEL_MSG, nick, text);
   PrintTextRaw( dial->listgad, outbuf,
		prefs.dialog_bg_color, prefs.dialog_fg_color,
		dialog_font_normal, dialog_font_bold );

   if(dial->ip[0] == 0)
   {
      strcpy(dial->ip, ip);
      gtk_entry_set_text((GtkEntry*)dial->ipgad, ip);
   }

   return(TRUE);
}

void handle_dialog(GtkWidget *igad, struct dialog *dial)
{
   unsigned long ip;
   char outbuf[300];
   char *text = gtk_entry_get_text((GtkEntry *)igad);
   
   if(*text == 0) return;
   
   if((ip = dcc_write_chat(dial->nick, text)))
   {
      /*if(dial->ip[0] == 0)
      {
	 unsigned char *a = (char *)&ip;
	 sprintf(dial->ip, "%d.%d.%d.%d", a[3], a[2], a[1], a[0]);
	 gtk_entry_set_text(GTK_ENTRY(dial->ipgad), dial->ip);
      }*/
   } else {
      if(!(dial->serv->flags&(1<<0))) goto jump;
      sprintf(outbuf, "PRIVMSG %s :%s\r\n", dial->nick, text);
      send(dial->serv->sok, outbuf, strlen(outbuf), 0);
   }

   sprintf(outbuf, CHANNEL_MSG_FROM_USER, dial->serv->nick, text);
   PrintTextRaw(dial->listgad, outbuf, prefs.dialog_bg_color, prefs.dialog_fg_color,
		dialog_font_normal, dialog_font_bold);
   jump:
   gtk_entry_set_text((GtkEntry *)igad, "");
}

void dialog_whois(GtkWidget *wid, struct dialog *dial)
{
   char tbuf[256];
   sprintf(tbuf, "WHOIS %s\r\n", dial->nick);
   send(dial->serv->sok, tbuf, strlen(tbuf), 0);
}

void dialog_send(GtkWidget *wid, struct dialog *dial)
{
   GSList *list = sess_list;
   struct session *sess;
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == dial->serv)
      {
	 dcc_send_filereq(sess, dial->nick);
	 return;
      }
      list = list->next;
   }
}

void dialog_ping(GtkWidget *wid, struct dialog *dial)
{
   if( dial->serv->flags&(1<<0) ) // IF CONNECTED
   {
      char tbuf[128];
      long t;
      time(&t);
      sprintf(tbuf, "PRIVMSG %s :\001PING %ld\001\r\n", dial->nick, t);
      send(dial->serv->sok, tbuf, strlen(tbuf), 0); 
   }
}

void close_dialog(GtkWidget *wid, struct dialog *dial)
{
   gtk_widget_destroy(dial->window);
   dial->used = 0;
}

void open_dialog_window(struct dialog *dial)
{
   GtkWidget *hbox, *vbox, *wid;
   
   dial->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize(dial->window, 300, 100);
   gtk_window_set_title(GTK_WINDOW(dial->window), dial->nick);
   gtk_signal_connect(GTK_OBJECT(dial->window),
                             "destroy",
                             GTK_SIGNAL_FUNC(close_dialog),
                             dial);
   
   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(vbox), 3);
   gtk_container_add(GTK_CONTAINER(dial->window), vbox);
   gtk_widget_show(vbox);
   
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
   gtk_widget_show(hbox);
   
   dial->ipgad = gtk_entry_new();
   gtk_entry_set_editable((GtkEntry *)dial->ipgad, FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), dial->ipgad);
   gtk_widget_show(dial->ipgad);

   wid = gtk_button_new_with_label("WhoIs");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_whois), dial);
   gtk_widget_show(wid);
   
   wid = gtk_button_new_with_label("Send");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_send), dial);
   gtk_widget_show(wid);
   
   wid = gtk_button_new_with_label("Ping");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_ping), dial);
   gtk_widget_show(wid);
   
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(vbox), hbox);
   gtk_widget_show(hbox);
   
   dial->listgad = gtk_text_new(0, 0);
   {
      GtkStyle *style = gtk_style_new();
      memcpy(style, gtk_widget_get_style(dial->listgad), sizeof(GtkStyle));
      memcpy(style->base, &colors[prefs.dialog_bg_color], sizeof(GdkColor));
      memcpy(style->bg, &colors[prefs.dialog_bg_color], sizeof(GdkColor));
      memcpy(style->fg, &colors[prefs.dialog_fg_color], sizeof(GdkColor));
      gtk_widget_set_style(dial->listgad, style);
   }
   gtk_text_set_word_wrap(GTK_TEXT(dial->listgad), TRUE);
   gtk_text_set_editable(GTK_TEXT(dial->listgad), FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), dial->listgad);
   gtk_widget_show(dial->listgad);
   
   wid = gtk_vscrollbar_new(GTK_TEXT(dial->listgad)->vadj);
   gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_widget_show(wid);
   
   dial->inputgad = gtk_entry_new_with_max_length( 255 );
   gtk_box_pack_end(GTK_BOX(vbox), dial->inputgad, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(dial->inputgad), "activate",
		      GTK_SIGNAL_FUNC(handle_dialog), dial);
   /*gtk_signal_connect (GTK_OBJECT (sess->inputgad), "key_press_event",
	               GTK_SIGNAL_FUNC(handle_keypress), sess);*/
   gtk_widget_show(dial->inputgad);
   gtk_widget_grab_focus(dial->inputgad);
   
   gtk_widget_show(dial->window);
}

struct dialog *new_dialog(struct server *serv, char *nick)
{
   struct dialog *dial = &firstdialog;
   struct dialog *prev;
   while(1)
   {
      if(dial->used == 0)
      {
	 dial->used = 1;
	 dial->serv = serv;
	 dial->ip[0] = 0;
	 strcpy(dial->nick, nick);
	 open_dialog_window(dial);
	 return(dial);
      }
      prev = dial;
      dial = dial->next;
      if(!dial)
      {
	 dial = malloc(sizeof(struct dialog));
	 if(dial)
	 {
	    memset(dial, 0, sizeof(struct dialog));
	    prev->next = dial;
	 } else
	   return 0;
      }
   }
}
			  
void free_dialogs(void)
{
   struct dialog *next;
   struct dialog *dial = firstdialog.next;
   while(dial)
   {
      next = dial->next;
      free(dial);
      dial = next;
   }
}
