#ifndef __RNewsgroup_h__
#define __RNewsgroup_h__

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/file.h>
#include <unistd.h>
#include <utime.h>
#include <errno.h>
#include <time.h>
#include <fcntl.h>
#include <stdlib.h>
#include <limits.h>

#include <iostream.h>
#include <fstream.h>
#include <string>

#include "config.h"
#include "Debug.h"
#include "OverviewFmt.h"
#include "Newsgroup.h"
#include "NServer.h"

#ifdef ENABLE_NOTCACHED
// This is a little bit ugly and needs some more documentation
class RNewsgroup: public Newsgroup {

  string *_OverviewDB;
  unsigned int first,last;
  
  // News stuff
  RServer *_RemoteServer;
public:
  RNewsgroup() : Newsgroup(NULL,NULL) {}
  RNewsgroup(RServer *srvr,OverviewFmt *fmt, const char *name)
    : Newsgroup(fmt,name), _RemoteServer(srvr) 
  {
    _OverviewDB=NULL;
    first=1; last=0;
  }
  ~RNewsgroup() { if(_OverviewDB) delete[] _OverviewDB; }

  virtual void getsize(unsigned int *f, unsigned int *l) {
    *f=first; *l=last;
  }

  virtual void setsize(unsigned int f, unsigned int l);

  virtual void prefetchGroup(int lockgrp=1) {}
  virtual void prefetchOverview(void) {}

  virtual unsigned int firstnbr() { return first; }
  virtual unsigned int lastnbr() { return last; }
  virtual int hasrecord(unsigned int i) { 
    if(_OverviewDB && first<=i && i<=last && _OverviewDB[i-first]!="")
      return 1;
    return 0;
  }

  virtual Article *getarticle(unsigned int nbr);
  virtual void freearticle(Article *artp) {}
  virtual void setarticle(Article *art) {}
  virtual void printarticle(ostream &os,unsigned int nbr);

  virtual const char *getover(unsigned int nbr) {
    static const char *n="";
    if(_OverviewDB && first<=nbr && nbr<=last) 
      return _OverviewDB[nbr-first].c_str();
    return n;
  }
  virtual void setover(string over) {
    unsigned int i=atoi(over.c_str());
    if(_OverviewDB && first<=i && i<=last) {
      _OverviewDB[i-first]=over;
    }
  }
  virtual void readoverdb(istream &is) {
    VERB(slog.p(Logger::Debug) << "RNewsgroup::readoverdb(&is)\n");
    string line1, line2;

    for(;;) {
      nlreadline(is,line1,0);
      if(line1=="." || is.eof()) break;
      if(_OverviewFormat->dotrans) {
	// Convert Record
	_OverviewFormat->convert(line1,line2);
	setover(line2);
      } else {
	setover(line1);
      }
    }
  }

  virtual void printheaderdb(ostream &os, 
			     const char *header, 
			     unsigned int f=0, unsigned int l=UINT_MAX) {
    char xheader[512],*p;
    const char *q;
    string fld;
    unsigned int i,n;
    n=last-first+1;

    p=xheader; q=header;
    while((*p++=*q++));
    *(p-1)=':';
    *p='\0';    
    for(i=0;i<n;i++) {
      if(_OverviewDB[i]!="") {
	fld=_OverviewFormat->getfield(_OverviewDB[i].c_str(),xheader,0);
	os << i << " " << fld << "\r\n";
      } else {
	os << i << "(none)\r\n";
      }
    }
    
  }
  virtual void printlistgroup(ostream &os) {
    unsigned int i,n;
    n=last-first+1;

    for(i=0;i<n;i++) {
      if(_OverviewDB[i]!="") os << atoi(_OverviewDB[i].c_str()) << "\r\n";
    }
  }
};
#endif
#endif
