"""
  htmldoc.py - convert HTML to/from Doc-format e-texts
  $Id: conv_html.py,v 1.2 1998/09/04 08:36:46 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


"""

__version__ = '$Id: conv_html.py,v 1.2 1998/09/04 08:36:46 rob Exp $'


import sys, string, os

import htmllib, formatter, urllib

import DocWriter

class DocHTMLParser(htmllib.HTMLParser):
    """A HTML parser with some support for Doc-format e-texts."""
    def __init__(self, *a, **kw):
	apply(htmllib.HTMLParser.__init__, (self,)+a, kw)
	self.writer = self.formatter.writer
	self.tcol = 0
	    
    def end_title(self):
	htmllib.HTMLParser.end_title(self)
	if not self.writer.has_title():
	    self.writer.set_title(self.title)

    # entities
    from entitydefs import entitydefs
    
    # headings
    def start_h1(self, attr):
	self.save_bgn()

    def end_h1(self):
	text = self.save_end()
	self.formatter.end_paragraph(1)
	self.writer.send_heading(text, 1)

    def start_h2(self, attr):
	self.save_bgn()

    def end_h2(self):
	text = self.save_end()
	self.formatter.end_paragraph(1)
	self.writer.send_heading(text, 2)

    def start_h3(self, attr):
	self.save_bgn()

    def end_h3(self):
	text = self.save_end()
	self.formatter.end_paragraph(1)
	self.writer.send_heading(text, 3)

    def start_h4(self, attr):
	self.save_bgn()

    def end_h4(self):
	text = self.save_end()
	self.formatter.end_paragraph(1)
	self.writer.send_heading(text, 4)

    def start_h5(self, attr):
	self.save_bgn()

    def end_h5(self):
	text = self.save_end()
	self.formatter.end_paragraph(1)
	self.writer.send_heading(text, 5)

    def start_h6(self, attr):
	self.save_bgn()

    def end_h6(self):
	text = self.save_end()
	self.formatter.end_paragraph(1)
	self.writer.send_heading(text, 6)

    # anchors.
    def anchor_bgn(self, href, name, type):
	if name and not self.writer.has_option('no-anchor-bookmarks'):
	    if name[0] == '#': name = name[1:]
	    self.writer.set_bookmark(name)
	    
	if self.writer.has_option('teal-links'):
	    if name:
		if name[0] == '#': name = name[1:]
		self.writer.send_raw_tag('LABEL',{'NAME':'"%s"' % name})
	    if href and href[0] == '#':
		self.writer.send_raw_tag('LINK',{'TEXT':'"%s"' % (chr(187)*2),
						 'FONT':'0',
						 'TAG':'"%s"' % href[1:],
						 'STYLE':'UNDERLINE'})
	    elif href and not self.writer.has_option('no-links'):
		self.anchor = href
		self.anchorlist.append(href)
	elif href and href[0] != '#' and not self.writer.has_option('no-links'):
	    self.anchor = href
	    self.anchorlist.append(href)
	
    # now, let's see what we can do about tables.
    # the simplest thing to do is to treat each table row as a separate line;
    def do_tr(self, attrs):
	self.tcol = 0
	self.formatter.end_paragraph(0)

    def do_td(self, attrs):
	if self.tcol: self.formatter.add_flowing_data(' ')
	self.tcol = self.tcol+1

    def start_table(self, attrs):
	pass
    
    def end_table(self):
	self.formatter.end_paragraph(1)

    #-- Lists, mostly cribbed from htmllib.
    def start_ul(self, attrs):
	type = 'disc'
	for a, v in attrs:
	    if a == 'type': type = v
	if type == 'square': label = chr(0x8d)
	elif type == 'circle': label = 'o'
	else: label = chr(0x95)
	self.formatter.end_paragraph(not self.list_stack)
	self.formatter.push_margin('ul')
	self.list_stack.append(['ul', label, 0])

    def do_li(self, attrs):
	self.formatter.end_paragraph(0)
	if self.list_stack:
	    [dummy, label, counter] = top = self.list_stack[-1]
	    top[2] = counter = counter+1
	else:
	    label, counter = chr(0x95), 0
	self.formatter.add_label_data(label, counter)
	

def html_to_doc(fd, w, title=None, options=None, default_title='Untitled'):
    """Convert HTML (on the specified input file) to a Doc."""

    f = formatter.AbstractFormatter(w)
    p = DocHTMLParser(f)

    strip = not w.has_option('pass-returns')
    ttbl = string.maketrans('','')
    
    while 1:
	l = fd.readline()
	if not l: break
	if strip: l = string.translate(l, ttbl, '\r')
	p.feed(l)

    # handle anchors
    if p.anchorlist and not w.has_option('no-links'):
	f.end_paragraph(1)
	f.add_hor_rule()
	w.set_bookmark('%s Links' % chr(187))
	w.send_heading('Links:',3)
	for x in range(0, len(p.anchorlist)):
	    f.add_label_data('[1] ', x+1)
	    f.add_flowing_data(p.anchorlist[x])
	    f.add_line_break()

    if not w.has_title():
	w.set_title(default_title)
	    
def main(argv):
    from cmdproc import CmdLine
    
    c = CmdLine('HTML',
		[('no-links', 'do not mark or footnote links'),
		 ('no-anchor-bookmarks', 'omit bookmarks for named anchors')])
    c.process_options(argv)
    c.process_files(html_to_doc)
    
