
#define NEED_STRUCTS

#include "audio.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <StringList.h>

#include <esd.h>

#ifdef OS_Linux
#include <linux/soundcard.h>
#endif

int AUSIZ = ESD_BUF_SIZE * 2;

extern char *esdhost;

static int audio_fd;

#ifdef OS_Linux
static int mixer_fd;
static int volumewriteIoctl;
static int volumereadIoctl;

#endif

/*
 * Bad voodoo magic..  Linux only, until EsounD has controls for this
 */

void audioInit(void)
{
#ifdef OS_Linux
   int dummy1;
   int dummy2;

#endif
   EDBUG(2, "audioInit");
#ifdef OS_Linux
   if ((mixer_fd = open("/dev/mixer", O_RDWR)) == -1) {
      fprintf(stderr, "no mixer.. no volume control..\n");
      mixer_fd = 0;
   }
   if (ioctl(mixer_fd, SOUND_MIXER_READ_DEVMASK, &dummy1) == -1) {
      volumewriteIoctl = SOUND_MIXER_WRITE_VOLUME;
      volumereadIoctl = SOUND_MIXER_READ_VOLUME;
   }
   else {
      if ((dummy1 & SOUND_MASK_PCM) != 0) {
	 volumewriteIoctl = SOUND_MIXER_WRITE_PCM;
	 volumereadIoctl = SOUND_MIXER_READ_PCM;
      }
      else {
	 volumewriteIoctl = 0;
	 volumereadIoctl = 0;
      }
   }
   ChangeMasterVolume(GetVolume(&dummy1, &dummy2));
#endif
   EDBUG_RETURN_;
}

int audioSetVolume(int left, int right)
{
#ifdef OS_Linux
   int vol;

#endif
   EDBUG(3, "audioSetVolume");
#ifdef OS_Linux
   vol = (left << 8) + right;
   if (mixer_fd) {
      ioctl(mixer_fd, volumewriteIoctl, &vol);
   }
   EDBUG_RETURN((int) (right + left) / 2);
#endif
   EDBUG_RETURN(0);
}

int audioGetVolume(int *left, int *right)
{
#ifdef OS_Linux
   int vol;

#endif
   EDBUG(3, "audioGetVolume");
#ifdef OS_Linux
   if (!mixer_fd)
      EDBUG_RETURN(0);
   if (ioctl(mixer_fd, volumereadIoctl, &vol) != -1) {
      *left = (vol >> 8);
      *right = (vol & 0xff);
   }
   else {
      *left = -1;
      *right = -1;
   }
   EDBUG_RETURN((int) (*left + *right) / 2);
#endif
   EDBUG_RETURN(0);
}

/*
 * End of bad voodoo... "sane" programming returns
 */

int audioOpen(int frequency, int stereo, int signedness, int big, int sixteen)
{
   esd_format_t flags = ESD_STREAM | ESD_PLAY;

   EDBUG(3, "audioOpen");
   if (stereo)
      flags |= ESD_STEREO;
   else
      flags |= ESD_MONO;

   if (sixteen)
      flags |= ESD_BITS16;
   else
      flags |= ESD_BITS8;

   audio_fd = esd_play_stream(flags, frequency, esdhost, "eMusic");
   if (audio_fd <= 0) {
      if (!esdhost) {
	 fprintf(stderr, "EsounD wasn't running, attempting to exec it.\n");
	 if (!fork()) {		/* child */
	    if (execl("/bin/sh", "/bin/sh", "-c", "esd", NULL) == -1)
	       fprintf(stderr, "Couldn't execute 'esd'... please get and install EsounD..\n");
	    exit(0);
	 }
	 sleep(2);
	 audio_fd = esd_play_stream(flags, frequency, esdhost, "eMusic");
	 if (audio_fd <= 0) {
	    fprintf(stderr, "EsounD could not be started properly.. help, help, i'll try to just fallback instead\n");
	    audio_fd = esd_play_stream_fallback(flags, frequency, esdhost, "eMusic");
	    if (audio_fd <= 0) {
	       fprintf(stderr, "Couldn't even open audio normally.. Kill whatever's taking over /dev/dsp and\nlet me use it..\n");
	       exit(-1);
	    }
	 }
      }
      else {
	 fprintf(stderr, "You've specified a remote server %s.. \n", esdhost);
	 fprintf(stderr, "Only problem, EsounD isn't running there\n");
	 exit(-1);
      }
   }
   EDBUG_RETURN(0);
}

void audioFlush(void)
{
   char *temp = Emalloc(AUSIZ);

   EDBUG(7, "audioFlush");
   memset(temp, 0, AUSIZ);
   write(audio_fd, temp, AUSIZ);
   Efree(temp);
   EDBUG_RETURN_;
}

void audioClose(void)
{
   EDBUG(3, "audioClose");
   audioFlush();
   esd_close(audio_fd);
   audio_fd = 0;
   EDBUG_RETURN_;
}

int audioWrite(char *buffer, int count)
{
   EDBUG(8, "audioWrite");
   EDBUG_RETURN(write(audio_fd, buffer, count));
}

int getAudioFd(void)
{
   EDBUG(8, "getAudioFd");
   EDBUG_RETURN(audio_fd);
}
