
#include "emusic.h"

FileBox *FileWin;

char *GetRightPath(char *path)
{
   char *savepath;
   char *temp = NULL;

   EDBUG(3, "GetRightPath");
   if (!path)
      EDBUG_RETURN(NULL);
   savepath = cwd();
   if ((path[0] != '/') && (path[0] != '~') && (path[0] != '.')) {
      temp = Emalloc((strlen(savepath) + strlen(path)) + 2);
      sprintf(temp, "%s/%s", savepath, path);
   }
   else if ((path[0] != '/') && (path[0] != '.')) {
      Efree(savepath);
      savepath = duplicate(HomeDir);
      temp = Emalloc((strlen(savepath) + strlen(path)) + 2);
      path++;
      sprintf(temp, "%s/%s", savepath, path);
   }
   else if (path[0] != '/') {
      if (path[1] == '.') {
	 char *temp2 = strrchr(savepath, '/');

	 if (temp2)
	    temp2[0] = '\0';
	 temp = Emalloc((strlen(savepath) + strlen(path)) + 2);
	 sprintf(temp, "%s/%s", savepath, path);
      }
      else {
	 temp = Emalloc((strlen(savepath) + strlen(path)) + 2);
	 sprintf(temp, "%s/%s", savepath, path + 1);
      }
   }
   else
      temp = duplicate(path);
   Efree(savepath);
   EDBUG_RETURN(temp);
}

void rmrf(char *s1)
{
   char *savepath;
   char *temp;
   DIR *dir;
   struct dirent *entry;

   EDBUG(3, "rmrf");
   if (!(dir = opendir(s1)))
      EDBUG_RETURN_;
   if (strncmp("/tmp", s1, 4)) {
      fprintf(stderr, "not going to delete %s\n", s1);
      closedir(dir);
      EDBUG_RETURN_;
   }
   savepath = cwd();
   cd(s1);
   while ((entry = readdir(dir))) {
      if (isdir(entry->d_name)) {
	 if (!strcmp(".", entry->d_name) || !strcmp("..", entry->d_name))
	    continue;
	 temp = Emalloc(strlen(s1) + strlen(entry->d_name) + 2);
	 sprintf(temp, "%s/%s", s1, entry->d_name);
	 rmrf(temp);
	 Efree(temp);
      }
      else if (isfile(entry->d_name))
	 rm(entry->d_name);
   }
   cd(savepath);
   rmdir(s1);
   closedir(dir);
   Efree(savepath);
   EDBUG_RETURN_;
}

char *FindFile(char *file, char *path)
{
   DIR *dir;
   char *ret = NULL;
   struct dirent *entry;
   char temp[FILEPATH_LEN_MAX];

   EDBUG(3, "FindFile");
   if ((dir = opendir(path)) == NULL)
      EDBUG_RETURN(ret);
   while ((entry = readdir(dir))) {
      sprintf(temp, "%s/%s", path, entry->d_name);
      if (isfile(temp))
	 if (!strcasecmp(entry->d_name, file)) {
	    ret = Emalloc(strlen(entry->d_name) + 1);
	    strcpy(ret, entry->d_name);
	    closedir(dir);
	    EDBUG_RETURN(ret);
	 }
   }
   closedir(dir);
   EDBUG_RETURN(ret);
}

struct player_plugin *getfiletype(char *path)
{
   struct player_plugin *cur;

   EDBUG(6, "getfiletype");
   if (!players || !players->first)
      EDBUG_RETURN(NULL);
   cur = players->first;
   if (!cur->next)
      EDBUG_RETURN(cur);
   cur = cur->next;
   while (cur) {
      if (!cur->loaded)
	 if (!LoadPlayerPlugin(cur))
	    continue;
      if (cur->is_file(path))
	 EDBUG_RETURN(cur);
      cur = cur->next;
   }
   EDBUG_RETURN(players->first);
}

int cdtolist(char *path, int current_selection)
{
   FILE *temp;
   char *tempname = Emalloc(FILEPATH_LEN_MAX);

   EDBUG(4, "cdtolist");
   tmpnam(tempname);
   if (!(temp = fopen(tempname, "w"))) {
      Efree(tempname);
      EDBUG_RETURN(0);
   }
   fprintf(temp, "%s\n", path);
   fclose(temp);
   addplaylist(tempname);
   rm(tempname);
   Efree(tempname);
   EDBUG_RETURN(1);
}

int dirtolist(char *path, char *mask, int recursive)
{
   FILE *temp;
   char *tempname = Emalloc(FILEPATH_LEN_MAX);
   int i = 0;

   EDBUG(5, "dirtolist");
   tmpnam(tempname);
   if (!(temp = fopen(tempname, "w"))) {
      Efree(tempname);
      EDBUG_RETURN(0);
   }
   if (strlen(path) > 1)
      if (path[(strlen(path) - 1)] == '/')
	 path[(strlen(path) - 1)] = '\0';
   i = dodirtolist(path, mask, temp, recursive);
   fclose(temp);
   if (!i)
      addplaylist(tempname);
   rm(tempname);
   cd(path);
   Efree(tempname);
   EDBUG_RETURN(i);
}

int dodirtolist(char *path, char *mask, FILE * file, int recursive)
{
   DIR *dir;
   struct dirent *entry;
   char *cwdpath;
   char *savepath;

   EDBUG(3, "dodirtolist");
   if (!path || !mask)
      EDBUG_RETURN(1);
   if (!(dir = opendir(path))) {
      fprintf(stderr, "Can't read directory: %s\n", path);
      EDBUG_RETURN(1);
   }
   savepath = cwd();
   cd(path);
   cwdpath = cwd();
   while ((entry = readdir(dir))) {
      if (isdir(entry->d_name)) {
	 if (!strcmp(".", entry->d_name) || !strcmp("..", entry->d_name))
	    continue;
	 if (recursive)
	    dodirtolist(entry->d_name, mask, file, recursive);
      }
      else if (isfile(entry->d_name)) {
	 if (match(mask, entry->d_name)) {
	    if (strlen(cwdpath) == 1)
	       strcpy(cwdpath, "\0");
	    fprintf(file, "%s/%s\n", cwdpath, entry->d_name);
	 }
      }
   }
   cd(savepath);
   closedir(dir);
   Efree(cwdpath);
   Efree(savepath);
   EDBUG_RETURN(0);
}

int match(char *mask, char *str)
{
   EDBUG(8, "match");
   if (!mask)
      EDBUG_RETURN(1);
   if ((mask[0] == '\0') && (str[0] == '\0'))
      EDBUG_RETURN(1);
   while ((mask[0] != '?') && (mask[0] != '*')) {
      if (mask[0] != str[0])
	 EDBUG_RETURN(0);
      mask++;
      str++;
      if ((mask[0] == '\0') && (str[0] == '\0'))
	 EDBUG_RETURN(1);
   }
   if (mask[0] == '?') {
      mask++;
      str++;
      if ((mask[0] == '\0') && (str[0] == '\0')) {
	 EDBUG_RETURN(1);
      }
      else
	 EDBUG_RETURN(match(mask, str));
   }
   else if (mask[0] == '*') {
      int i, j, done;
      char *temp, *temp2;

      mask++;
      if (mask[0] == '\0')
	 EDBUG_RETURN(1);
      temp = Emalloc(strlen(mask) + 1);
      i = done = 0;
      if ((strchr(mask, '*')) || (strchr(mask, '?')))
	 while (!done) {
	    temp[i] = mask[0];
	    i++;
	    mask++;
	    if ((mask[0] == '?') || (mask[0] == '*'))
	       done = 1;
	 }
      else
	 while (!done) {
	    temp[i] = mask[0];
	    i++;
	    mask++;
	    if (mask[0] == '\0')
	       done = 1;
	 }
      temp[i] = '\0';
      done = 0;
      temp2 = strchr(str, temp[0]);
      if (!temp2) {
	 Efree(temp);
	 EDBUG_RETURN(0);
      }
      while (!done) {
	 for (j = 0; j < i; j++) {
	    if (temp[j] == temp2[j])
	       done = 1;
	    else {
	       Efree(temp);
	       EDBUG_RETURN(0);
	    }
	 }
	 if (strchr(temp2, temp[0]) != temp2) {
	    temp2 = strchr(temp2, temp[0]);
	    done = 0;
	 }
      }
      for (j = 0; j < i; j++)
	 temp2++;
      str = temp2;
      Efree(temp);
      EDBUG_RETURN(match(mask, str));
   }
   else
      EDBUG_RETURN(match(mask, str));
}

char *splitdir(char *dir)
{
   char *name;

   EDBUG(6, "splitdir");
   if (!dir)
      EDBUG_RETURN(NULL);
   if (dir[strlen(dir) - 1] == '/')
      name = NULL;
   else {
      name = strrchr(dir, '/');
      if (!name) {
	 name = duplicate(dir);
	 strcpy(dir, "./");
      }
      else {
	 name[0] = '\0';
	 name++;
      }
   }
   EDBUG_RETURN(name);
}

void ConfigFile(FILE * file)
{
   EDBUG(4, "ConfigFile");
   if (textmode)
      EDBUG_RETURN_;
   FileWin = ConfigFileBox(file);
   EDBUG_RETURN_;
}
