
#include "../emusic.h"

char *tempskindir;
char *winamp_default_path;

void Convert_main(char *tempskindirlala)
{
   char *orig, *temp, *s;

   EDBUG(5, "Convery_main");
   tempskindir = duplicate(tempskindirlala);
   orig = Emalloc(strlen(origskin) + 256);
   s = FindFile("main.bmp", origskin);
   sprintf(orig, "%s", s);
   Efree(s);
   if (strcmp(orig, "(null)")) {
      ImlibImage *main_im, *ppm_im;

      ProcessImage("titlebar.bmp", "titlebar.ppm", 27, 0, 275, 14);
      temp = Emalloc(strlen(tempskindir) + 20);
      sprintf(temp, "%s/titlebar.ppm", tempskindir);
      ppm_im = LoadImlibImage(temp);
      rm(temp);
      ProcessImage("main.bmp", "main.ppm", 0, 0, 275, 116);
      sprintf(temp, "%s/main.ppm", tempskindir);
      main_im = LoadImlibImage(temp);
      memcpy(main_im->rgb_data, ppm_im->rgb_data, 11550);
      Imlib_changed_image(imlib, main_im);
      Imlib_save_image_to_ppm(imlib, main_im, temp);
      Imlib_kill_image(imlib, main_im);
      Imlib_kill_image(imlib, ppm_im);
   }
   else {
      temp = Emalloc(strlen(tempskindir) + 20);
      sprintf(orig, "%s/%s", winamp_default_path, "main.ppm");
      sprintf(temp, "%s/%s", tempskindir, "main.ppm");
      cp(orig, temp);
   }
   Efree(orig);
   Efree(temp);
   EDBUG_RETURN_;
}

void Convert_cbuttons()
{
   EDBUG(5, "Convert_cbuttons");
   ProcessImage("cbuttons.bmp", "rw_0.ppm", 0, 0, 23, 18);
   ProcessImage("cbuttons.bmp", "rw_1.ppm", 0, 18, 23, 18);
   ProcessImage("cbuttons.bmp", "play_0.ppm", 23, 0, 23, 18);
   ProcessImage("cbuttons.bmp", "play_1.ppm", 23, 18, 23, 18);
   ProcessImage("cbuttons.bmp", "pause_0.ppm", 46, 0, 23, 18);
   ProcessImage("cbuttons.bmp", "pause_1.ppm", 46, 18, 23, 18);
   ProcessImage("cbuttons.bmp", "stop_0.ppm", 69, 0, 23, 18);
   ProcessImage("cbuttons.bmp", "stop_1.ppm", 69, 18, 23, 18);
   ProcessImage("cbuttons.bmp", "ff_0.ppm", 92, 0, 22, 18);
   ProcessImage("cbuttons.bmp", "ff_1.ppm", 92, 18, 22, 18);
   ProcessImage("cbuttons.bmp", "eject_0.ppm", 114, 0, 22, 16);
   ProcessImage("cbuttons.bmp", "eject_1.ppm", 114, 16, 22, 16);
   EDBUG_RETURN_;
}

void Convert_monoster()
{
   EDBUG(5, "Convert_monoster");
   ProcessImage("monoster.bmp", "stereo_0.ppm", 0, 12, 29, 12);
   ProcessImage("monoster.bmp", "stereo_1.ppm", 0, 0, 29, 12);
   ProcessImage("monoster.bmp", "mono_0.ppm", 29, 12, 29, 12);
   ProcessImage("monoster.bmp", "mono_1.ppm", 29, 0, 29, 12);
   EDBUG_RETURN_;
}

void Convert_numbers()
{
   EDBUG(5, "Convert_numbers");
   ProcessImage("numbers.bmp", "digit3.ppm", 0, 0, 99, 13);
   EDBUG_RETURN_;
}

void Convert_playpaus()
{
   EDBUG(5, "Convert_playpaus");
   ProcessImage("playpaus.bmp", "play_indicator.ppm", 0, 0, 9, 9);
   ProcessImage("playpaus.bmp", "pause_indicator.ppm", 9, 0, 9, 9);
   ProcessImage("playpaus.bmp", "stop_indicator.ppm", 18, 0, 9, 9);
   EDBUG_RETURN_;
}

void Convert_posbar()
{
   EDBUG(5, "Convert_posbar");
   ProcessImage("posbar.bmp", "status_bar.ppm", 0, 0, 248, 10);
   ProcessImage("posbar.bmp", "slider_0.ppm", 248, 0, 29, 10);
   ProcessImage("posbar.bmp", "slider_1.ppm", 278, 0, 29, 10);
   EDBUG_RETURN_;
}

void Convert_shufrep()
{
   EDBUG(5, "Convert_shufrep");
   ProcessImage("shufrep.bmp", "bulb_0.ppm", 23, 61, 23, 12);
   ProcessImage("shufrep.bmp", "bulb_1.ppm", 69, 61, 23, 12);
   ProcessImage("shufrep.bmp", "bulb_2.ppm", 23, 73, 23, 12);
   ProcessImage("shufrep.bmp", "bulb_3.ppm", 69, 73, 23, 12);
   ProcessImage("shufrep.bmp", "shuffle_0.ppm", 28, 0, 47, 15);
   ProcessImage("shufrep.bmp", "shuffle_1.ppm", 28, 15, 47, 15);
   ProcessImage("shufrep.bmp", "shuffle_2.ppm", 28, 30, 47, 15);
   ProcessImage("shufrep.bmp", "shuffle_3.ppm", 28, 45, 47, 15);
   ProcessImage("shufrep.bmp", "repeat_0.ppm", 0, 0, 28, 15);
   ProcessImage("shufrep.bmp", "repeat_1.ppm", 0, 15, 28, 15);
   ProcessImage("shufrep.bmp", "repeat_2.ppm", 0, 30, 28, 15);
   ProcessImage("shufrep.bmp", "repeat_3.ppm", 0, 45, 28, 15);
   ProcessImage("shufrep.bmp", "eq_0.ppm", 0, 61, 23, 12);
   ProcessImage("shufrep.bmp", "eq_1.ppm", 46, 61, 23, 12);
   ProcessImage("shufrep.bmp", "eq_2.ppm", 0, 73, 23, 12);
   ProcessImage("shufrep.bmp", "eq_3.ppm", 46, 73, 23, 12);
   EDBUG_RETURN_;
}

void CutOutLetter(ImlibImage * im, int x, int y, unsigned char c)
{
   ImlibImage *copy_im;
   char *ppm;
   int w = 5;

   EDBUG(6, "CutOutLetter");
   if (c == '@')
      w = 6;
   copy_im = Imlib_crop_and_clone_image(imlib, im, x, y, w, 6);
   ppm = Emalloc(strlen(tempskindir) + 20);
   sprintf(ppm, "%s/winampfont/%d.ppm", tempskindir, c);
   Imlib_save_image_to_ppm(imlib, copy_im, ppm);
   Efree(ppm);
   Imlib_kill_image(imlib, copy_im);
   EDBUG_RETURN_;
}

void Convert_text()
{
   char *text;
   char *ppm;
   ImlibImage *text_im;
   ImlibImage *copy_im;
   unsigned char c;
   int x = 0, y = 0;

   EDBUG(5, "Convert_text");
   if (!ProcessImage("text.bmp", "text.ppm", 0, 0, 155, 18)) {
      fprintf(stderr, "Using the Base winampfont\n");
      EDBUG_RETURN_;
   }
   text = Emalloc(strlen(tempskindir) + 20);
   sprintf(text, "%s/text.ppm", tempskindir);
   text_im = LoadImlibImage(text);
   copy_im = Imlib_crop_and_clone_image(imlib, text_im, 0, 6, 55, 6);
   ppm = Emalloc(strlen(tempskindir) + 20);
   sprintf(ppm, "%s/sm_digit.ppm", tempskindir);
   Imlib_save_image_to_ppm(imlib, copy_im, ppm);
   Efree(ppm);
   Imlib_kill_image(imlib, copy_im);
   for (c = 'A'; c <= 'Z'; c++) {
      CutOutLetter(text_im, x, y, c);
      x += 5;
   }
   CutOutLetter(text_im, x, y, '"');
   x += 6;
   CutOutLetter(text_im, x, y, '@');
   x = 0;
   y += 6;
   for (c = '0'; c <= '9'; c++) {
      CutOutLetter(text_im, x, y, c);
      x += 5;
   }
   x += 10;
   CutOutLetter(text_im, x, y, ':');
   x += 5;
   CutOutLetter(text_im, x, y, '(');
   x += 5;
   CutOutLetter(text_im, x, y, ')');
   x += 5;
   CutOutLetter(text_im, x, y, '-');
   x += 5;
   CutOutLetter(text_im, x, y, 39);
   x += 5;
   CutOutLetter(text_im, x, y, '!');
   x += 5;
   CutOutLetter(text_im, x, y, '_');
   x += 5;
   CutOutLetter(text_im, x, y, '+');
   x += 5;
   CutOutLetter(text_im, x, y, 92);
   x += 5;
   CutOutLetter(text_im, x, y, 47);
   x += 5;
   CutOutLetter(text_im, x, y, '[');
   x += 5;
   CutOutLetter(text_im, x, y, ']');
   x += 5;
   CutOutLetter(text_im, x, y, '^');
   x += 5;
   CutOutLetter(text_im, x, y, '&');
   x += 5;
   CutOutLetter(text_im, x, y, '%');
   x += 5;
   CutOutLetter(text_im, x, y, ',');
   x += 5;
   CutOutLetter(text_im, x, y, '=');
   x += 5;
   CutOutLetter(text_im, x, y, '$');
   x += 5;
   CutOutLetter(text_im, x, y, '*');
   x += 5;
   x = 0;
   y += 6;
   CutOutLetter(text_im, x, y, 143);
   x += 5;
   CutOutLetter(text_im, x, y, 153);
   x += 5;
   CutOutLetter(text_im, x, y, 142);
   x += 5;
   CutOutLetter(text_im, x, y, '?');
   x += 5;
   CutOutLetter(text_im, x, y, 145);
   x += 5;
   CutOutLetter(text_im, x, y, ' ');
   rm(text);
   Efree(text);
   EDBUG_RETURN_;
}

void Convert_titlebar()
{
   EDBUG(5, "Convert_titlebar");
   ProcessImage("titlebar.bmp", "option_0.ppm", 0, 0, 9, 9);
   ProcessImage("titlebar.bmp", "option_1.ppm", 0, 9, 9, 9);
   ProcessImage("titlebar.bmp", "close_0.ppm", 18, 0, 9, 9);
   ProcessImage("titlebar.bmp", "close_1.ppm", 18, 9, 9, 9);
   ProcessImage("titlebar.bmp", "minimize_0.ppm", 9, 0, 9, 9);
   ProcessImage("titlebar.bmp", "minimize_1.ppm", 9, 9, 9, 9);
   ProcessImage("titlebar.bmp", "shade_0.ppm", 0, 18, 9, 9);
   ProcessImage("titlebar.bmp", "shade_1.ppm", 9, 18, 9, 9);
   ProcessImage("titlebar.bmp", "unshade_0.ppm", 0, 27, 9, 9);
   ProcessImage("titlebar.bmp", "unshade_1.ppm", 9, 27, 9, 9);
   ProcessImage("titlebar.bmp", "shade_back.ppm", 27, 29, 275, 14);
   ProcessImage("titlebar.bmp", "sm_status_bar.ppm", 0, 36, 17, 7);
   ProcessImage("titlebar.bmp", "sm_slider_l.ppm", 17, 36, 3, 7);
   ProcessImage("titlebar.bmp", "sm_slider_m.ppm", 20, 36, 3, 7);
   ProcessImage("titlebar.bmp", "sm_slider_r.ppm", 23, 36, 3, 7);
   ProcessImage("titlebar.bmp", "clutter.ppm", 304, 0, 8, 43);
   ProcessImage("titlebar.bmp", "clutter_o.ppm", 304, 44, 8, 43);
   ProcessImage("titlebar.bmp", "clutter_p.ppm", 312, 44, 8, 43);
   ProcessImage("titlebar.bmp", "clutter_i.ppm", 320, 44, 8, 43);
   ProcessImage("titlebar.bmp", "clutter_d.ppm", 328, 44, 8, 43);
   ProcessImage("titlebar.bmp", "clutter_v.ppm", 336, 44, 8, 43);
   EDBUG_RETURN_;
}

void Convert_volume()
{
   int i;
   char name[64];

   EDBUG(5, "Convert_volume");
   for (i = 0; i < 28; i++) {
      sprintf(name, "volume_%d.ppm", i);
      ProcessImage("volume.bmp", name, 0, i * 15, 68, 13);
      sprintf(name, "balance_%d.ppm", 27 - i);
      ProcessImage("volume.bmp", name, 9, i * 15, 38, 13);
   }
   for (i = 28; i < 56; i++) {
      sprintf(name, "balance_%d.ppm", i);
      ProcessImage("volume.bmp", name, 9, (i - 28) * 15, 38, 13);
   }
   ProcessImage("volume.bmp", "volume_b_0.ppm", 15, 421, 14, 11);
   ProcessImage("volume.bmp", "volume_b_1.ppm", 0, 421, 14, 11);
   EDBUG_RETURN_;
}

int CheckForWinampSkinAt(char *path)
{
   char *s = NULL;

   EDBUG(4, "CheckForWinampSkinAt");
   s = FindFile("main.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("cbuttons.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("monoster.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("numbers.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("playpaus.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("posbar.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("shufrep.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("text.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("titlebar.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   s = FindFile("volume.bmp", path);
   if (s) {
      Efree(s);
      EDBUG_RETURN(TRUE);
   }
   EDBUG_RETURN(FALSE);
}

void ConvertWinamp(char *ts)
{
   char *sys;

   EDBUG(4, "ConvertWinamp");
   sys = Emalloc(strlen(ts) + strlen(winamp_default_path) + 48);
   sprintf(sys, "cp -r %s/* %s/", winamp_default_path, ts);
/* */
   system(sys);
   Efree(sys);
   ConvertSetPath(ts);
   Convert_main(ts);
   Convert_cbuttons();
   Convert_monoster();
   Convert_numbers();
   Convert_playpaus();
   Convert_posbar();
   Convert_shufrep();
   Convert_text();
   Convert_titlebar();
   Convert_volume();
   ConvertFreePath();
   EDBUG_RETURN_;
}
