#include "emusic.h"

int themeloaded = FALSE;
char *temppath = NULL;

#define UNDEF   0
#define MAIN    1
#define MAINWIN 2
#define PLIST   3
#define FILEWIN 4
#define MINWIN  5
#define INFOBOX 6
#define PROGRESSBOX 7

void Theme_Callback(char *the_return_path)
{
   char *returnpath;

   EDBUG(5, "Theme_Callback");
   if (FileWin->okdone) {
      returnpath = duplicate(the_return_path);
      newthemepath = Erealloc(newthemepath, strlen(returnpath) + 1);
      strcpy(newthemepath, returnpath);
      Efree(returnpath);
      need_to_reload_theme = TRUE;
   }
   EDBUG_RETURN_;
}

void DefaultsTheme(void)
{
   EDBUG(7, "DefaultsTheme");
   imask.r = 255;
   imask.g = 0;
   imask.b = 255;
   moving = deferred = FALSE;
   XSetForeground(disp, fg, WhitePixel(disp, screen));
   EDBUG_RETURN_;
}

void loadmain(char *left, char *right)
{
   int n;
   int r, g, b;

   EDBUG(4, "loadmain");
   if (!strncmp("BEGIN", left, 5))
      DefaultsTheme();
   if (!strncmp("MASKRGB", left, 7)) {
      n = sscanf(right, "%i %i %i", &imask.r, &imask.g, &imask.b);
      if (n != 3) {
	 fprintf(stderr, "Bad mask color\n");
	 exit(-1);
      }
   }
   else if (!strncmp("FOREGROUNDRGB", left, 13)) {
      n = sscanf(right, "%i %i %i", &r, &g, &b);
      if (n != 3) {
	 fprintf(stderr, "Bad foregound color\n");
	 exit(-1);
      }
      XSetForeground(disp, fg, Imlib_best_color_match(imlib, &r, &g, &b));
      XSetBackground(disp, bg, Imlib_best_color_match(imlib, &r, &g, &b));
   }
   EDBUG_RETURN_;
}

int readtheme(char *path)
{
   char *themefile;
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   FILE *in;
   char st[FILEPATH_LEN_MAX];
   char *savepath;
   int context = UNDEF;

   EDBUG(3, "readtheme");
   savepath = cwd();
   cd(path);
   themefile = Emalloc(strlen(path) + 20);
   sprintf(themefile, "%s/MAIN.theme", path);
   if ((in = fopen(themefile, "r")) == NULL) {
      fprintf(stderr, "Error, error, can't find %s\n", themefile);
      Efree(themefile);
      Efree(savepath);
      EDBUG_RETURN(0);
   }
   Efree(themefile);
   Fnlib_add_dir(fnlib, path);
   while (GetNextLine(st, in)) {
      splitstring(s1, s2, st);
      if (!strncmp("BEGIN", s1, 5)) {
	 upstr(s2);
	 if (!strncmp("MAIN", s2, 4))
	    context = MAIN;
	 else if (!strncmp("EMUSIC", s2, 6))
	    context = MAINWIN;
	 else if (!strncmp("MINWIN", s2, 6))
	    context = MINWIN;
	 else if (!strncmp("INFOBOX", s2, 7))
	    context = INFOBOX;
	 else if (!strncmp("PROGRESSBOX", s2, 11))
	    context = PROGRESSBOX;
	 else if (!strncmp("PLAYEDITWIN", s2, 11))
	    context = PLIST;
	 else if (!strncmp("FILE", s2, 4))
	    context = FILEWIN;
	 else
	    context = UNDEF;
      }
      if (context == MAIN)
	 loadmain(s1, s2);
      else if (context == MAINWIN) {
	 MainWindow = ConfigMainWin(in);
	 CurMW = MainWindow;
      }
      else if (context == MINWIN)
	 MinimizedWindow = ConfigMainWin(in);
      else if (context == INFOBOX)
	 infobox = ConfigDialog(in);
      else if (context == PROGRESSBOX)
	 progressbox = ConfigDialog(in);
      else if (context == PLIST)
	 ConfigPlayEditor(in);
      else if (context == FILEWIN)
	 ConfigFile(in);
      if (!strncmp("END", s1, 3))
	 context = UNDEF;
   }
   cd(savepath);
   Efree(savepath);
   themeloaded = TRUE;
   EDBUG_RETURN(1);
}

int Load_Theme(void)
{
   int i;
   static int number = 1;
   char *s1;
   unsigned char buf[16];
   FILE *f;

   EDBUG(2, "Load_Theme");
   if (!themepath)
      EDBUG_RETURN(0);
   if (themeloaded)
      Unload_Theme(TRUE, NULL);
   i = getpid();
   s1 = duplicate(themepath);
   if (!exists(s1)) {
      char *path = duplicate(HomeDir);

      s1 = Erealloc(s1, strlen(path) + strlen(themepath) + 10);
      sprintf(s1, "%s/.emusic/%s", path, themepath);
      Efree(path);
      if (exists(s1)) {
	 themepath = Erealloc(themepath, strlen(s1) + 1);
	 strcpy(themepath, s1);
      }
      else {
	 s1 = Erealloc(s1, strlen(ThemeDir) + strlen(themepath) + 12);
	 sprintf(s1, "%s/%s", ThemeDir, themepath);
	 themepath = Erealloc(themepath, strlen(s1) + 1);
	 strcpy(themepath, s1);
      }
   }
   if (exists(themepath)) {
      if (isfile(themepath)) {
	 temppath = Emalloc(50);
	 sprintf(temppath, "/tmp/emusic_theme_%i%i", i, number);
	 number++;
	 md(temppath);
	 f = fopen(themepath, "r");
	 if (f) {
	    fread(&buf[0], 1, 1, f);
	    fread(&buf[1], 1, 1, f);
	    fclose(f);
	    s1 = Erealloc(s1, strlen(themepath) + strlen(temppath) + 48);
	    if ((buf[0] == 31) && (buf[1] == 139))
	       sprintf(s1, "gzip -d -c < %s | (cd %s ; tar -xf -)", themepath, temppath);
	    else if (isZip(themepath))
	       sprintf(s1, "unzip %s -d %s > /dev/null", themepath, temppath);
	    else
	       sprintf(s1, "cd %s ; tar -xf %s", temppath, themepath);
	    system(s1);
	    if (isZip(themepath)) {
	       fprintf(stderr, "Attempting to convert skin %s\n", themepath);
	       if (Convert_Skin(temppath)) {
		  Efree(s1);
		  EDBUG_RETURN(0);
	       }
	    }
	 }
      }
      else if (!isdir(themepath)) {
	 Efree(s1);
	 EDBUG_RETURN(0);
      }
   }
   else {
      Efree(s1);
      EDBUG_RETURN(0);
   }
   Efree(s1);
   if (temppath) {
      EDBUG_RETURN(readtheme(temppath));
   }
   else {
      EDBUG_RETURN(readtheme(themepath));
   }
}

void Unload_Theme(int really, char *newtheme)
{
   int sucessful;
   char *oldtheme;

   EDBUG(3, "Unload_THEME");
   if (!themeloaded && textmode)
      EDBUG_RETURN_;
   if (temppath) {
      rmrf(temppath);
      Fnlib_del_dir(fnlib, temppath);
   }
   else
      Fnlib_del_dir(fnlib, themepath);
   temppath = NULL;
   if (!really || !newtheme)
      EDBUG_RETURN_;
   KillAnalysisWin();
   FreeWidget(MainWindow->MainWin);
   FreeStatusWin(MainWindow->statuswin);
   if (MinimizedWindow) {
      FreeWidget(MinimizedWindow->MainWin);
      FreeStatusWin(MinimizedWindow->statuswin);
   }
   FreeWidget(PlayWin);
   FreeFileBox(FileWin);
   oldtheme = duplicate(themepath);
   themepath = Erealloc(themepath, strlen(newtheme) + 1);
   strcpy(themepath, newtheme);
   sucessful = Load_Theme();
   if (!sucessful) {
      fprintf(stderr, "couldn't load %s, reverting to old theme\n", newtheme);
      themepath = Erealloc(themepath, strlen(oldtheme) + 1);
      strcpy(themepath, oldtheme);
      sucessful = Load_Theme();
      if (!sucessful) {
	 fprintf(stderr, "couldn't even load the old one, dying\n");
	 Unload_Theme(FALSE, NULL);
	 exit(-1);
      }
   }
   need_to_reload_theme = FALSE;
   Efree(oldtheme);
   EDBUG_RETURN_;
}
