
#include "widget.h"
#include "../econfig.h"

ImageDat *LoadImage(char *file)
{
   ImlibImage *im;
   char *path;
   char *s1;
   ImageDat *image = Emalloc(sizeof(ImageDat));

   EDBUG(6, "LoadImage");
   path = cwd();
   if (file[0] != '\\') {
      s1 = Emalloc(strlen(path) + strlen(file) + 2);
      sprintf(s1, "%s/%s", path, file);
   }
   else {
      s1 = Emalloc(strlen(file) + 1);
      sprintf(s1, "%s", file);
   }
   if ((im = Imlib_load_image(imlib, s1)) == NULL) {
      fprintf(stderr, "Unable to load image %s.\n", s1);
      exit(-1);
   }
   Imlib_set_image_shape(imlib, im, &imask);
   Imlib_render(imlib, im, im->rgb_width, im->rgb_height);
   image->im = im;
   image->w = im->rgb_width;
   image->h = im->rgb_height;
   image->name = duplicate(s1);
   Efree(s1);
   Efree(path);
   EDBUG_RETURN(image);
}

void FreeImageDat(ImageDat * dat)
{
   EDBUG(5, "FreeImageDat");
   if (!dat)
      EDBUG_RETURN_;
   Efree(dat->name);
   dat->name = NULL;
   Imlib_kill_image(imlib, dat->im);
   Efree(dat);
   dat = NULL;
   EDBUG_RETURN_;
}


ImageList *ConfigImageList(FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   int count = 0;
   ImageList *list = Emalloc(sizeof(ImageList));

   EDBUG(5, "ConfigImageList");
   list->number = 0;
   list->images = NULL;
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("NUMBER", s1, 6)) {
	    list->number = atoi(s2);
	    list->images = Emalloc(list->number * sizeof(ImageList));
	 }
	 else if (!strncmp("IMAGE", s1, 5)) {
	    if (!list->number) {
	       fprintf(stderr, "number must preceed images in ImageList\n");
	       exit(-1);
	    }
	    if (count < list->number) {
	       list->images[count] = LoadImage(s2);
	       count++;
	    }
	 }
	 else
	    fprintf(stderr, "Unknown line in ImageList config\n");
      }
      else
	 end = TRUE;
   }
   EDBUG_RETURN(list);
}

void ScaleImageList(ImageList * list, double scale_w, double scale_h)
{
   int x;

   EDBUG(5, "ScaleImageList");
   for (x = 0; x < list->number; x++) {
      list->images[x]->w *= scale_w;
      list->images[x]->h *= scale_h;
      Imlib_render(imlib, list->images[x]->im, list->images[x]->w,
		   list->images[x]->h);
   }
   EDBUG_RETURN_;
}

void FreeImageList(ImageList * list)
{
   EDBUG(5, "FreeImageList");
   if (!list)
      EDBUG_RETURN_;
   Efree(list->images);
   Efree(list);
   list = NULL;
   EDBUG_RETURN_;
}
