
#include "widget.h"
#include "../econfig.h"
#include "../audio/audio.h"

void CreateStatusWin(StatusWin * statuswin, Window parent)
{
}

void DefaultsStatusWin(StatusWin * statuswin)
{
   statuswin->mono = NULL;
   statuswin->stereo = NULL;
   statuswin->play = NULL;
   statuswin->pause = NULL;
   statuswin->stop = NULL;
   statuswin->bitrate = NULL;
   statuswin->samplerate = NULL;
}

StatusWin *ConfigStatusWin(Window parent, FILE * in)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   StatusWin *statuswin = Emalloc(sizeof(StatusWin));

   EDBUG(5, "ConfigStatusWin");
   DefaultsStatusWin(statuswin);
   while (!end) {
      if (GetNextLine(st, in)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("BEGIN", s1, 5)) {
	    upstr(s2);
	    if (!strncmp("STEREO", s2, 6))
	       statuswin->stereo = ConfigButton(parent, in);
	    else if (!strncmp("MONO", s2, 4))
	       statuswin->mono = ConfigButton(parent, in);
	    else if (!strncmp("PLAY", s2, 4))
	       statuswin->play = ConfigButton(parent, in);
	    else if (!strncmp("PAUSE", s2, 5))
	       statuswin->pause = ConfigButton(parent, in);
	    else if (!strncmp("STOP", s2, 4))
	       statuswin->stop = ConfigButton(parent, in);
	    else if (!strncmp("BITRATE", s2, 7)) {
	       statuswin->bitrate = ConfigTextBox(parent, in);
	       SetTextTextBox(statuswin->bitrate, "   ");
	    }
	    else if (!strncmp("SAMPLERATE", s2, 10)) {
	       statuswin->samplerate = ConfigTextBox(parent, in);
	       SetTextTextBox(statuswin->samplerate, "   ");
	    }
	 }
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      CreateStatusWin(statuswin, parent);
   EDBUG_RETURN(statuswin);
}

int isEventStatusWin(StatusWin * status, XEvent ev)
{
   if (ev.type != Expose)
      return FALSE;
   else if (isEventButton(status->mono, ev))
      return TRUE;
   else if (isEventButton(status->stereo, ev))
      return TRUE;
   else if (isEventButton(status->play, ev))
      return TRUE;
   else if (isEventButton(status->pause, ev))
      return TRUE;
   else if (isEventButton(status->stop, ev))
      return TRUE;
   else if (isEventTextBox(status->bitrate, ev))
      return TRUE;
   else if (isEventTextBox(status->samplerate, ev))
      return TRUE;
   return FALSE;
}

void EventStatusWin(StatusWin * status, XEvent ev)
{
   EDBUG(5, "EventStatusWin");
   UpdateStatusWin(status);
   EDBUG_RETURN_;
}

void ScaleStatusWin(StatusWin * status, double scale_w, double scale_h)
{
   EDBUG(5, "ScaleStatusWin");
   ScaleButton(status->mono, scale_w, scale_h);
   ScaleButton(status->stereo, scale_w, scale_h);
   ScaleButton(status->play, scale_w, scale_h);
   ScaleButton(status->pause, scale_w, scale_h);
   ScaleButton(status->stop, scale_w, scale_h);
   ScaleTextBox(status->bitrate, scale_w, scale_h);
   ScaleTextBox(status->samplerate, scale_w, scale_h);
   EDBUG_RETURN_;
}

void UpdateStatusWin(StatusWin * statuswin)
{
   static int ostereo = 0, omono = 0, obit = -1;
   static int osample = -1, opause = -1, oplay = -1, ostop = -1;
   int stereo = 0, mono = 0, bit = 0, sample = 0, pause = 0;
   int play = 0, stop = 0;
   char temp[4];

   EDBUG(5, "UpdateStatusWin");
   if (!statuswin)
      EDBUG_RETURN_;
   GetAudioStats(&stereo, &mono, &bit, &sample);
   if (playing && !paused)
      play = TRUE;
   else if (paused)
      pause = TRUE;
   else
      stop = TRUE;
   if (statuswin->mono && (mono != omono)) {
      omono = mono;
      if (mono)
	 ClickButton(statuswin->mono);
      else
	 NormalButton(statuswin->mono);
   }
   if (statuswin->stereo && (stereo != ostereo)) {
      ostereo = stereo;
      if (stereo)
	 ClickButton(statuswin->stereo);
      else
	 NormalButton(statuswin->stereo);
   }
   if (statuswin->play && (play != oplay)) {
      oplay = play;
      if (play)
	 UnhideButton(statuswin->play);
      else
	 HideButton(statuswin->play);
   }
   if (statuswin->pause && (pause != opause)) {
      opause = pause;
      if (pause)
	 UnhideButton(statuswin->pause);
      else
	 HideButton(statuswin->pause);
   }
   if (statuswin->stop && (stop != ostop)) {
      ostop = stop;
      if (stop)
	 UnhideButton(statuswin->stop);
      else
	 HideButton(statuswin->stop);
   }
   if (statuswin->bitrate && (bit != obit)) {
      /*   obit = bit; */
      if (bit)
	 sprintf(temp, "%d", bit);
      else
	 sprintf(temp, "   ");
      SetTextTextBox(statuswin->bitrate, temp);
      UpdateTextBox(statuswin->bitrate);
   }
   if (statuswin->samplerate && (sample != osample)) {
      /*    osample = sample; */
      if (sample)
	 sprintf(temp, "%d", sample);
      else
	 sprintf(temp, "   ");
      SetTextTextBox(statuswin->samplerate, temp);
      UpdateTextBox(statuswin->samplerate);
   }
   EDBUG_RETURN_;
}

void FreeStatusWin(StatusWin * status)
{
   EDBUG(5, "FreeStatusWin");
   if (!status)
      EDBUG_RETURN_;
   FreeButton(status->mono);
   FreeButton(status->stereo);
   FreeButton(status->play);
   FreeButton(status->pause);
   FreeButton(status->stop);
   FreeTextBox(status->bitrate);
   FreeTextBox(status->samplerate);
   Efree(status);
   status = NULL;
   EDBUG_RETURN_;
}
