typedef struct {
   Window win, parent;
   int x, y, w, h;
   ImageDat *back;
   int state;
   int exposed;
   int interactive;
   int visible;
   int selected;
   int action_left, action_middle, action_right;
   int fontheight;
   XFontStruct *font_info;
   XFontSet fontset;
   XTextItem *items;
   FnlibFont *fn;
   FnlibStyle fnstyle;
   int use_fn;
   char *fontname;
   int name_x;
   int name_width;
   int bounce;
   int scroll;
   int scroll_time;
   int drawn;
   int multiline;
} TextBox;

void HideTextBox(TextBox * box);
void UnhideTextBox(TextBox * box);
void CreateTextBox(TextBox * box, Window parent);
TextBox *ConfigTextBox(Window parent, FILE * file);
void MoveTextBox(TextBox * box, int x, int y);
void ScaleTextBox(TextBox * box, double scale_w, double scale_h);
void EventTextBox(TextBox * box, XEvent ev);
void SetTextTextBox(TextBox * box, char *text);
void UpdateTextBox(TextBox * box);
int isEventTextBox(TextBox * box, XEvent ev);
char *ReturnTextTextBox(TextBox * box);
void FreeTextBox(TextBox * text);
