#include <math.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include "../common.h"
#include "splay.h"

void sget_info(struct playlist_item *song)
{
   float len;
   char *temp;

   len = filesize(song->path);
   len /= 418.12;
   len = (int) (len / 16) * 16;
   song->length = (int) (rint(len / 38.28));
   temp = strrchr(song->path, '/');
   if (temp + 1) {
      temp++;
      song->name = duplicate(temp);
   }
}

struct player_plugin *setup_plugin(void)
{
   struct player_plugin *temp = Emalloc(sizeof(struct player_plugin));

   temp->init = sinit;
   temp->config = sconfig;
   temp->seek_to_frame = sseek_to_frame;
   temp->play = splay;
   temp->stop = sstop;
   temp->pause_it = spause_it;
   temp->is_file = sis_file;
   temp->get_info = sget_info;
   temp->version_info = sversion_info;
   return temp;
}
