/*==============================================================================

  $Id: drv_esd.c,v 1.6 1998/09/20 21:45:16 miod Exp $

  Mikmod driver for the Enlightment sound daemon (EsounD)

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*

  You should set the hostname of the machine running esd in the environment
  variable 'ESPEAKER'. If this variable is not set, localhost is used.

*/

#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/signal.h>

#include <esd.h>

#include <mikmod.h>

static	int sndfd=-1;
static	char* audiobuffer=NULL;

BOOL ESD_IsThere(void)
{
	int fd;

	/* Try to esablish a minimalist connection */
	if((fd=esd_play_stream(ESD_BITS8|ESD_MONO|ESD_STREAM|ESD_PLAY,11025,
	                       NULL,NULL))<0)
		return 0;

	close(fd);
	return 1;
}

BOOL ESD_Init(void)
{
	esd_format_t format=(md_mode&DMODE_16BITS?ESD_BITS16:ESD_BITS8)|
	       (md_mode&DMODE_STEREO?ESD_STEREO:ESD_MONO)|ESD_STREAM|ESD_PLAY;

	if((sndfd=esd_play_stream(format,md_mixfreq,NULL,NULL))<0) {
		_mm_errno=MMERR_OPENING_AUDIO;
		return 1;
	}
	/* since the default behaviour of SIGPIPE on most Unixes is to kill the
	   program, we'll prefer handle EPIPE ourselves if esd dies */
	signal(SIGPIPE,SIG_IGN);

	if(!(audiobuffer=(char*)_mm_malloc(ESD_BUF_SIZE*sizeof(char))))
		return 1;

	/* try to avoid garbage - it gets better with this, but still present */
	write(sndfd,audiobuffer,ESD_BUF_SIZE);
	write(sndfd,audiobuffer,ESD_BUF_SIZE);

	return VC_Init();
}

void ESD_Exit(void)
{
	VC_Exit();
	if (audiobuffer) {
		/* try to avoid garbage - it gets better with this, but still present */
		if (sndfd>=0) {
  			memset(audiobuffer,0,ESD_BUF_SIZE);
  			write(sndfd,audiobuffer,ESD_BUF_SIZE);
  			write(sndfd,audiobuffer,ESD_BUF_SIZE);
  		}

		free(audiobuffer);
		audiobuffer=NULL;
	}
	if (sndfd>=0) {
		signal(SIGPIPE,SIG_DFL);
		close(sndfd);
		sndfd=-1;
	}
}

void ESD_Update(void)
{
	if(sndfd>=0) {
		if(write(sndfd,audiobuffer,VC_WriteBytes(audiobuffer,ESD_BUF_SIZE))<0)
			/* if we lost our connection with esd, clean up and work as the
			   nosound driver */
			if(errno==EPIPE) {
				signal(SIGPIPE,SIG_DFL);
				close(sndfd);
				sndfd=-1;
			}
	} else
		/* eat data */
		VC_WriteBytes(audiobuffer,ESD_BUF_SIZE);
}

BOOL ESD_Reset(void)
{
	ESD_Exit();
	return ESD_Init();
}

MDRIVER drv_esd={
	NULL,
	"Enlightment sound daemon",
	/* use the same version number as the EsounD release it works with */
	"Enlightment sound daemon (EsounD) driver v0.2.4",
	0,255,
	ESD_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	ESD_Init,
	ESD_Exit,
	ESD_Reset,
	VC_SetNumVoices,
	VC_PlayStart,
	VC_PlayStop,
	ESD_Update,
	VC_VoiceSetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceSetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceReleaseSustain,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};
