/*==============================================================================

  $Id: mlist.c,v 1.5 1998/09/20 21:45:28 miod Exp $

  Functions to handle the playlist.

==============================================================================*/

/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <mikmod.h>
#include "player.h"

void PL_InitList(PLAYLIST* pl)
{
	pl->numused=0;
	pl->current=-1;
	pl->file=pl->archive=NULL;
}

void PL_ClearList(PLAYLIST* pl)
{
	int i;

	for(i=0;i<pl->numused;i++) {
		free(pl->file[i]);
		pl->file[i]=NULL;
		free(pl->archive[i]);
		pl->archive[i]=NULL;
	}
	if(pl->file) {
		free(pl->file);
		pl->file=NULL;
	}
	if(pl->archive) {
		free(pl->archive);
		pl->archive=NULL;
	}
	pl->current=pl->numused=0;
}

int PL_GetCurrent(PLAYLIST* pl,CHAR* retfile,CHAR* retarc)
{
	int index=(pl->current>0)?pl->current:0;

	if(!pl->numused) return 1;

	strcpy(retfile,pl->file[index]);
	if(pl->archive[index]) 
		strcpy(retarc,pl->archive[index]);
	else
		strcpy(retarc,"");

	return (pl->current==(pl->numused-1))?1:0;
}

int PL_GetNext(PLAYLIST* pl,CHAR* retfile,CHAR* retarc)
{
	int ret=0;
	int index;

	if(!pl->numused) return 1;
	pl->current++;
	if(pl->current==pl->numused) {
		pl->current=pl->numused-1; ret=1;
	}

	index=(pl->current>0)?pl->current:0;
	if(retfile)
		strcpy(retfile,pl->file[index]);
	if (retarc) {
		if(pl->archive[index])
			strcpy(retarc,pl->archive[index]);
		else
			strcpy(retarc,"");
	}

	return ret;
}

int PL_GetPrev(PLAYLIST* pl,CHAR* retfile,CHAR* retarc)
{
	int index;

	if(!pl->numused) return 1;
	pl->current--;
	if(pl->current<-1) pl->current=-1;

	index=(pl->current>0)?pl->current:0;
	if(retfile)
		strcpy(retfile,pl->file[index]);
	if(retarc) {
		if(pl->archive[index]) 
			strcpy(retarc,pl->archive[index]);
		else
			strcpy(retarc,"");
	}

	return 0;
}

void PL_Randomize(PLAYLIST* pl)
{
	if(pl->numused>1) {
		int current;

		srandom(time(NULL));
		for(current=0;current<pl->numused-1;current++) {
			int target=(random()%(pl->numused-current))+current;

			if (target!=current) {
				CHAR* temp;

				temp=pl->file[current];
				pl->file[current]=pl->file[target];
				pl->file[target]=temp;
				temp=pl->archive[current];
				pl->archive[current]=pl->archive[target];
				pl->archive[target]=temp;
			}
		}
	}
}

int PL_DelCurrent(PLAYLIST* pl)
{
	int i,index;

	if(!pl->numused) return 1;

	index=(pl->current>0)?pl->current:0;
	free(pl->file[index]);
	free(pl->archive[index]);

	pl->numused--;
	pl->current--;
	for(i=index;i<pl->numused;i++) {
		pl->file[i]=pl->file[i+1];
		pl->archive[i]=pl->archive[i+1];
	}
	pl->file=realloc(pl->file,pl->numused*sizeof(CHAR*));
	pl->archive=realloc(pl->archive,pl->numused*sizeof(CHAR*));

	return 0;
}

void PL_Add(PLAYLIST* pl,CHAR* file,CHAR* arc)
{
	pl->numused++;
	pl->file=realloc(pl->file,pl->numused*sizeof(CHAR*));
	pl->archive=realloc(pl->archive,pl->numused*sizeof(CHAR*));

	pl->file[pl->numused-1]=malloc((strlen(file)+1)*sizeof(CHAR));
	strcpy(pl->file[pl->numused-1],file);
	if(arc) {
		pl->archive[pl->numused-1]=malloc((strlen(arc)+1)*sizeof(CHAR));
		strcpy(pl->archive[pl->numused-1],arc);
	} else
		pl->archive[pl->numused-1]=NULL;
}

BOOL PL_Load(PLAYLIST* pl,CHAR* filename)
{
	FILE *f;
	CHAR file[PATH_MAX*2+2];	/* two complete paths + separator + null */
	CHAR *arc;

	if(!(f=fopen(filename,"r"))) {
		_mm_errno=MMERR_OPENING_FILE;
		return 0;
	}

	while(!feof(f)) {
		fgets(file,PATH_MAX*2+1,f);
		if(file[strlen(file)-1]=='\n') file[strlen(file)-1]=0;
		arc=strchr(file,'|');
		if(!arc)
			MA_FindFiles(pl,file);
		else {
			*arc=0;
			arc++;
			PL_Add(pl,arc,file);
		}
	}
	fclose(f);
	return 1;
}

BOOL PL_Save(PLAYLIST* pl,CHAR* savefile)
{
	FILE *f;
	int i;

	if(!(f=fopen(savefile,"w"))) {
		_mm_errno=MMERR_OPENING_FILE;
		return 0;
	}

	for(i=0;i<pl->numused;i++) {
		if(pl->archive[i])
			fprintf(f,"%s|%s\n",pl->archive[i],pl->file[i]);
		else
			fprintf(f,"%s\n",pl->file[i]);
	}
	fclose(f);
	return 1;
}
