/*  
    XGUSMIX, A guslib based X11 Audio Mixer
    Copyright (C) 1996 by Andy Lo A Foe
    arloafoe@cs.vu.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
                       
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
                                               
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/soundcard.h>
#define __GUS_PATH_APP__
#include "../../include/libgus.h"
#include "gusmix.h"
#include "tcl.h"

#define TRUE 1
#define FALSE 0

unsigned mdevs_mask[] = {
  GUS_MIXER_MASK_MASTER,
  GUS_MIXER_MASK_SYNTH,
  GUS_MIXER_MASK_EFFECT,
  GUS_MIXER_MASK_PCM,
  GUS_MIXER_MASK_PCM1,
  GUS_MIXER_MASK_LINE,
  GUS_MIXER_MASK_MIC,
  GUS_MIXER_MASK_CD,
  GUS_MIXER_MASK_SOFT,
  GUS_MIXER_MASK_GAIN,
  GUS_MIXER_MASK_LOOP,
  0
};
char *mdevs[] = { "main", "synth", "effect", "pcm", "pcm1", "line", "mic", "cd", "soft", "gain", "loop" };
struct ChannelInfo Main, Synth, Effect, Pcm, Pcm1, Line, Mic, Cd, Soft, Gain, Loop;

static int active = FALSE;

void *gus_handle = NULL;
int mversion, devmask, recmask, stereodevs;

int Initialize(int card) {
  Main.id	  = GUS_MIXER_ID_MASTER;
  Synth.id        = GUS_MIXER_ID_SYNTH;
  Effect.id	  = GUS_MIXER_ID_EFFECT;
  Pcm.id          = GUS_MIXER_ID_PCM;
  Pcm1.id	  = GUS_MIXER_ID_PCM1;
  Line.id         = GUS_MIXER_ID_LINE;
  Mic.id          = GUS_MIXER_ID_MIC;
  Cd.id           = GUS_MIXER_ID_CD;
  Soft.id         = GUS_MIXER_ID_SOFT;
  Gain.id         = GUS_MIXER_ID_GAIN;
  Loop.id	  = GUS_MIXER_ID_LOOP;

  Main.mask       = GUS_MIXER_MASK_MASTER;
  Synth.mask      = GUS_MIXER_MASK_SYNTH;
  Effect.mask	  = GUS_MIXER_MASK_EFFECT;
  Pcm.mask        = GUS_MIXER_MASK_PCM;
  Pcm1.mask	  = GUS_MIXER_MASK_PCM1;
  Line.mask       = GUS_MIXER_MASK_LINE;
  Mic.mask        = GUS_MIXER_MASK_MIC;
  Cd.mask         = GUS_MIXER_MASK_CD;
  Soft.mask       = GUS_MIXER_MASK_SOFT;
  Gain.mask       = GUS_MIXER_MASK_GAIN;
  Loop.mask	  = GUS_MIXER_MASK_LOOP;

  Main.lock       = TRUE;
  Synth.lock      = TRUE;
  Effect.lock	  = TRUE;
  Pcm.lock        = TRUE;
  Pcm1.lock	  = TRUE;
  Line.lock       = TRUE;
  Mic.lock        = TRUE;
  Cd.lock         = TRUE;
  Soft.lock       = TRUE;
  Gain.lock       = TRUE;
  Loop.lock	  = TRUE;

  Main.read	= gus_mixer_read_volume;
  Main.write	= gus_mixer_write_volume;
  Synth.read	= gus_mixer_read_synth;
  Synth.write	= gus_mixer_write_synth;
  Effect.read   = gus_mixer_read_effect;
  Effect.write  = gus_mixer_write_effect;
  Pcm.read	= gus_mixer_read_pcm;
  Pcm.write	= gus_mixer_write_pcm;
  Pcm1.read	= gus_mixer_read_pcm1;
  Pcm1.write	= gus_mixer_write_pcm1;
  Line.read	= gus_mixer_read_line;
  Line.write	= gus_mixer_write_line;
  Mic.read	= gus_mixer_read_mic;
  Mic.write	= gus_mixer_write_mic;
  Cd.read	= gus_mixer_read_cd;
  Cd.write	= gus_mixer_write_cd;
  Soft.read	= gus_mixer_read_imix;
  Soft.write	= gus_mixer_write_imix;
  Gain.read	= gus_mixer_read_reclev;
  Gain.write	= gus_mixer_write_reclev;
  Loop.read	= gus_mixer_read_loopback;
  Loop.write	= gus_mixer_write_loopback;

  if (gus_mixer_open(&gus_handle, card - 1, 0) < 0) {
    fprintf(stderr, "Error opening mixer device.\n");
    exit(1);
  }
  
  mversion = gus_mixer_version( gus_handle );
  devmask = gus_mixer_read_devmask( gus_handle );
  recmask = gus_mixer_read_recmask( gus_handle );
  stereodevs = gus_mixer_read_stereodevs( gus_handle );
  
  if (!devmask) {
    fprintf(stderr, "No device found.\n");
    exit(-1);
  }
  active = TRUE;
  return;
}


struct ChannelInfo *SelectSource(char *string) {
  if (strcmp(string, "main") == 0)
     return &Main;
  else
  if (strcmp(string, "synth") == 0)
     return &Synth;
  else
  if (strcmp(string, "effect") == 0)
     return &Effect;
  else
  if (strcmp(string, "pcm") == 0)
     return &Pcm;
  else
  if (strcmp(string, "pcm1") == 0)
     return &Pcm1;
  else
  if (strcmp(string, "line") == 0)
     return &Line;
  else  
  if (strcmp(string, "mic") == 0)
     return &Mic;
  else
  if (strcmp(string, "cd") == 0)
     return &Cd;
  else
  if (strcmp(string, "soft") == 0)
     return &Soft;
  else
  if (strcmp(string, "gain") == 0)
     return &Gain;
  else
  if (strcmp(string, "loop") == 0)
     return &Loop;
  else return (NULL);
}

 
int GusmixCmd(ClientData dummy, Tcl_Interp *interp, int argc, char *argv[]) {
  struct ChannelInfo *chi;
  char str[80], *pstr;
  int left=0, right=0;
  int i, val;

  if (argc < 2) {
     Tcl_AppendResult(interp, "gusmix", 
                      ": must give one of open, close, get, set, rec or mixerchip",
		      NULL);
     return (TCL_ERROR);
   }
  
  if (argv[1][0] == 'o' && strcmp(argv[1], "open") == 0) {
     if (argc < 3) 
        Initialize(0);
     else
        Initialize(atoi(argv[2]));
     return (TCL_OK);
     }
  if (!active) {
     Tcl_AppendResult(interp, "gusmix", ": need to open first", NULL);
     return (TCL_ERROR);
     }
  if (argv[1][0] == 'c' && strcmp(argv[1], "close") == 0) {
     gus_mixer_close(gus_handle);
     return (TCL_OK);
     }
  if (argv[1][0] == 'm' && strcmp(argv[1], "mixerchip") == 0) {
     pstr = gus_mixer_model( gus_handle );
     Tcl_AppendResult(interp, pstr, NULL);
     free(pstr);
     return (TCL_OK); 
    }
  if (argv[1][0] =='m' && 
      (strcmp(argv[1], "mdevs") == 0 || strcmp(argv[1], "mdevs_mute") == 0)) {
     str[ 0 ] = 0;
     val = gus_mixer_read_devmask( gus_handle );
     for ( i = 0; mdevs_mask[ i ]; i++ )
       if ( val & mdevs_mask[ i ] )
         {
           Tcl_AppendResult(interp, mdevs[ i ], NULL);
           Tcl_AppendResult(interp, " ", NULL);
         }
     return (TCL_OK);
  }
  if (argv[1][0] =='m' && strcmp(argv[1], "mdevs_rec") == 0) {
     str[ 0 ] = 0;
     val = gus_mixer_read_recmask( gus_handle );
     for ( i = 0; mdevs_mask[ i ]; i++ )
       if ( val & mdevs_mask[ i ] )
         {
           Tcl_AppendResult(interp, mdevs[ i ], NULL);
           Tcl_AppendResult(interp, " ", NULL);
         }
     return (TCL_OK);
  }
  if (argc < 3) {
     Tcl_AppendResult(interp, "gusmix", ": need device name", NULL);
     return (TCL_ERROR);
     }
  if ((chi = SelectSource(argv[1])) == NULL) {
    Tcl_AppendResult(interp, "gusmix", ": invalid device ", argv[2], NULL);
    return (TCL_ERROR);
    }
  if (argv[2][0] == 's' && strcmp(argv[2], "set") == 0) {
     if (argc < 5) {
        Tcl_AppendResult(interp, "gusmix set", ": need left right param",
			 NULL);
	return (TCL_ERROR);
        }
     sscanf(argv[3], "%d", &left);
     sscanf(argv[4], "%d", &right);
     if (left < 0 || left > 100) 
        left = 0;
     if (right < 0 || right > 100) 
        right = 0;
     chi->write(gus_handle, left | right << 8);
     return (TCL_OK);
     }
  if (argv[2][0] == 'g' && strcmp(argv[2], "get") == 0) {
     if (argc < 3) {
        Tcl_AppendResult(interp, "gusmix get", ": need source parameter",
			 NULL);
        return (TCL_ERROR);
        }
     val = chi->read(gus_handle);
     left = (val & 0xff);
     right = (val >> 8) & 0xff;
     sprintf(str, "%d %d", left, right);
     Tcl_AppendResult(interp, str, NULL);
     return (TCL_OK);
     }
  if (argv[2][0] == 'm' && strcmp(argv[2], "mute") == 0) {
     if (argc == 3) {
        if (gus_mixer_read_devs_lmute( gus_handle ) & chi->mask)
	   Tcl_AppendResult(interp, "on", " ", NULL);
	else
	   Tcl_AppendResult(interp, "off", " ", NULL);
	if (gus_mixer_read_devs_rmute( gus_handle ) & chi->mask) 
	   Tcl_AppendResult(interp, "on", NULL);
	else 
	   Tcl_AppendResult(interp, "off", NULL);
	return (TCL_OK);
	} 
     if (argc < 5) {
        Tcl_AppendResult(interp, "gusmix", "mute needs more params", NULL);
	return (TCL_ERROR);
        }
     if (strcmp(argv[3], "on")) 
        gus_mixer_write_devs_lmute(gus_handle, chi->id, 0);
     else
     if (strcmp(argv[3], "off"))
        gus_mixer_write_devs_lmute(gus_handle, chi->id, 1);
     if (strcmp(argv[4], "on"))
        gus_mixer_write_devs_rmute(gus_handle, chi->id, 0);
     else
     if (strcmp(argv[4], "off"))
        gus_mixer_write_devs_rmute(gus_handle, chi->id, 1);
     return (TCL_OK);
     }
  if (argv[2][0] == 'r' && strcmp(argv[2], "rec") == 0) {
     val = gus_mixer_read_recsrc(gus_handle);
     if (!(chi->mask & recmask))
        return (TCL_OK);
     if (argc == 3) {
        if (val & chi->mask)
	   Tcl_AppendResult(interp, "on", NULL);
	else    
           Tcl_AppendResult(interp, "off", NULL);
        return (TCL_OK);
        }
     if (argc == 4) {
        if (strcmp(argv[3], "off")) {
	   if (!(val & chi->mask))
	      val ^= chi->mask;
           }
	else
        if (strcmp(argv[3], "on")) {
	   if (val & chi->mask) 
	      val ^= chi->mask;
	   }
        gus_mixer_write_recsrc(gus_handle,val);
        }     return (TCL_OK);
     }   

  Tcl_AppendResult(interp, "gusmix", ": gusmix cmd was called", NULL);
  return (TCL_OK);
}
