## -*- perl -*-
## ----------------------------------------------------------------------
## spec/debiandoc_base.pm: base module for debiandoc-sgml generators
## ----------------------------------------------------------------------
## Copyright (C) 1998 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## tag processing
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
sub start
{
}
sub end
{
}

## ----------------------------------------------------------------------
sub start_element
{
    ( $element, $event ) = @_;
    my $name = $element->name;
    my $file = $event->file;
    my $line = $event->line;
    warn "unknown start element $name at $file:$line\n"
	unless $unkwarndone{$name}++;
}
sub end_element
{
    ( $element, $event ) = @_;
    my $name = $element->name;
    my $file = $event->file;
    my $line = $event->line;
    warn "unknown end element $name at $file:$line\n"
	unless $unkwarndone{ $name }++;
}

## ----------------------------------------------------------------------
sub start_debiandoc
{
}
sub end_debiandoc
{
}

## ----------------------------------------------------------------------
sub start_book
{
    _output_start_book();
}
sub end_book
{
    _output_end_book();
}

## ----------------------------------------------------------------------
sub start_titlepag
{
}
sub end_titlepag
{
    _output_titlepag();
}

## ----------------------------------------------------------------------
sub start_title
{
    push_output( 'string' );
    $stat = 'd';
}
sub end_title
{
    $title = pop_output;
    $title =~ s/^\s+//;
    $title =~ s/\s+$//;
    $title =~ s/\s+/ /g;
}

## ----------------------------------------------------------------------
sub start_author
{
    $in_author = 1;
    push_output( 'string' );
    $stat = 'd';
}
sub end_author
{
    push( @authors, pop_output );
    $in_author = 0;
}

## ----------------------------------------------------------------------
sub start_name
{
    push_output( 'string' );
}
sub end_name
{
    my $name = pop_output;
    $name =~ s/^\s+//;
    $name =~ s/\s+$//;
    $name =~ s/\s+/ /g;
    output( $name );
}

## ----------------------------------------------------------------------
sub start_version
{
    push_output( 'string' );
    $stat = 'd';
}
sub end_version
{
    $version = pop_output . '';
    $version =~ s/^\s+//;
    $version =~ s/\s+$//;
    $version =~ s/\s+/ /g;
}

## ----------------------------------------------------------------------
sub start_date
{
    @_ = gmtime();
    $date = POSIX::strftime( "%d %B %Y", 0, 0, 0, $_[3], $_[4], $_[5] );
    $date =~ s/^0//;
    _odata( $date );
}
sub end_date
{
}

## ----------------------------------------------------------------------
sub start_abstract
{
    push_output( 'string' );
    $stat = 'P';
}
sub end_abstract
{
    $abstract = pop_output;
    $abstract =~ s/^\s+//;
    $abstract =~ s/\s+$//;
}

## ----------------------------------------------------------------------
sub start_copyright
{
    push_output( 'string' );
    $stat = 'P';
}
sub end_copyright
{
    $copyright = pop_output;
}

## ----------------------------------------------------------------------
sub start_copyrightsummaries
{
}
sub end_copyrightsummaries
{
    _output_copyrightsummaries( @copyrightsummaries )
	if $#copyrightsummaries > -1;
}

## ----------------------------------------------------------------------
sub start_copyrightsummary
{
    push_output( 'string' );
}
sub end_copyrightsummary
{
    my $copyrightsummary = pop_output;
    $copyrightsummary =~ s/^\s+//;
    $copyrightsummary =~ s/\s+$//;
    $copyrightsummary =~ s/\s+/ /g;
    push( @copyrightsummaries, $copyrightsummary );
}

## ----------------------------------------------------------------------
sub start_toc
{
    ( $element, $event ) = @_;
    $tocdetail = _num_level( _a( 'DETAIL' ) );
    push_output( 'string' );
}
sub end_toc
{
    my $toc = pop_output;
    _output_toc( $toc );
}

## ----------------------------------------------------------------------
sub start_tocentry
{
    ( $element, $event ) = @_;
    push( @elements, $element );
    push_output( 'string' );
    $stat = 'p';
}
sub end_tocentry
{
    my $tocentry = pop_output;
    $tocentry =~ s/^\s+//;
    $tocentry =~ s/\s+$//;
    $tocentry =~ s/\s+/ /g;
    $element = pop( @elements );
    _output_tocentry( $tocentry );
}

## ----------------------------------------------------------------------
sub start_sect
{
    _sect( 0, @_ );
}
sub end_sect
{
}

## ----------------------------------------------------------------------
sub start_sect1
{
    _sect( 1, @_ );
}
sub end_sect1
{
}

## ----------------------------------------------------------------------
sub start_sect2
{
    _sect( 2, @_ );
}
sub end_sect2
{
}

## ----------------------------------------------------------------------
sub start_sect3
{
    _sect( 3, @_ );
}
sub end_sect3
{
}

## ----------------------------------------------------------------------
sub start_sect4
{
    _sect( 4, @_ );
}
sub end_sect4
{
}

## ----------------------------------------------------------------------
sub start_p
{
    push_output( 'string' );
    push( @stats, $stat );
    $stat = 'p';
}
sub end_p
{
    $stat = pop( @stats );
    my $paragraph = pop_output;
    $paragraph =~ s/^\s+//;
    $paragraph =~ s/\s+$//;
    _output_p( $paragraph ) if length( $paragraph );
}

## ----------------------------------------------------------------------
sub start_example
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'x';
}
sub end_example
{
    $stat =~ s/.$//;
    my $example = pop_output;
    $example =~ s/\s+$//;
    _output_example( $example ) if length( $example );
}

## ----------------------------------------------------------------------
sub start_footnotes
{
    ( $element, $event ) = @_;
    push( @elements, $element );
    push_output( 'string' );
}
sub end_footnotes
{
    my $footnotes = pop_output;
    $element = pop( @elements );
    _output_footnotes( $footnotes );
}

## ----------------------------------------------------------------------
sub start_footnote
{
    push_output( 'string' );
    push( @stats, $stat );
    $stat = 'p';
}
sub end_footnote
{
    $stat = pop( @stats );
    my $footnote = pop_output;
    $footnote =~ s/^\s+//;
    $footnote =~ s/\s+$//;
    _output_footnote( $footnote ) if length( $footnote );
    $stat .= 'f' unless $stat =~ m/f$/;
}

## ----------------------------------------------------------------------
sub start_footnoteref
{
    ( $element, $event ) = @_;
    my $footnoteref = _a( 'NUMBER' );
    _output_footnoteref( $footnoteref );
}
sub end_footnoteref
{
}

## ----------------------------------------------------------------------
sub start_tag
{
    push_output( 'string' );
}
sub end_tag
{
    my $tag = pop_output;
    $tag =~ s/^\s+//;
    $tag =~ s/\s+$//;
    $tag =~ s/\s+/ /g;
    _output_tag( $tag );
}

## ----------------------------------------------------------------------
sub start_em
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'i';
}
sub end_em
{
    $stat =~ s/.$//;
    my $em = pop_output;
    $em =~ s/^\s+//;
    $em =~ s/\s+$//;
    _output_em( $em ) if length( $em );
}

## ----------------------------------------------------------------------
sub start_strong
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'b';
}
sub end_strong
{
    $stat =~ s/.$//;
    my $strong = pop_output;
    $strong =~ s/^\s+//;
    $strong =~ s/\s+$//;
    _output_strong( $strong ) if length( $strong );
}

## ----------------------------------------------------------------------
sub start_var
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'i';
}
sub end_var
{
    $stat =~ s/.$//;
    my $var = pop_output;
    $var =~ s/^\s+//;
    $var =~ s/\s+$//;
    _output_var( $var ) if length( $var );
}

## ----------------------------------------------------------------------
sub start_package
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'c';
    $intt++;
}
sub end_package
{
    $intt--;
    $stat =~ s/.$//;
    my $package = pop_output;
    $package =~ s/^\s+//;
    $package =~ s/\s+$//;
    _output_package( $package ) if length( $package );
}

## ----------------------------------------------------------------------
sub start_prgn
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'c';
    $intt++;
}
sub end_prgn
{
    $intt--;
    $stat =~ s/.$//;
    my $prgn = pop_output;
    $prgn =~ s/^\s+//;
    $prgn =~ s/\s+$//;
    _output_prgn( $prgn ) if length( $prgn );
}

## ----------------------------------------------------------------------
sub start_file
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'c';
    $intt++;
}
sub end_file
{
    $intt--;
    $stat =~ s/.$//;
    my $file = pop_output;
    $file =~ s/^\s+//;
    $file =~ s/\s+$//;
    _output_file( $file ) if length( $file );
}

## ----------------------------------------------------------------------
sub start_tt
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'c';
    $intt++;
}
sub end_tt
{
    $intt--;
    $stat =~ s/.$//;
    my $tt = pop_output;
    $tt =~ s/^\s+//;
    $tt =~ s/\s+$//;
    _output_tt( $tt ) if length( $tt );
}

## ----------------------------------------------------------------------
sub start_qref
{
    ( $element, $event ) = @_;
    push( @elements, $element );
    push_output( 'string' );
}
sub end_qref
{
    my $qref = pop_output;
    $qref =~ s/^\s+//;
    $qref =~ s/\s+$//;
    $element = pop( @elements );
    _output_qref( $qref ) if length( $qref );
}

## ----------------------------------------------------------------------
sub start_ref
{
    ( $element, $event ) = @_;
    push( @elements, $element );
    push_output( 'string' );
}
sub end_ref
{
    my $ref = pop_output;
    $ref =~ s/^\s+//;
    $ref =~ s/\s+$//;
    $element = pop( @elements );
    _output_ref( $ref ) if length( $ref );
}

## ----------------------------------------------------------------------
sub start_manref
{
    ( $element, $event ) = @_;
    my $name = _a( 'NAME' );
    $name =~ s/^\s+//;
    $name =~ s/\s+$//;
    my $section = _a( 'SECTION' );
    $section =~ s/^\s+//;
    $section =~ s/\s+$//;
    _output_manref( $name, $section );
}
sub end_manref
{
}

## ----------------------------------------------------------------------
sub start_email
{
    push_output( 'string' );
}
sub end_email
{
    my $email = pop_output;
    $email =~ s/^\s+//;
    $email =~ s/\s+$//;
    _output_email( $email ) if length( $email );
}

## ----------------------------------------------------------------------
sub start_ftpsite
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'c';
}
sub end_ftpsite
{
    $stat =~ s/.$//;
    $ftpsite = pop_output;
    $ftpsite =~ s/^\s+//;
    $ftpsite =~ s/\s+$//;
    $ftpsite =~ s/\s+/ /g;
    _output_ftpsite( $ftpsite ) if length( $ftpsite );
}

## ----------------------------------------------------------------------
sub start_ftppath
{
    $stat =~ s/f$//;
    defined( $ftpsite ) ||
        print( STDERR
	       "Warning: FTPPATH \`$ftppath' without preceding FTPSITE\n" );
    push_output( 'string' );
    $stat .= 'c';
}
sub end_ftppath
{
    $stat =~ s/.$//;
    my $ftppath = pop_output;
    $ftppath =~ s/^\s+//;
    $ftppath =~ s/\s+$//;
    $ftppath =~ s/\s+/ /g;
    _output_ftppath( $ftpsite, $ftppath ) if length( $ftppath );
}

## ----------------------------------------------------------------------
sub start_httpsite
{
    $stat =~ s/f$//;
    push_output( 'string' );
    $stat .= 'c';
}
sub end_httpsite
{
    $stat =~ s/.$//;
    $httpsite = pop_output;
    $httpsite =~ s/^\s+//;
    $httpsite =~ s/\s+$//;
    $httpsite =~ s/\s+/ /g;
    _output_httpsite( $httpsite ) if length( $httpsite );
}

## ----------------------------------------------------------------------
sub start_httppath
{
    $stat =~ s/f$//;
    defined( $httpsite ) ||
        print( STDERR
	       "Warning: HTTPPATH \`$httppath' without preceding HTTPSITE\n" );
    push_output( 'string' );
    $stat .= 'c';
}
sub end_httppath
{
    $stat =~ s/.$//;
    my $httppath = pop_output;
    $httppath =~ s/^\s+//;
    $httppath =~ s/\s$//;
    $httppath =~ s/\s+/ /g;
    _output_httppath( $httpsite, $httppath ) if length( $httppath );
}

## ----------------------------------------------------------------------
sub start_url
{
    ( $element, $event ) = @_;
    my $id = _a( 'ID' );
    $id =~ s/^\s+//;
    $id =~ s/\s+$//;
    $id =~ s/\s+/ /g;
    my $name = _a( 'NAME' );
    $name =~ s/^\s+//;
    $name =~ s/\s+$//;
    $name =~ s/\s+/ /g;
    $name = "" if ( $name eq '\|\|' ) || ( $name eq $id );
    _output_url( $id, $name ) if length( $id );
}
sub end_url
{
}

## ----------------------------------------------------------------------
sub cdata
{
    &_odata;
}
sub sdata
{
    &_odata;
}

## ----------------------------------------------------------------------
## helper definitions
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
sub _num_level
{
    my ( $d ) = @_;
    return 0 if $d =~ m/^CHAPT|APPENDIX/;
    return $1+1 if $d =~ m/^SECT(\d*)$/;
    warn "unknown toc detail token \`$d'\n";
}

## ----------------------------------------------------------------------
sub _a
{
    my $el = $element->attribute( $_[0] );
    return defined( $el ) ? $el->value : undef;
}

## ----------------------------------------------------------------------
## SGML definitions
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
use SGMLS::Refs;

## ----------------------------------------------------------------------
sgml( 'start', \&start );
sgml( 'end', \&end );

## ----------------------------------------------------------------------
sgml( 'start_element', \&start_element );
sgml( 'end_element', \&end_element );

## ----------------------------------------------------------------------
sgml( '<DEBIANDOC>', \&start_debiandoc );
sgml( '</DEBIANDOC>', \&end_debiandoc );

## ----------------------------------------------------------------------
sgml( '<BOOK>', \&start_book );
sgml( '</BOOK>', \&end_book );

## ----------------------------------------------------------------------
sgml( '<TITLEPAG>', \&start_titlepag );
sgml( '</TITLEPAG>', \&end_titlepag );

## ----------------------------------------------------------------------
sgml( '<TITLE>', \&start_title );
sgml( '</TITLE>', \&end_title );

## ----------------------------------------------------------------------
sgml( '<AUTHOR>', \&start_author );
sgml( '</AUTHOR>', \&end_author );

## ----------------------------------------------------------------------
sgml( '<NAME>', \&start_name );
sgml( '</NAME>', \&end_name );

## ----------------------------------------------------------------------
sgml( '<VERSION>', \&start_version );
sgml( '</VERSION>', \&end_version );

## ----------------------------------------------------------------------
sgml( '<DATE>', \&start_date );
sgml( '</DATE>', \&end_date );

## ----------------------------------------------------------------------
sgml( '<ABSTRACT>', \&start_abstract );
sgml( '</ABSTRACT>', \&end_abstract );

## ----------------------------------------------------------------------
sgml( '<COPYRIGHT>', \&start_copyright );
sgml( '</COPYRIGHT>', \&end_copyright );

## ----------------------------------------------------------------------
sgml( '<COPYRIGHTSUMMARIES>', \&start_copyrightsummaries );
sgml( '</COPYRIGHTSUMMARIES>', \&end_copyrightsummaries );

## ----------------------------------------------------------------------
sgml( '<COPYRIGHTSUMMARY>', \&start_copyrightsummary );
sgml( '</COPYRIGHTSUMMARY>', \&end_copyrightsummary );

## ----------------------------------------------------------------------
sgml( '<TOC>', \&start_toc );
sgml( '</TOC>', \&end_toc );

## ----------------------------------------------------------------------
sgml( '<TOCENTRY>', \&start_tocentry );
sgml( '</TOCENTRY>', \&end_tocentry );

## ----------------------------------------------------------------------
sgml( '<CHAPT>', \&start_chapt );
sgml( '</CHAPT>', \&end_chapt );

## ----------------------------------------------------------------------
sgml( '<APPENDIX>', \&start_appendix );
sgml( '</APPENDIX>', \&end_appendix );

## ----------------------------------------------------------------------
sgml( '<SECT>', \&start_sect );
sgml( '</SECT>', \&end_sect );

## ----------------------------------------------------------------------
sgml( '<SECT1>', \&start_sect1 );
sgml( '</SECT1>', \&end_sect1 );

## ----------------------------------------------------------------------
sgml( '<SECT2>', \&start_sect2 );
sgml( '</SECT2>', \&end_sect2 );

## ----------------------------------------------------------------------
sgml( '<SECT3>', \&start_sect3 );
sgml( '</SECT3>', \&end_sect3 );

## ----------------------------------------------------------------------
sgml( '<SECT4>', \&start_sect4 );
sgml( '</SECT4>', \&end_sect4 );

## ----------------------------------------------------------------------
sgml( '<HEADING>', \&start_heading );
sgml( '</HEADING>', \&end_heading );

## ----------------------------------------------------------------------
sgml( '<P>' , \&start_p );
sgml( '</P>', \&end_p );

## ----------------------------------------------------------------------
sgml( '<EXAMPLE>', \&start_example );
sgml( '</EXAMPLE>', \&end_example );

## ----------------------------------------------------------------------
sgml( '<FOOTNOTES>', \&start_footnotes );
sgml( '</FOOTNOTES>', \&end_footnotes );

## ----------------------------------------------------------------------
sgml( '<FOOTNOTE>', \&start_footnote );
sgml( '</FOOTNOTE>', \&end_footnote );

## ----------------------------------------------------------------------
sgml( '<FOOTNOTEBODY>', \&start_footnotebody );
sgml( '</FOOTNOTEBODY>', \&end_footnotebody );

## ----------------------------------------------------------------------
sgml( '<FOOTNOTEREF>', \&start_footnoteref );
sgml( '</FOOTNOTEREF>', \&end_footnoteref );

## ----------------------------------------------------------------------
sgml( '<LIST>', \&start_list );
sgml( '</LIST>', \&end_list );

## ----------------------------------------------------------------------
sgml( '<ENUMLIST>', \&start_enumlist );
sgml( '</ENUMLIST>', \&end_enumlist );

## ----------------------------------------------------------------------
sgml( '<TAGLIST>', \&start_taglist );
sgml( '</TAGLIST>', \&end_taglist );

## ----------------------------------------------------------------------
sgml( '<TAG>', \&start_tag );
sgml( '</TAG>', \&end_tag );

## ----------------------------------------------------------------------
sgml( '<ITEM>', \&start_item );
sgml( '</ITEM>', \&end_item );

## ----------------------------------------------------------------------
sgml( '<EM>',\&start_em );
sgml( '</EM>', \&end_em );

## ----------------------------------------------------------------------
sgml( '<STRONG>', \&start_strong );
sgml( '</STRONG>', \&end_strong );

## ----------------------------------------------------------------------
sgml( '<VAR>', \&start_var );
sgml( '</VAR>', \&end_var );

## ----------------------------------------------------------------------
sgml( '<PACKAGE>', \&start_package );
sgml( '</PACKAGE>', \&end_package );

## ----------------------------------------------------------------------
sgml( '<PRGN>', \&start_prgn );
sgml( '</PRGN>', \&end_prgn );

## ----------------------------------------------------------------------
sgml( '<FILE>', \&start_file );
sgml( '</FILE>', \&end_file );

## ----------------------------------------------------------------------
sgml( '<TT>', \&start_tt );
sgml( '</TT>', \&end_tt );

## ----------------------------------------------------------------------
sgml( '<QREF>', \&start_qref );
sgml( '</QREF>', \&end_qref );

## ----------------------------------------------------------------------
sgml( '<REF>', \&start_ref );
sgml( '</REF>', \&end_ref );

## ----------------------------------------------------------------------
sgml( '<MANREF>', \&start_manref );
sgml( '</MANREF>', \&end_manref );

## ----------------------------------------------------------------------
sgml( '<EMAIL>', \&start_email );
sgml( '</EMAIL>', \&end_email );

## ----------------------------------------------------------------------
sgml( '<FTPSITE>', \&start_ftpsite );
sgml( '</FTPSITE>', \&end_ftpsite );

## ----------------------------------------------------------------------
sgml( '<FTPPATH>', \&start_ftppath );
sgml( '</FTPPATH>', \&end_ftppath );

## ----------------------------------------------------------------------
sgml( '<HTTPSITE>', \&start_httpsite );
sgml( '</HTTPSITE>', \&end_httpsite );

## ----------------------------------------------------------------------
sgml( '<HTTPPATH>', \&start_httppath );
sgml( '</HTTPPATH>', \&end_httppath );

## ----------------------------------------------------------------------
sgml( '<URL>', \&start_url );
sgml( '</URL>', \&end_url );

## ----------------------------------------------------------------------
sgml( 'cdata', \&cdata );
sgml( 'sdata', \&sdata );

## ----------------------------------------------------------------------
1;

## ----------------------------------------------------------------------
