;; $Id: dbsect.dsl 1.7 1998/07/31 13:25:25 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================== SECTIONS ==============================

;; BRIDGEHEAD isn't a proper section, but appears to be a section title
(element bridgehead
  (let* ((renderas (attribute-string "renderas"))
	 (hlevel                          ;; the apparent section level;
	  (if renderas                    ;; if not real section level,
	      (string->number             ;;   then get the apparent level
	       (substring renderas 4 5))  ;;   from "renderas",
	      (SECTLEVEL)))               ;; else use the real level
	 (helem
	  (string-append "H" (number->string (+ hlevel 1)))))
    (make element gi: helem
	  (process-children))))

(define ($section-separator$) 
  (if (or (not nochunks) (node-list=? (current-node) (sgml-root-element)))
      (empty-sosofo)
      (make empty-element gi: "HR")))

(define ($section$)
  (html-document (with-mode head-title-mode (process-first-descendant (normalize "title")))
		 ($section-body$)))

(define ($section-body$)
  (make sequence
    ($section-separator$)
    ($section-title$)
    (process-children)))

(define ($section-title$)
  (let* ((sect (current-node))
	 (info (info-element))
	 (subtitles (select-elements (children info) (normalize "subtitle")))
	 (renderas (inherited-attribute-string (normalize "renderas") sect))
	 (hlevel                          ;; the apparent section level;
	  (if renderas                    ;; if not real section level,
	      (string->number             ;;   then get the apparent level
	       (substring renderas 4 5))  ;;   from "renderas",
	      (SECTLEVEL)))               ;; else use the real level
	 (h1elem
	  (string-append "H" (number->string hlevel)))
	 (h2elem
	  (string-append "H" (number->string (+ hlevel 1))))
	 (name (element-id))
	 (isep (gentext-intra-label-sep (gi sect)))
	 (nsep (gentext-label-title-sep (gi sect))))
    (make sequence
      (make element gi: h1elem
	    (make element gi: "A"
		  attributes: (list (list "NAME" name))
		  (if (string=? (element-label (current-node)) "")
		      (empty-sosofo)
		      (literal (element-label (current-node)) nsep))
		  (element-title-sosofo sect)))
      (if (node-list-empty? subtitles) 
	  (empty-sosofo)
	  (with-mode subtitle-mode
	    (make element gi: h2elem
		  (process-node-list subtitles))))
      ($section-info$ info))))

(define ($section-info$ info)
  (cond ((equal? (gi) (normalize "sect1"))
	 ($sect1-info$ info))
	((equal? (gi) (normalize "sect2"))
	 ($sect2-info$ info))
	((equal? (gi) (normalize "sect3"))
	 ($sect3-info$ info))
	((equal? (gi) (normalize "sect4"))
	 ($sect4-info$ info))
	((equal? (gi) (normalize "sect5"))
	 ($sect5-info$ info))
	((equal? (gi) (normalize "refsect1"))
	 ($refsect1-info$ info))
	((equal? (gi) (normalize "refsect2"))
	 ($refsect2-info$ info))
	((equal? (gi) (normalize "refsect3"))
	 ($refsect3-info$ info))
	(else (empty-sosofo))))

(define ($sect1-info$ info) (empty-sosofo))
(define ($sect2-info$ info) (empty-sosofo))
(define ($sect3-info$ info) (empty-sosofo))
(define ($sect4-info$ info) (empty-sosofo))
(define ($sect5-info$ info) (empty-sosofo))
(define ($refsect1-info$ info) (empty-sosofo))
(define ($refsect2-info$ info) (empty-sosofo))
(define ($refsect3-info$ info) (empty-sosofo))

(element sect1 ($section$))
(element (sect1 title) (empty-sosofo))

(element sect2 ($section$))
(element (sect2 title) (empty-sosofo))

(element sect3 ($section$))
(element (sect3 title) (empty-sosofo))

(element sect4 ($section$))
(element (sect4 title) (empty-sosofo))

(element sect5 ($section$))
(element (sect5 title) (empty-sosofo))

(element simplesect ($section$))
(element (simplesect title) (empty-sosofo))

