#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "config.h"
#include "mswordview.h"

blipdata * get_blips(U32 fcDggInfo,U32 lcbDggInfo,FILE *tablefd,FILE *mainfd,int *noofblips)
	{
	U16 element;
	U32 len;
	U32 fulllen=0;
	U32 noofpics;
	U32 offset;
	int i;
	FILE *graphic;
	char *buffer;
	int no=0;
	blipdata *head=NULL;
	blipdata *p=NULL;

	int currentspid=0;
	
	U16 spids[1024];
	char *names[1024];

	U16 id;
	U32 op;

	memset(names, 0, 1024);
	*noofblips=0;

	fseek(tablefd,fcDggInfo,SEEK_SET);

	while(fulllen < lcbDggInfo)
		{
		read_16ubit(tablefd);
		element = read_16ubit(tablefd);
		len = read_32ubit(tablefd);
		fulllen+=8;
		error(stderr,"len is %x, element is %x\n",len,element);
		error(stderr,"dec, fullen is %d, lcbDggInfo is %d\n",fulllen,lcbDggInfo);
		switch (element)
			{
			case 0xF000:
				/*keep going*/
				break;
			case 0xF006:
				read_32ubit(tablefd);
				read_32ubit(tablefd);
				read_32ubit(tablefd);
				noofpics = read_32ubit(tablefd);
				fulllen+=16;
				error(stderr,"there are %d pics visible\n",noofpics);
				for (i=0;i<noofpics;i++)
					{
					read_32ubit(tablefd);
					read_32ubit(tablefd);
					fulllen+=8;
					}
				break;
			case 0xf001: /*container for pics*/
				break;
			case 0xf002: /*container for page or something*/
				break;
			case 0xf003: /*container for many shapes*/
				break;
			case 0xf004: /*container for a shape*/
				break;
			case 0xf005: /*container for shape rules*/
				break;
			case 0xf007: /*a pic, yeah!!*/
				error(stderr,"window pic type is %d\n",getc(tablefd));	
				error(stderr,"mac pic type is %d\n",getc(tablefd));	
				for(i=0;i<18;i++)
					getc(tablefd);
				fulllen+=18;
				error(stderr,"pic data len is (%x)\n",read_32ubit(tablefd));
				read_32ubit(tablefd);
				offset = read_32ubit(tablefd);
				fulllen+=12;
				error(stderr,"file offset into main stream is %x\n",offset);

				buffer = malloc(strlen("graphic100-mswv.tiff")+80);
				if (buffer==NULL)
					{
					fprintf(stderr,"no mem\n");
					exit(-1);
					}

				if (offset != 0xffffffffUL)
					{
					fseek(mainfd,offset,SEEK_SET);
					read_16ubit(mainfd);
					element = read_16ubit(mainfd);
					len = read_32ubit(mainfd);
					error(stderr,"graphic len is %x\n",len);
					if ((element >= 0xf018) && (element <= 0xf117))
						{
						switch (element - 0xf018)
							{
							case 6:
								sprintf(buffer,"graphic%d-mswv.%s",no+1,"png");
								for(i=0;i<33;i++)
									getc(mainfd);
								len-=33;
								break;
							case 5:
								sprintf(buffer,"graphic%d-mswv.%s",no+1,"jpg");
								for(i=0;i<17;i++)
									getc(mainfd);
								len-=17;
								break;
							default:
								sprintf(buffer,"graphic-dontknow%d-mswv.jpg",no+1);
								break;
							}

						names[no++] = buffer;

						graphic = fopen(buffer,"w");
						if (graphic == NULL)
							fprintf(stderr,"warning couldnt create file %s, ignoring\n",buffer);
						else
							{
							error(stderr,"len changed to %x\n",len);
							for (i=0;i<len;i++)
								putc(getc(mainfd),graphic);

							}
						}
					}
				else
					{
					sprintf(buffer,"graphic-badoffset%d-mswv.jpg",no+1);
					names[no++] = buffer;
					}
				error(stderr,"blit id %d is filename %s\n",no,names[no-1]);
				read_32ubit(tablefd);
				fulllen+=4;
				break;
			case 0xf11e:
				/*i dont quite understand this for now*/
				len=25;
				for(i=0;i<len;i++)
					{
					getc(tablefd);
					fulllen++;
					}
				break;
			case 0xf008:
				read_32ubit(tablefd);	
				/*
				error(stderr,"1 the id of this entity is %x\n",read_32ubit(tablefd));
				*/
				read_32ubit(tablefd);	
				fulllen+=8;
				break;
			case 0xf00a:
				spids[currentspid++] = read_32ubit(tablefd);
				error(stderr,"2 the id of this entity is %x\n",spids[currentspid-1]);
				/*
				this is the identity of the object, the real spid as far 
				as im concerned, following this will be the shape property
				table that will have a list of blits associated with
				this id, (referred to by an index into the previous blit 
				table)
				*/
				fulllen+=4;
				for(i=0;i<len-4;i++)
					{
					getc(tablefd);
					fulllen++;
					}
				break;
			case 0xf00b:
				id = read_16ubit(tablefd);
				op = read_32ubit(tablefd);
				if ((id & 0x4000) && (!(id & 0x800)))
					{
					error(stderr,"talking about a blit of id %x\n",op);
					error(stderr,"so given spid %x, the blit id is %d, and the filename is %s\n",spids[currentspid-1],op,names[op-1]);
					if (head == NULL)
						{
						head = (blipdata *) malloc(sizeof(blipdata));
						if (head == NULL)
							{
							fprintf(stderr,"no mem\n");
							exit(-1);
							}
						p = head;
						}
					else
						{
						p->next = (blipdata *) malloc(sizeof(blipdata));
						if (p->next == NULL)
							{
							fprintf(stderr,"no mem\n");
							exit(-1);
							}
						p = p->next;
						}

					p->spid = spids[currentspid-1];
					p->filename = names[op-1];
					p->next = NULL;
					(*noofblips)++;
					}
				fulllen+=6;
				for(i=0;i<len-6;i++)
					{
					getc(tablefd);
					fulllen++;
					}
				break;
			default:
				error(stderr,"unrecognized element %x\n",element);
				for(i=0;i<len;i++)
					{
					getc(tablefd);
					fulllen++;
					}
				break;
			}
		}
	return(head);
	}

void output_draw(U32 cp,textportions *portions)
	{
	int i;
	U16 ourspid=0;
	blipdata *p;

	error(stderr,"in output_draw, only able to handle blips, not real draw objects as of yet\n");


	for (i=0;i<portions->noofficedraw;i++)
		{
		if (cp == portions->officedrawcps[i])
			{
			ourspid = portions->spids[i];
			break;
			}
		}
	
	error(stderr,"noofficedraw is %d portions->noofblipdata is %d\n",portions->noofficedraw,portions->noofblipdata);

	p = portions->ablipdata;

	if ((ourspid != 0) && (p != 0)) /*Craig J Copi <cjc5@po.cwru.edu>*/
		{
		/*search to see if theres a filename assiciated with this spid*/
		for(i=0;i<portions->noofblipdata;i++)
			{
			error(stderr,"p->spid is %x\n",p->spid);
			if (ourspid == p->spid)
				{
				printf("<img src=\"%s\">",p->filename);
				error(stderr,"success!\n");
				return;
				}
			p = p->next;
			}
		}
	error(stderr,"given spid %x, no luck\n",ourspid);
	}

