#!@SHELL@

# Don't hack this script by hand if it's in one of your PATH directories.
# Instead, modify the pre-script in the YODL source package and do a 
# "make installscripts".

#################################################### Print error msg and die.
error()
{
    echo yodl2msps: $@ 1>&2
    exit 1
}

################################################### Print usage info and die.
usage()
{
    cat << ENDUSAGE
Yodl2msps @TOPLEVEL_VERSION@

Usage: yodl2msps [OPTION]... FILE
Options:
    for processing, run "yodl" without arguments to see
This converter runs "yodl2ms" to convert the input file to ms format, 
then runs "@MSTOPS@" to convert it to PostScript format.
ENDUSAGE

    exit 1
}

###################################################### Start of main program.

# get all flags
flags=""
inf=""
while [ "$1" != "" ] ; do
    case $1 in
        -*)
            flags="$flags $1"
            shift
            ;;
        *)
            inf=$1
            shift
            ;;
    esac
done

# no input file, nogo
if [ "$inf" = "" ] ; then
    usage
fi

# determine output file, logfile, dvi file
msf=${inf%%.yo}.ms
psf=${inf%%.yo}.ps

yodl2ms $flags $inf || error "YODL to LaTeX conversion failed"
@MSTOPS@ $msf > $psf || error "ms to PostScript conversion failed"
