
/* spoonman@unforgettable.com */

#include <sys/param.h>
#include <sys/stat.h>
#include <string.h>
#include <dirent.h>
#include <signal.h>
#include "config.h"
#include "plaid.xpm"
#include "gnote.h"

#define GNOTES_MAX (1024)


  /* number of notes */
  static int notescount=0;

  /* THE notes */
  static struct Gnote notes[GNOTES_MAX];


  void gnote_signal_handler(int signal)
    {
    int index;

    switch (signal)
      {
      case SIGHUP:   /* zap all the notes and reload 'em */
        for (index=0; index < notescount; index++)
          {
          gtk_widget_destroy(notes[index].window);
          };
        notescount=0;
        gnotes_action(NULL, GNOTES_LOAD);
        break;
      default:
        printf("gnote: SIGNAL %d received\n", signal);
        break;
      };
    };

/*
  gint gnote_resize_cb(GtkWidget *widget, gpointer handle_boxptr)
    {
    int index;

    g_debug("gnote_resize_cb();");

    for (index=0; index < notescount; index++)
      {
      if (handle_boxptr == notes[index].handle_box)
        {
        gint win_x=0, win_y=0, ptr_x=0, ptr_y=0;


        gdk_window_get_origin(widget->parent->window, &win_x, &win_y);
        gdk_window_get_pointer(widget->parent->window, &new_ptr_x, &new_ptr_y,
          NULL);

        gtk_widget_set_usize(notes[notescount].window,
          notes[notescount].width, notes[notescount].height);
        };
      };


    return(FALSE);
    };
*/

  gint gnote_delete_cb(GtkWidget *widget, gpointer handle_boxptr)
    {
    int index;
    long addr, naddr;

    g_debug("gnote_delete_cb();");

    for (index=0; index < notescount; index++)
      {
      if (handle_boxptr == notes[index].handle_box)
        {
        char *fname;

        notes[index].deleted = TRUE;
        fname = (char *)malloc(strlen(getenv("HOME")) + strlen(GNOTES_DIR) +
          strlen(notes[index].filename) + 1);
        snprintf(fname, MAXPATHLEN, "%s/%s/%s", getenv("HOME"),
          GNOTES_DIR, notes[index].filename);
        g_debug("  deleted [%s]", fname);
        unlink(fname);
        free(fname);

        gtk_widget_destroy(notes[index].window);
        };
      };

    return(FALSE);
    };

  gint gnote_changed_cb(GtkWidget *text, GdkEventButton *event, gpointer data)
    {
    int index=0;

    while ((index < notescount) && text != notes[index].text)
      index++;
    notes[index].timestamp = time(NULL);
    };


  void gnote_menu(GtkWidget *handle_box, GdkEventButton *event)
    {
    GtkWidget *menu, *sub;
    GtkWidget *menuitem;
  
    g_debug("gnote_menu();");

    menu = gtk_menu_new();

      {
      int index=0;
      time_t timestamp;
      char *timestr;
      GtkWidget *entry;

      timestamp = time(NULL);

      while ((index < notescount) && (handle_box != notes[index].handle_box))
        index++;

      if (strlen(notes[index].title) == 0)
        {
        sprintf(notes[index].title, "GNotes!");
        };

      /* put the title menu item */
      menuitem = gtk_menu_item_new_with_label(notes[index].title);
      gtk_menu_append(GTK_MENU(menu), menuitem);

#ifdef TESTING
      /* add the sub menu */
      sub = gtk_menu_new();
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), sub);

      /* add an entry field */
      entry = gtk_entry_new();
      gtk_entry_set_text(GTK_ENTRY(entry), notes[index].title);
      menuitem = gtk_menu_item_new();
      gtk_container_add(GTK_CONTAINER(menuitem), entry);
      gtk_menu_append(GTK_MENU(sub), menuitem);
#else
      gtk_signal_connect_object(GTK_OBJECT(menuitem),"select",
        GTK_SIGNAL_FUNC(gtk_item_deselect), GTK_OBJECT(menuitem));
#endif

      timestr = asctime(localtime(&notes[index].timestamp));
      timestr[strlen(timestr)-1] = '\000';  /* get rid of '\n' */

      menuitem = gtk_menu_item_new_with_label(timestr);
      gtk_menu_append(GTK_MENU(menu), menuitem);
      gtk_signal_connect_object(GTK_OBJECT(menuitem),"select",
        GTK_SIGNAL_FUNC(gtk_item_deselect), GTK_OBJECT(menuitem));
      };

    /* separator */
    menuitem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(menu), menuitem);

    menuitem = gtk_menu_item_new_with_label(_(GNOTES_SAVE));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnotes_action), (gpointer)GNOTES_SAVE);
    gtk_menu_append(GTK_MENU(menu), menuitem);
 
    menuitem = gtk_menu_item_new_with_label(_(GNOTES_RAISE));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnotes_action), (gpointer)GNOTES_RAISE);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTES_LOWER));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnotes_action), (gpointer)GNOTES_LOWER);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTES_HIDE));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnotes_action), (gpointer)GNOTES_HIDE);
    gtk_menu_append(GTK_MENU(menu), menuitem);

/* 
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_RESIZE));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_resize_cb), (gpointer)GNOTE_RESIZE);
    gtk_menu_append(GTK_MENU(menu), menuitem);
*/
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_DELETE));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_delete_cb), handle_box);
    gtk_menu_append(GTK_MENU(menu), menuitem);

    /* separator */
    menuitem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(menu), menuitem);
 
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_1x1));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_1x1);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_1x2));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_1x2);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_2x2));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_2x2);
    gtk_menu_append(GTK_MENU(menu), menuitem);

    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_2x3));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_2x3);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_3x3));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_3x3);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_3x4));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_3x4);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_4x4));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_4x4);
    gtk_menu_append(GTK_MENU(menu), menuitem);
  
    menuitem = gtk_menu_item_new_with_label(_(GNOTE_NEW_4x5));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
      GTK_SIGNAL_FUNC(gnote_new_cb), (gpointer)GNOTE_NEW_4x5);
    gtk_menu_append(GTK_MENU(menu), menuitem);
 
    gtk_widget_show_all(menu);
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, event->button,
      event->time);
    };

  static gint ptr_x=0, ptr_y=0;

  gint gnote_motion_cb(GtkWidget *widget, GdkEventButton *event,
    gpointer data)
    {
    gint win_x=0, win_y=0, new_ptr_x=0, new_ptr_y=0;

    gdk_window_get_origin(widget->parent->window, &win_x, &win_y);
    gdk_window_get_pointer(widget->parent->window, &new_ptr_x, &new_ptr_y,
      NULL);

    /* new position minus the pointer position in the widget */
    win_x += new_ptr_x - ptr_x;
    win_y += new_ptr_y - ptr_y;

    gdk_window_raise(widget->parent->window);
    gdk_window_move(widget->parent->window, win_x, win_y);

    return(TRUE);
    };

  gint gnote_handle_button_cb(GtkWidget *widget, GdkEventButton *event,
    gpointer data)
    {
    GdkCursor *cursor;

    g_debug("gnote_handle_button_cb();");

    /* get current position in case we're moved! */
    gdk_window_get_pointer(widget->parent->window, &ptr_x, &ptr_y, NULL);

    switch (event->type)
      {
      case GDK_BUTTON_PRESS:
        switch (event->button)
          {
          case 1:
            cursor = gdk_cursor_new(GDK_FLEUR);
            gdk_pointer_grab(widget->window, FALSE, GDK_BUTTON1_MOTION_MASK |
              GDK_BUTTON_RELEASE_MASK, NULL, cursor, event->time);
            gdk_cursor_destroy(cursor);
            break;
          case 2:
            cursor = gdk_cursor_new(GDK_DOT);
            gdk_window_set_cursor(widget->window, cursor);
            gdk_cursor_destroy(cursor);
            break;
          case 3:
            gnote_menu(widget, event);
            break;
          };
        break;
      case GDK_BUTTON_RELEASE:
        switch (event->button)
          {
          case 1:
            gdk_pointer_ungrab(event->time);
            break;
          case 2:
            gnote_new_cb(NULL, (gpointer)GNOTE_NEW_1x1);
            break;
          case 3:
            return(FALSE);
          };
        cursor = gdk_cursor_new(GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(widget->window, cursor);
        gdk_cursor_destroy(cursor);
        break;
      };

    return(TRUE);
    };


  void gnote_new(gint width, gint height, gint x, gint y, gint hidden,
    gchar *text, time_t timestamp, gchar *title)
    {
    g_debug("gnote_new(%d, %d, %d, %d, %d, \"%s\", %ld, \"%s\");",
      width, height, x, y, hidden, text, timestamp, title);

    /* set width, height, x, y, hidden */
    notes[notescount].width = width;
    notes[notescount].height = height;
    notes[notescount].x = x;
    notes[notescount].y = y;
    notes[notescount].hidden = hidden;
    notes[notescount].deleted = FALSE;
    snprintf(notes[notescount].filename, MAXPATHLEN, "%ld", timestamp);
    notes[notescount].timestamp = timestamp;
    snprintf(notes[notescount].title, TITLE_LEN, "%s", title);

    /* create window */
    notes[notescount].window = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_policy(GTK_WINDOW(notes[notescount].window), TRUE, TRUE,
      TRUE);

    if ((notes[notescount].width >= 0) && (notes[notescount].height >= 0))
      {
      gtk_widget_set_usize(notes[notescount].window,
        notes[notescount].width, notes[notescount].height);
      };
    if ((notes[notescount].x >= 0) && (notes[notescount].y >= 0))
      {
      gtk_widget_set_uposition(notes[notescount].window, notes[notescount].x,
        notes[notescount].y);
      };

    /* create text */ 
    notes[notescount].text = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(notes[notescount].text), TRUE);
    gtk_text_set_word_wrap(GTK_TEXT(notes[notescount].text), TRUE);
    gtk_signal_connect(GTK_OBJECT(notes[notescount].text), "changed",
      GTK_SIGNAL_FUNC(gnote_changed_cb), NULL);
    if (text != NULL)
      {
      gtk_text_insert(GTK_TEXT(notes[notescount].text), NULL,
        NULL, NULL, text, strlen(text));
      };

      /* set text color */
      {
      GtkStyle *style;
      GdkColor *yellow;

      yellow = (GdkColor *)malloc(sizeof(GdkColor));
      yellow->red = 0xffff;
      yellow->green = 0xffff;
      yellow->blue = 0x0000;
      yellow->pixel = (gulong)255*750000;

      gdk_color_alloc(gtk_widget_get_colormap(notes[notescount].text), yellow);

      style = gtk_style_new();
      memcpy(&style->base[GTK_STATE_NORMAL], yellow, sizeof(GdkColor));
      gtk_widget_set_style(notes[notescount].text, style);
      };

    /* create handle_box */
    notes[notescount].handle_box = gtk_handle_box_new();
    gtk_signal_connect(GTK_OBJECT(notes[notescount].handle_box),
      "motion_notify_event", GTK_SIGNAL_FUNC(gnote_motion_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(notes[notescount].handle_box),
      "button_press_event", GTK_SIGNAL_FUNC(gnote_handle_button_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(notes[notescount].handle_box),
      "button_release_event", GTK_SIGNAL_FUNC(gnote_handle_button_cb), NULL);
    gtk_widget_set_usize(notes[notescount].handle_box, 10, 0);

    /* create hbox */
    notes[notescount].hbox = gtk_hbox_new(FALSE, 0);

    /* pack it up! */
    gtk_box_pack_start(GTK_BOX(notes[notescount].hbox),
      notes[notescount].handle_box, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(notes[notescount].hbox),
      notes[notescount].text, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(notes[notescount].window),
      notes[notescount].hbox);

    gtk_widget_show_all(notes[notescount].window);

    gdk_window_set_decorations(notes[notescount].window->window, 0);
    gtk_window_set_focus(GTK_WINDOW(notes[notescount].window),
      notes[notescount].text);

      {
      GdkCursor *cursor;

      cursor = gdk_cursor_new(GDK_XTERM);
      gdk_window_set_cursor(notes[notescount].text->window, cursor);
      gdk_cursor_destroy(cursor);
      };

    if (notes[notescount].hidden == TRUE)
      {
      gdk_window_hide(notes[notescount].window->window);
      };
  
    notescount++;
    };

  void gnote_new_cb(AppletWidget *applet, gpointer data)
    {
    char *sdata;
    gint width;
    gint height;
    int index=0;

    sdata = (char *)malloc(strlen((char *)data));
    sprintf(sdata, "%s", (char *)data);

    width = atoi(strtok(sdata, "x")) * 100;
    height = atoi(strtok(NULL, "x")) * 100;

    if (index < GNOTES_MAX)
      {
      gnote_new(width, height, -1, -1, FALSE, "", time(NULL), "GNotes!");
      }
    else
      {
      g_error("GNotes: gnote_new_cb(): too many notes");
      };

    free(sdata);
    };

  void gnotes_action(AppletWidget *widget, gpointer data)
    {
    char *sdata;
    int index;
  
    sdata = (char *)malloc(strlen((char *)data));
    sprintf(sdata, "%s", (char *)data);
  
    g_debug("gnotes_action(widget, \"%s\");", sdata);
  
    for (index=0; index < notescount; index++)
      {
      #ifdef DEBUG
        printf("%04d - ", index);
/* 
        printf("    notes[%ld]\n",notes[index]);
        printf("    win[%ld]\n",notes[index].window);
        printf("    win->win[%ld]\n",notes[index].window->window);
        printf("    hidden[%d]\n",notes[index].hidden);
        printf("    deleted[%d]\n",notes[index].deleted);
        printf("    filename[%s]\n",notes[index].filename);
        printf("    x[%d]\n",notes[index].x);
        printf("    y[%d]\n",notes[index].y);
        printf("    w[%d]\n",notes[index].width);
        printf("    h[%d]\n",notes[index].height);
        printf("    t[%d]\n",notes[index].text);
        printf("    tt[%ld]\n",GTK_TEXT(notes[index].text)->text);
*/
      #endif

      /* make sure window wasn't marked deleted AND it still exists! */
      if ((notes[index].deleted != TRUE) &&
          (notes[index].window->window != NULL))
        {
        gdk_window_get_position(notes[index].window->window, &notes[index].x,
          &notes[index].y);
        gdk_window_get_size(notes[index].window->window,
          &notes[index].width, &notes[index].height);
  
        /* RAISE notes */
        if (!strncmp(sdata, GNOTES_RAISE, strlen(GNOTES_RAISE)))
          {
          g_debug("Raise Notes");
          gdk_window_raise(notes[index].window->window);
          };
  
        /* LOWER notes */
        if (!strncmp(sdata, GNOTES_LOWER, strlen(GNOTES_LOWER)))
          {
          g_debug("Lower Notes");
          gdk_window_lower(notes[index].window->window);
          };
  
        /* SHOW notes */
        if (!strncmp(sdata, GNOTES_SHOW, strlen(GNOTES_SHOW)))
          {
          g_debug("Show Notes");
          gdk_window_show(notes[index].window->window);
          gtk_widget_set_uposition(notes[index].window, notes[index].x,
            notes[index].y);
          };
  
        /* HIDE notes */
        if (!strncmp(sdata, GNOTES_HIDE, strlen(GNOTES_HIDE)))
          {
          g_debug("Hide Notes");
          gdk_window_hide(notes[index].window->window);
          };
  
        /* SAVE notes */
        if (!strncmp(sdata, GNOTES_SAVE, strlen(GNOTES_SAVE)))
          {
          FILE *fptr;
          char *fname;
          struct stat stats;

          g_debug("Save Notes %dx%d+%d+%d %d %d %ld \"%s\"",notes[index].width,
            notes[index].height, notes[index].x, notes[index].y,
            notes[index].hidden, notes[index].deleted, notes[index].timestamp,
            notes[index].title);

          fname = (char *)malloc(MAXPATHLEN);
          snprintf(fname, MAXPATHLEN, "%ld", notes[index].timestamp);

#ifdef TESTING
/*
this doesn't work right... when trying to save to a correct file
that already exists, it keeps trying to find new files...
*/

          /* make sure file doesn't already exist - since this is only
             possible with NEW notes, we change the filename too so it
             doesn't get unlinked below */
          while (!stat(fname, &stats))
            {
            notes[index].timestamp++;
            snprintf(fname, MAXPATHLEN, "%ld", notes[index].timestamp);
            snprintf(notes[index].filename, MAXPATHLEN, "%ld",
              notes[index].timestamp);
            };
#endif
 
          if ((fptr=fopen(fname,"w")) != NULL)
            {
            int len;
 
            fprintf(fptr,"%s\n", GNOTE_FORMAT); 
            fprintf(fptr,"%dx%d+%d+%d %d\n",notes[index].width,
              notes[index].height, notes[index].x, notes[index].y,
              notes[index].hidden);
            fprintf(fptr,"%s\n", notes[index].title);

            len = GTK_TEXT(notes[index].text)->text_end - 
              GTK_TEXT(notes[index].text)->gap_size;
            /* text length */
            if (len > 0)
              {
              char *ptr;
 
              /* why do we need "len+1"?  it drops the last char if we don't */ 
              ptr = (char *)malloc(len + 2);
              snprintf(ptr, len+1, "%s", GTK_TEXT(notes[index].text)->text);
              fprintf(fptr,"%s", ptr);
              g_debug("  \"%s\"", ptr);
              free(ptr);
              };
            fclose(fptr);

            /* zap the old file, but don't zap current file */
            if (strncmp(fname, notes[index].filename, MAXPATHLEN))
              {
              unlink(notes[index].filename);
              };
            snprintf(notes[index].filename, MAXPATHLEN, "%ld",
              notes[index].timestamp);
            free(fname);
            }
          else
            {
            g_error("GNotes: gnotes_action(): cannot open file %s", fname);
            };
          };
        };
      };
  
    /* LOAD notes */
    if (!strncmp(sdata, GNOTES_LOAD, strlen(GNOTES_LOAD)))
      {
      DIR *dptr;
  
      g_debug("Load Notes");
      /* read all files in $HOME/GNOTES_DIR  - main() should've put us there */
      /* create a new note for each one */
      if ((dptr=opendir(".")) != NULL)
        {
        struct dirent *pdirent;
  
        while ((pdirent=readdir(dptr)) != NULL)
          {
          FILE *fptr;
  
          if ((fptr=fopen(pdirent->d_name, "r")) != NULL)
            {
            gint width;
            gint height;
            gint x;
            gint y;
            gint hidden, index;
            char *string, letter, *title, *format;
            time_t timestamp;

            /* read in file format indicator */
            format = (char *)malloc(TITLE_LEN);
            memset(format, 0, TITLE_LEN);
            index = 0;
            letter = fgetc(fptr);
            while (!feof(fptr) && !ferror(fptr) &&
                   (index < TITLE_LEN) && (letter != '\n'))
              {
              format[index++] = letter;
              letter = fgetc(fptr);
              };

            /* if we have a proper GNOTE file, continue */
            if (!strncmp(GNOTE_FORMAT, format, strlen(GNOTE_FORMAT)))
              {
              if ((timestamp=atol(pdirent->d_name)) == 0)
                {
                timestamp = time(NULL);
                };

              /* read in geometry, etc */
              fscanf(fptr, "%dx%d+%d+%d %d\n", &width, &height, &x, &y,
                &hidden);

              title = (char *)malloc(TITLE_LEN);
              memset(title, 0, TITLE_LEN);
              index = 0;
              letter = fgetc(fptr);
              while (!feof(fptr) && !ferror(fptr) &&
                     (index < TITLE_LEN) && (letter != '\n'))
                {
                title[index++] = letter;
                letter = fgetc(fptr);
                };

              string = (char *)malloc(2048 + 1);
              memset(string, 0, 2048 + 1);
              index = 0;
              letter = fgetc(fptr);
              while (!feof(fptr) && !ferror(fptr) && (strlen(string) < 2048))
                {
                string[index++] = letter;
                letter = fgetc(fptr);
                };

              gnote_new(width, height, x, y, (gboolean)hidden, string,
                timestamp, title);

              free(title);
              free(string);
              };
            free(format);
            }
          else
            {
            g_error("GNotes: gnotes_action(): cannot open file %s",
              pdirent->d_name);
            };
          };
        closedir(dptr);
        }
      else
        {
        g_error("GNotes: gnotes_action(): cannot open directory %s",
          GNOTES_DIR);
        };
      };
    free(sdata);
    }; 

