
/* spoonman@unforgettable.com */

#ifndef _GNOTE_H_
#define _GNOTE_H_

#define DEBUG (1)

#ifdef DEBUG
  #define g_debug(format, args...) \
    g_log(G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "GNotes: "format, ##args)
#else
  #define g_debug(format, args...) 
#endif

#define g_critical(format, args...) \
  g_log(G_LOG_DOMAIN, G_LOG_LEVEL_CRITICAL, "GNotes: "format, ##args)

#define g_info(format, args...) \
  g_log(G_LOG_DOMAIN, G_LOG_LEVEL_INFO, "GNotes: "format, ##args)


#include <time.h>
#include <gnome.h>
#include <applet-widget.h>
#include "config.h"

/* various actions */
#define GNOTES_SAVE    "Save Notes"
#define GNOTES_LOAD    "Load Notes"
#define GNOTES_RAISE   "Raise Notes"
#define GNOTES_LOWER   "Lower Notes"
#define GNOTES_HIDE    "Hide Notes"
#define GNOTES_SHOW    "Show Notes"
#define GNOTE_RESIZE   "Resize Note"
#define GNOTE_HIDE     "Hide Note"
#define GNOTE_DELETE   "Delete Note"
#define GNOTE_NEW_1x1  "1x1 Note"
#define GNOTE_NEW_1x2  "1x2 Note"
#define GNOTE_NEW_2x2  "2x2 Note"
#define GNOTE_NEW_2x3  "2x3 Note"
#define GNOTE_NEW_3x3  "3x3 Note"
#define GNOTE_NEW_3x4  "3x4 Note"
#define GNOTE_NEW_4x4  "4x4 Note"
#define GNOTE_NEW_4x5  "4x5 Note"

#define TITLE_LEN (20)

#define GNOTE_FORMAT "#GNOTE-1"

#define GNOTES_DIR    ".gnome/gnotes"

  struct Gnote
    {
    GtkWidget *window;
    GtkWidget *hbox;
    GtkWidget *handle_box;
    GtkWidget *text;
    char      filename[MAXPATHLEN];
    gint      x;
    gint      y;
    gint      width;
    gint      height;
    gboolean  hidden;
    gboolean  deleted;
    time_t    timestamp;
    char      title[TITLE_LEN];
    };

void gnote_action(GtkWidget *, gpointer);
void gnote_menu(GtkWidget *, GdkEventButton *);
gint gnote_handle_button_cb(GtkWidget *, GdkEventButton *, gpointer);
void gnote_new(gint, gint, gint, gint, gint, gchar *, time_t, gchar *);
void gnote_new_cb(AppletWidget *, gpointer);
void gnotes_action(AppletWidget *, gpointer);
gint gnote_delete_cb(GtkWidget *, gpointer);
void gnote_signal_handler(int);
gint gnote_motion_cb(GtkWidget *, GdkEventButton *event, gpointer);
gint gnote_handle_button_cb(GtkWidget *, GdkEventButton *event, gpointer);

#endif /* _GNOTE_H_ */

