#ifndef LIBTRICKS_H
#define LIBTRICKS_H

/* the wrapper functions like to stat() etc themselves too.
   but for example if a fakeroot function wants to stat() a
   file, it doesn't want send_get_stat() to be called, likewise
   for the vpath wrap code. So, the first argument to the
   wrapped_* functions is an extra int opts, that is a bitmap of
   what wrapping not to perform:
*/
   
#define DONTVPATH 1
#define DONTFAKE  2

#ifdef __GNUC__
#  define UNUSED __attribute__((unused))
#else 
#  define UNUSED 
#endif

#ifdef _STAT_VER
#define ARG_IFSTATVER(a) a,
#else
#define ARG_IFSTATVER(a)
#endif


/* declare this function for vpath_getcwd */
extern int wrapped_lxstat(int opts, ARG_IFSTATVER(int ver)
			  const char *file_name, 
			  struct stat *st, int *vpath_errro);

#endif
