/* @(#)repair.c	1.5 98/07/17 Copyright 1988 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)repair.c	1.5 98/07/17 Copyright 1988 J. Schilling";
#endif
/*
 *	Repair SCSI disks
 *
 *	Copyright (c) 1988 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <unixstd.h>
#include <standard.h>
#include <signal.h>
#include <sigdefs.h>

#include "scgio.h"

#include "scsireg.h"
#include "scsidefs.h"
#include "scsitransp.h"
#include "scsicmds.h"
#include "fmt.h"

#define	min(a,b)	((a) < (b) ? (a) : (b))
#define	max(a,b)	((a) > (b) ? (a) : (b))

extern	char	*Sbuf;
extern	long	Sbufsize;
extern	int	silent;
extern	int	ask;
extern	int	ign_not_found;

extern	struct scg_cmd	scmd;

extern	struct scsi_capacity	cap;

LOCAL	int	soft_errs;

extern	int	autoformat;
extern	int	veri;
extern	int	wrveri;
extern	int	format_done;

extern	int	refresh_only;
extern	int	n_test_patterns;
#define	NWVERI	n_test_patterns
extern	int	Nveri;
extern	int	Cveri;
extern	int	CWveri;
extern	long	MAXbad;

EXPORT	int	verify_and_repair_disk	__PR((struct disk *dp));
EXPORT	void	verify_disk		__PR((struct disk *dp, int pass, long first, long last, long maxbad));
LOCAL	int	wr_verify		__PR((struct disk *dp, long start, int count, long *bad_block, int (*wv_func) (caddr_t, long, int, long *)));


LOCAL	int	read_old_data		__PR((long n));
LOCAL	int	refresh_block		__PR((long n));
LOCAL	void	reassign_bad_block	__PR((long n, int status));
LOCAL	int	check_stable		__PR((long n));
EXPORT	void	ext_reassign_block	__PR((long n));

LOCAL	void	fill_buf		__PR((int n));
LOCAL	void	refill_buf		__PR((void));

#define	MAXVERI	100
int	vlist[MAXVERI];

EXPORT int
verify_and_repair_disk(dp)
	struct disk	*dp;
{
	int	ret = 0;
	int	i;
	int	total;
	int	oldi;
	int	odef;
	int	ndef;

	clear_bad();
	odef = 0;

	if (Nveri < 0) {
		Nveri = wrveri ? NWVERI : NVERI;
		if (wrveri)
			Nveri *= 2;
	}
	if (dp->veri_time > 0)
		printf("Estimated time: %ld minutes\n",
				(Nveri * dp->veri_time + 30)/60);
	prdate();
	getstarttime();

	soft_errs = 0;
	ndef = 0;
	oldi = 0;
	total = 0;
veri:
	for (i=0; i < Nveri;) {
		if (i > oldi)
			oldi = i;
		printf("Number of faultless passes: %d (up to now max: %d)\n",
					i, oldi);
		if (!silent) {
		int j;for(j=0; j < 10;j++)printf("%d: %d  ", j, vlist[j]);
		printf("\n");
		}
#ifdef	__old__
		verify_disk(dp, i, 0L, -1L, 32L);	/* XXX Test fuer Sony SMO */
		verify_disk(dp, i, 0L, -1L, 127L);	/* dies ist das absolute Maximum */
#endif
		verify_disk(dp, i, 0L, -1L, (MAXbad <= 0L) ? 32L : MAXbad);
		ndef += print_bad();

		if (!ccs(dev)) {
			int	r;

			r = bad_to_def();
			if (r <= 0)
				clear_bad();
			if (odef + r < ndef)
				ndef = odef + r;
		}
		i++;
		if (ndef > odef)
			break;
	}
	if (i < MAXVERI)
		vlist[i]++;
	total += i;

	printf("Total of %2d defects.\n", ndef);
	printf("Total of %2d soft errors.\n", soft_errs);
	printf("Total of %2d verify loops done.\n", total);
	if (ndef > odef)
		odef = ndef;
	else if (i == Nveri)
		goto done;

	if (!ccs(dev)) {
		clear_bad();
		if (acb_format_disk(dp, TRUE) >= 0) {
			goto veri;
		}
	} else {
		reassign_bad();
		clear_bad();
		if ((!autoformat || ndef <= 10) && reformat_disk(dp)) {
			goto veri;
		}
	}

done:
	if (ndef > 10) {
		if (autoformat) {
			error("A C H T U N G\n");
			error("Diese Platte ist nicht brauchbar\n");
			error("Bitte Entwicklung benachrichtigen\n");
		} else {
			error("Excessive bad blocks on disk.\n");
		}
		ret = 1;
	}
	if (soft_errs > total) {
		if (autoformat) {
			error("A C H T U N G\n");
			error("Diese Platte hat zu viele soft errors\n");
			error("Bitte Entwicklung benachrichtigen\n");
		} else {
			error("Excessive soft errors on disk.\n");
		}
		ret = 1;
	}
	return (ret);
}

EXPORT void
verify_disk(dp, pass, first, last, maxbad)
	struct disk	*dp;
	int	pass;
	long	first;
	long	last;
	long	maxbad;
{
	long	bad_block;
	long	bb2;
	long	start = first;
	long	end;
	int	count;
	long	maxcount;
	int	i;
	long	bads = 0L;
	int	ret;
	BOOL	do_wrveri;
	int	(*wv_func) __PR((caddr_t, long, int, long *));
static	BOOL	force_wrveri = FALSE;
	
	if (Cveri < 0)
		Cveri = CVERI;
	if (CWveri < 0)
		CWveri = CWVERI;
	maxcount = Cveri;

	if (wrveri && !format_done && !force_wrveri) {
		printf("WARNING: Disk has not been formatted.\n");
		printf("WARNING: Write/verify will destroy disk data.\n");
		force_wrveri = yes("Do you want to force write/verify? ");
		if (force_wrveri) {
			read_sinfo(dp, FALSE);
			if (dp->formatted < 0) {
				testformat(dp);
				read_primary_label(dp);
			}
		}
	}

	if (force_wrveri)
		do_wrveri = (pass & 1) == 0;
	else
		do_wrveri = wrveri && format_done && (pass & 1);

	if (veri) {
		prdate();
		getstarttime();
	}
	if (read_capacity() < 0) {
		error("Cannot read Capacity\n");
		return;
	}
	end = cap.c_baddr;
	if (last > 0 && last < end)
		end = last;
	if (start > end)
		start = first = 0L;
	if (do_wrveri) {
		maxcount = Sbufsize/cap.c_bsize;
		if (maxcount > CWveri)
			maxcount = CWveri;
		maxcount /= 10;
		maxcount *= 10;
		fill_buf(pass>>1);
		printf("Verify pass %d Test Pattern: %lX\n",
							pass, *(long *)Sbuf);
		if(dp->split_wv_cmd > 0)
			wv_func = write_verify_split;
		else
			wv_func = write_verify;

	} else {
/*		printf("no write\n");*/
/*		printf("\n");*/
		wv_func = write_verify;	/* Tell lint: it's initialized */
	}

/*	for(start = 0; start < end;) {*/
	while(start <= end) {
		printf("\r%ld", start); flush();
		if (dev==DEV_ACB40X0 ||
		    dev==DEV_ACB4000 || dev==DEV_ACB4010 || dev==DEV_ACB4070)
		xdelay();/*usleep(10000);*/		/* allow other procs*/
							/* to run if disre  */
							/* not enabled	    */

		count = maxcount;
		count -= start % maxcount;
		count = min(count, end - start + 1);
		if (do_wrveri)
			ret = wr_verify(dp, start, count, &bad_block, wv_func);
		else
			ret = verify(start, count, &bad_block);
		if (ret < 0) {
			if (scmd.error <= SCG_RETRYABLE) {
/*				error("\rBad Block # %d found at: %d\n", bads+1, bad_block);*/
				printf("\rBad Block # %ld found at: %ld\n", bads+1, bad_block);
				if (!scmd.sense.adr_val) {
/*					error("Not valid!!! start: %ld\n",*/
					printf("Not valid!!! start: %ld\n",
									start);
					/* Wer weis, was da fuer Schrott
					 * kommt ??? vielleicht 0 !
					 * Darum sicher ist sicher !!
					 */
					start++;
					continue;
				}
				if ((ign_not_found&scsi_sense_code()) == 0x14){
/*					error("Record not found: %ld\n",*/
					printf("Record not found: %ld\n",
							bad_block);
					if (bad_block < start)
						start++;
					else
						start = bad_block + 1;
					continue;
				}
				/* Wait for settle down */
				usleep(200000);
				silent++;
				for (i=0; i < 16; i++)
					if (verify(bad_block, 1, &bb2) < 0)
						break;
				silent--;
				/*error("i : %d\n", i);*/
				if (i < 16) {
					insert_bad(bad_block);
#ifdef	OLD
/*XXX*/					if (maxbad > 0 && ++bads >= maxbad)
#else
					bads++;
/*XXX*/					if (maxbad > 0 && bads >= maxbad)
#endif
						return;
				} else {
/*					error("SOFT ERROR !!!! at: %ld\n",*/
					printf("SOFT ERROR !!!! at: %ld\n",
								bad_block);
					soft_errs++;
				}
				if (bad_block < start)
					start++;
				else
					start = bad_block + 1;
				continue;
			}
			scsiprinterr("verify");
			return;
		}
		start += count;
	}
	printf("\r%ld\nVerify done.\n", start);
	if (veri) {
		int	nsec;

		nsec = prstats();
		printf("Verify speed: %.1f kB/sec\n",
			((start - first)/(1024.0/cap.c_bsize)) / nsec);
	}
}


/*---------------------------------------------------------------------------
|
|	Darf nur aufgerufen werden, wenn die Platte formatiert ist, sonst
|	sind eventuell das Label sowie sinfo nicht initialisiert,
|	sowie wie moeglicherweise wichtige Daten auf der Platte.
|
+---------------------------------------------------------------------------*/
LOCAL int
wr_verify(dp, start, count, bad_block, wv_func)
	struct disk	*dp;
	long	start;
	int	count;
	long	*bad_block;
	int	(*wv_func) __PR((caddr_t, long, int, long *));
{
	struct scg_cmd	cmdsave;
	int	ret;
	sigset_t	oldmask;

	block_sigs(oldmask);
	ret = (*wv_func)((caddr_t)Sbuf, start, count, bad_block);
	if (start == 0 || (start + count) >= cap.c_baddr) {
		movebytes((caddr_t)&scmd, (caddr_t)&cmdsave, sizeof(scmd));
		silent++;
		write_sinfo(dp);
		label_disk(dp);
		convert_def_blk();
		write_def_blk(FALSE);
		silent--;
		movebytes((caddr_t)&cmdsave, (caddr_t)&scmd, sizeof(scmd));
		refill_buf();	/* Solange 'Sbuf' vielfach benutzt wird */
	}
	restore_sigs(oldmask);
	return (ret);
}

#define	RECOVERED	0x01
#define	READ_OK		0x02
#define	REFRESHED	0x04
#define	UNSTABLE	0x08

LOCAL int
read_old_data(n)
	long	n;
{
	int	ret = 0;
	int	i;
	
	for (i = 0; i < 100; i++) {
		if (read_scsi(Sbuf, n, 1) >= 0 && scmd.resid == 0) {
			ret |= READ_OK;
			break;
		} else {
			if (scsi_sense_key() == SC_RECOVERABLE_ERROR &&
							scmd.resid == 0) {
				ret |= RECOVERED;
				break;
			}
		}
	}
	if (i < 100) {
		printf("successful%s (%d).\n", (ret & RECOVERED) ?
			" recovered" : "", i);
		if (ret & RECOVERED) {
			printf("\n");
			scsiprinterr("read_scsi");
			printf("\n");
		}
	} else {
		printf("\nCannot read data from block %ld.\n\n", n);
		scsiprinterr("read_scsi");
		printf("\n");
	}
	return(ret);
}

LOCAL int
refresh_block(n)
	long	n;
{
	if (ask && !yes("Refresh block %d ? ", n))
		return(0);

	if (write_scsi(Sbuf, n, 1) >= 0 && scmd.resid == 0) {
		return(REFRESHED);
	} else {
		printf("Cannot refresh block %ld.\n\n", n);
		scsiprinterr("write_scsi");
		printf("\n");
	}
	return(0);
}

LOCAL void
reassign_bad_block(n, status)
	long	n;
	int	status;
{
	struct scsi_def_list d;
	sigset_t	oldmask;

	block_sigs(oldmask);

	i_to_long(d.def_list.list_block[0], n);

	if (reassign_block(&d, 1) < 0) {
		printf("Cannot reassign block %ld\n\n", n);
		scsiprinterr("reassign block");
		printf("\n");
	} else {
		if (!(status & (READ_OK|RECOVERED)))
			fillbytes((caddr_t) Sbuf, (int)(2 * cap.c_bsize), '\0');

		if (write_scsi(Sbuf, n, 1) < 0 || scmd.resid != 0) {
			printf("Alternate sector (%ld) not usable.\n\n", n);
			scsiprinterr("write_scsi");
			goto out;
		}
		printf("Block is reassigned %s",
			(status & (READ_OK|RECOVERED)) ?
			"and old data is written on alternate sector.\n" :
			"and old data is lost.\n");

		printf("Verifying data... ");
		flush();
		if (read_scsi(Sbuf + MAX_SECSIZE, n, 1) < 0 || scmd.resid != 0){
			printf("Alternate sector (%ld) not usable.\n\n", n);
			scsiprinterr("read_scsi");
			goto out;
		}
		if (cmpbytes(Sbuf, Sbuf + MAX_SECSIZE, cap.c_bsize) <
								cap.c_bsize)
			printf("could not read back same data from disk\n");
		else {
			printf("OK\n");
			restore_sigs(oldmask);

			(void) check_stable(n);
		}
	}
out:
	restore_sigs(oldmask);
}

LOCAL int
check_stable(n)
	long	n;
{
	int	i;
	long	altaddr;
	long	dummy;

#define	UNSTABLE	0x08
	
	altaddr = (n - 1000L) > 0L ? n - 1000L : n + 1000L;

	for (i = 0; i < 1000; i++) {
		if (verify(n, 1, &dummy) < 0) {
			printf("Block is unstable (%d).\n\n",i);
			scsiprinterr("verify");
			printf("\n");
			return(UNSTABLE);
		}
		if (i % 200 == 0)
			read_scsi(&((char *)Sbuf)[MAX_SECSIZE], altaddr, 1);
	}
	return(0);
}

EXPORT void
ext_reassign_block(n)
	long	n;
{
	int             status = 0;

	silent++;
	printf("Trying to read old data... ");
	flush();
	status |= read_old_data(n);
	printf("Trying to refresh block...\n");
	status |= refresh_block(n);
	if (status & REFRESHED) {
		printf("Block %ld is refreshed %s\n", n,
			((status & READ_OK) || (status & RECOVERED)) ?
			"and old data is written on it." :
			"and old data is lost.");
		status |= check_stable(n);
		if (!(status & UNSTABLE) &&
				(refresh_only ||
				!yes("Do you still want to reassign block? "))){
			silent--;
			return;
		}
	}
	if (refresh_only) {
		printf("Block %ld is %s, but will not be reassigned!\n", n,
				(status&UNSTABLE)?"unstable":"defect");
		silent--;
		return;
	}
	if (ask && !yes("Reassign block %ld ? ", n)) {
		silent--;
		return;
	}
	reassign_bad_block(n, status);
	silent--;
}

unsigned long	test_patterns[] = {
	0xc6dec6de,
	0x6db6db6d,
	0x00000000,
	0xffffffff,
	0xaaaaaaaa,
	0x55555555,
	0x4A536368,
};
int	n_test_patterns = sizeof(test_patterns)/sizeof(test_patterns[0]);
int	last_pattern = 0;	/* Solange 'Sbuf' vielfach benutzt wird */

LOCAL void
fill_buf(n)
	int	n;
{
	register int i = Sbufsize/sizeof(unsigned long);
	register unsigned long pattern = test_patterns[n%n_test_patterns];
	register unsigned long *lp = (unsigned long *)Sbuf;

	last_pattern = n;	/* Solange 'Sbuf' vielfach benutzt wird */

	while (--i >= 0)
		*lp++ = pattern;
}

/* Solange 'Sbuf' vielfach benutzt wird */
LOCAL void
refill_buf()
{
	fill_buf(last_pattern);
}
