#ifndef ___ARENA_UTIL_H___
#  define ___ARENA_UTIL_H___

#include "arena.h"
#include "types.h"


#ifdef ARENA_USE_RAW_PAINTSTREAM_HANDLING

#define GetShort(p)      (*((short*)p)++)
#define GetInt(p)        (*((int*)p)++)
#define GetLong(p)       (*((long*)p)++)
#define GetPixmap(p)     ((Pixmap)(*((long*)p)++))
#define GetPointer(p)    ((void*)(*((long*)p)++))

#define SkipShort(p)     (((short*)p)++)
#define SkipInt(p)       (((int*)p)++)
#define SkipLong(p)      (((long*)p)++)
#define SkipPixmap(p)    (((long*)p)++)
#define SkipPointer(p)   (((long*)p)++)

#define PutShort(p, s)   (*((short*)p)++ = s)
#define PutInt(p, i)     (*((int*)p)++ = i)
#define PutLong(p, l)    (*((long*)p)++ = l)
#define PutPixmap(p, P)  (*((long*)p)++ = (long)P)
#define PutPointer(p, v) ((void*)(*((long*)p)++) = v)

# else

extern unsigned short _Arena_GetShort  (unsigned char **);
extern unsigned int   _Arena_GetInt    (unsigned char **);
extern unsigned long  _Arena_GetLong   (unsigned char **);
extern void*          _Arena_GetPointer(unsigned char **);

extern void _Arena_PutShort  (unsigned char **, unsigned short);
extern void _Arena_PutInt    (unsigned char **, unsigned   int);
extern void _Arena_PutLong   (unsigned char **, unsigned  long);
extern void _Arena_PutPointer(unsigned char **,          void*);

#define GetShort(p)      _Arena_GetShort(&p)
#define GetInt(p)        _Arena_GetInt(&p)
#define GetLong(p)       _Arena_GetLong(&p)
#define GetPixmap(p)     (Pixmap)_Arena_GetLong(&p)
#define GetPointer(p)    _Arena_GetPointer(&p)

#define SkipShort(p)     _Arena_GetShort(&p)
#define SkipInt(p)       _Arena_GetInt(&p)
#define SkipLong(p)      _Arena_GetLong(&p)
#define SkipPixmap(p)    _Arena_GetLong(&p)
#define SkipPointer(p)   _Arena_GetPointer(&p)

#define PutShort(p, s)   _Arena_PutShort(&p,   ((unsigned short)(s)))
#define PutInt(p, i)     _Arena_PutInt(&p,     ((unsigned   int)(i)))
#define PutLong(p, l)    _Arena_PutLong(&p,    ((unsigned  long)(l)))
#define PutPixmap(p, P)  _Arena_PutLong(&p,    ((long)(P)))
#define PutPointer(p, v) _Arena_PutPointer(&p, ((void*)(v)))

#endif

extern void* Arena_MAlloc(size_t buffer_size,
			  Bool exit_Arena_on_fail);
extern void* Arena_CAlloc(size_t members_number, size_t member_size,
			  Bool exit_Arena_on_fail);

extern size_t Arena_StrLen (const char* theString);

#ifndef HAVE_STRDUP
char *strdup(char* s);
#endif /* HAVE_STRDUP */

#ifndef HAVE_STRNDUP
char *strndup(char* s, int n);
#endif /* HAVE_STRNDUP */

char* unquote(char* s);

char* chop_str(char* p);
char* str_tok(char* a, char* b, char** c);

Byte hex2byte(char hexHigh, char hexLow);

Bool isrgb(const char* s, long* rgb);

#ifndef HAVE_ISXDIGIT
Bool isxdigit(char c);
#endif

int ColumnNumber_in_String(char* s, int slen, int pos);
int   LineNumber_in_String(char* s, int slen, int pos);

char* GetArenaUser(void);
char* ALibHomePath(void);
Bool ALibCreatePath(const char* path, mode_t protect);

#endif	/* ifndef ___ARENA_UTIL_H___ */
