/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.JDAPControl;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
extends Thread {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private transient int m_highMsgId = 0;
    private transient InputStream m_serverInput;
    private transient OutputStream m_serverOutput;
    private transient Hashtable m_requests = new Hashtable();
    private transient Hashtable m_messages;
    private transient Vector m_registered = new Vector();
    private transient boolean m_disconnected = false;
    private transient LDAPCache m_cache;
    private transient boolean m_failed = false;
    private transient Socket m_socket;

    public LDAPConnThread(String host, int port, LDAPSocketFactory factory, LDAPCache cache) throws LDAPException {
        this.m_cache = cache;
        if (this.m_cache != null) {
            this.m_messages = new Hashtable();
        }
        try {
            this.m_socket = factory == null ? new Socket(host, port) : factory.makeSocket(host, port);
            this.m_serverInput = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_failed = true;
            this.start();
            throw new LDAPException("failed to connect to server " + host, 91);
        }
        this.start();
    }

    synchronized void sendRequest(JDAPProtocolOp request, LDAPResponseListener toNotify, LDAPSearchConstraints cons) throws LDAPException {
        JDAPMessage msg;
        if (this.m_serverOutput == null) {
            throw new LDAPException("not connected to a server", 80);
        }
        LDAPControl[] lc = cons.getServerControls();
        if (lc != null && lc.length > 0) {
            JDAPControl[] jc = new JDAPControl[lc.length];
            int i = 0;
            while (i < lc.length) {
                jc[i] = new JDAPControl(lc[i].getID(), lc[i].isCritical(), lc[i].getValue());
                ++i;
            }
            msg = new JDAPMessage(this.allocateId(), request, jc);
        } else {
            msg = new JDAPMessage(this.allocateId(), request);
        }
        if (toNotify != null) {
            if (!(request instanceof JDAPAbandonRequest) && !(request instanceof JDAPUnbindRequest)) {
                this.m_requests.put(new Integer(msg.getId()), toNotify);
            }
            toNotify.setID(msg.getId());
        }
        try {
            msg.write(this.m_serverOutput);
            this.m_serverOutput.flush();
            return;
        }
        catch (IOException iOException) {
            throw new LDAPException("error writing request", 80);
        }
    }

    public synchronized void register(LDAPConnection conn) {
        if (!this.m_registered.contains(conn)) {
            this.m_registered.addElement(conn);
        }
    }

    synchronized int getClientCount() {
        return this.m_registered.size();
    }

    public synchronized void deregister(LDAPConnection conn) {
        this.m_registered.removeElement(conn);
        if (this.m_registered.size() == 0) {
            try {
                LDAPSearchConstraints cons = conn.getSearchConstraints();
                this.sendRequest(new JDAPUnbindRequest(), null, cons);
                this.cleanUp();
                this.stop();
                Thread.sleep(100L);
                return;
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
                return;
            }
        }
    }

    private void cleanUp() {
        Object var2_1;
        try {
            try {
                this.m_serverOutput.close();
            }
            catch (Exception exception) {
            }
            var2_1 = null;
            this.m_serverOutput = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.m_serverOutput = null;
            throw throwable;
        }
        try {
            try {
                this.m_serverInput.close();
            }
            catch (Exception exception) {
            }
            var2_1 = null;
            this.m_serverInput = null;
        }
        catch (Throwable throwable) {
            var2_1 = null;
            this.m_serverInput = null;
            throw throwable;
        }
        try {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
            }
            var2_1 = null;
            this.m_socket = null;
            return;
        }
        catch (Throwable throwable) {
            var2_1 = null;
            this.m_socket = null;
            throw throwable;
        }
    }

    public void run() {
        if (this.m_failed) {
            this.stop();
        }
        JDAPMessage msg = null;
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        do {
            Thread.yield();
            int[] nread = new int[]{0};
            try {
                BERElement element = BERElement.getElement(decoder, this.m_serverInput, nread);
                msg = new JDAPMessage(element);
                this.processResponse(msg, nread[0]);
            }
            catch (Exception e) {
                this.networkError(e);
            }
        } while (!this.m_disconnected);
    }

    private synchronized int allocateId() {
        this.m_highMsgId = (this.m_highMsgId + 1) % Integer.MAX_VALUE;
        return this.m_highMsgId;
    }

    private void processResponse(JDAPMessage incoming, int size) {
        Integer messageID = new Integer(incoming.getId());
        LDAPResponseListener l = (LDAPResponseListener)this.m_requests.get(messageID);
        if (l == null) {
            return;
        }
        LDAPControl[] con = this.checkControls(incoming);
        l.getConnection().setResponseControls(l.getThread(), con);
        JDAPProtocolOp op = incoming.getProtocolOp();
        Vector<LDAPEntry> v = null;
        if (op instanceof JDAPSearchResponse || op instanceof JDAPSearchResultReference) {
            ((LDAPSearchListener)l).addSearchResult(incoming);
            Long key = ((LDAPSearchListener)l).getKey();
            if (this.m_cache != null && key != null) {
                v = (Vector<LDAPEntry>)this.m_messages.get(messageID);
                if (v == null) {
                    v = new Vector<LDAPEntry>();
                    v.addElement((LDAPEntry)((Object)new Long(0L)));
                }
                long entrySize = (Long)v.firstElement() + (long)size;
                v.setElementAt((LDAPEntry)((Object)new Long(entrySize)), 0);
                v.addElement(this.constructLDAPEntry(incoming));
                this.m_messages.put(messageID, v);
                return;
            }
        } else {
            Long key;
            l.setResponse(incoming);
            if (l instanceof LDAPSearchListener && (key = ((LDAPSearchListener)l).getKey()) != null) {
                JDAPResult res;
                boolean fail = false;
                JDAPProtocolOp protocolOp = incoming.getProtocolOp();
                if (protocolOp instanceof JDAPSearchResult && (res = (JDAPResult)((Object)protocolOp)).getResultCode() > 0) {
                    fail = true;
                }
                if (!fail && this.m_cache != null) {
                    v = (Vector<LDAPEntry>)this.m_messages.remove(messageID);
                    if (v == null) {
                        v = new Vector<LDAPEntry>();
                        v.addElement((LDAPEntry)((Object)new Long(0L)));
                    }
                    try {
                        this.m_cache.addEntry(key, v);
                    }
                    catch (LDAPException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                }
            }
            this.m_requests.remove(messageID);
        }
    }

    private LDAPEntry constructLDAPEntry(JDAPMessage msg) {
        JDAPProtocolOp op = msg.getProtocolOp();
        JDAPSearchResponse sr = (JDAPSearchResponse)op;
        LDAPAttribute[] lattrs = sr.getAttributes();
        LDAPAttributeSet attrs = lattrs != null ? new LDAPAttributeSet(lattrs) : new LDAPAttributeSet();
        String dn = sr.getObjectName();
        return new LDAPEntry(dn, attrs);
    }

    private LDAPControl[] checkControls(JDAPMessage response) {
        JDAPControl[] jc;
        LDAPControl[] con = null;
        if (response != null && (jc = response.getControls()) != null && jc.length > 0) {
            con = new LDAPControl[jc.length];
            int i = 0;
            while (i < jc.length) {
                con[i] = new LDAPControl(jc[i].getID(), jc[i].isCritical(), jc[i].getValue());
                ++i;
            }
        }
        return con;
    }

    void abandon(int id) {
        this.m_requests.remove(new Integer(id));
    }

    private synchronized void networkError(Exception e) {
        try {
            Enumeration requests = this.m_requests.elements();
            while (requests.hasMoreElements()) {
                LDAPResponseListener listener = (LDAPResponseListener)requests.nextElement();
                listener.setException(new LDAPException("Server down", 80));
            }
            this.m_requests.clear();
            this.cleanUp();
        }
        catch (NullPointerException ee) {
            System.err.println("Exception: " + ee.toString());
        }
        this.m_disconnected = true;
        Vector registerCopy = (Vector)this.m_registered.clone();
        Enumeration cancelled = registerCopy.elements();
        while (cancelled.hasMoreElements()) {
            LDAPConnection c = (LDAPConnection)cancelled.nextElement();
            c.deregisterConnection();
        }
    }
}

