/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPEntryChangeControl;

public class LDAPPersistSearchControl
extends LDAPControl {
    private int m_changeTypes = 1;
    private boolean m_changesOnly = false;
    private boolean m_returnECs = false;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 4;
    public static final int MODDN = 8;

    public LDAPPersistSearchControl() {
        super("2.16.840.1.113730.3.4.3", true, null);
    }

    public LDAPPersistSearchControl(int changeTypes, boolean changesOnly, boolean returnControls, boolean isCritical) {
        super("2.16.840.1.113730.3.4.3", isCritical, null);
        this.m_value = this.createPersistSearchSpecification(changeTypes, changesOnly, returnControls);
    }

    public int getChangeTypes() {
        return this.m_changeTypes;
    }

    public boolean getChangesOnly() {
        return this.m_changesOnly;
    }

    public boolean getReturnControls() {
        return this.m_returnECs;
    }

    public void setChangeTypes(int types) {
        this.m_changeTypes = types;
    }

    public void setChangesOnly(boolean changesOnly) {
        this.m_changesOnly = changesOnly;
    }

    public void setReturnControls(boolean returnControls) {
        this.m_returnECs = returnControls;
    }

    public LDAPEntryChangeControl parseResponse(byte[] c) {
        LDAPEntryChangeControl con = new LDAPEntryChangeControl();
        ByteArrayInputStream inStream = new ByteArrayInputStream(c);
        new BERSequence();
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] numRead = new int[]{0};
        try {
            BERInteger num;
            BERSequence s = (BERSequence)BERElement.getElement(decoder, inStream, numRead);
            BEREnumerated bEREnumerated = (BEREnumerated)s.elementAt(0);
            con.setChangeType(bEREnumerated.getValue());
            if (s.size() > 1) {
                if (s.elementAt(1) instanceof BEROctetString) {
                    BEROctetString str = (BEROctetString)s.elementAt(1);
                    con.setPreviousDN(new String(str.getValue(), "UTF8"));
                } else if (s.elementAt(1) instanceof BERInteger) {
                    num = (BERInteger)s.elementAt(1);
                    con.setChangeNumber(num.getValue());
                }
            }
            if (s.size() > 2) {
                num = (BERInteger)s.elementAt(2);
                con.setChangeNumber(num.getValue());
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return con;
    }

    public static LDAPEntryChangeControl parseResponse(LDAPControl[] controls) {
        LDAPPersistSearchControl con = new LDAPPersistSearchControl();
        int i = 0;
        while (controls != null && i < controls.length) {
            if (controls[i].getID().equals("2.16.840.1.113730.3.4.7")) {
                return con.parseResponse(controls[i].getValue());
            }
            ++i;
        }
        return null;
    }

    private byte[] createPersistSearchSpecification(int changeTypes, boolean changesOnly, boolean returnECs) {
        BERSequence seq = new BERSequence();
        seq.addElement(new BERInteger(changeTypes));
        seq.addElement(new BERBoolean(changesOnly));
        seq.addElement(new BERBoolean(returnECs));
        return this.flattenBER(seq);
    }
}

