/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.application.AWTCompatibility;
import netscape.application.FastStringBuffer;
import netscape.application.FoundationApplet;
import netscape.application.HTMLElement;
import netscape.application.HTMLParsingException;
import netscape.application.HTMLParsingRules;
import netscape.application.HTMLTokenGenerator;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class HTMLParser
extends FilterInputStream {
    private static final String[] specialChars = new String[]{"lt", "<", "gt", ">", "amp", "&", "quot", "\"", "nbsp", "\u00a0", "iexcl", "\u00a1", "cent", "\u00a2", "pound", "\u00a3", "curren", "\u00a4", "yen", "\u00a5", "brvbar", "\u00a6", "sect", "\u00a7", "uml", "\u00a8", "copy", "\u00a9", "ordf", "\u00aa", "laquo", "\u00ab", "not", "\u00ac", "shy", "\u00ad", "reg", "\u00ae", "macr", "\u00af", "deg", "\u00b0", "plusmn", "\u00b1", "sup2", "\u00b2", "sup3", "\u00b3", "acute", "\u00b4", "micro", "\u00b5", "para", "\u00b6", "middot", "\u00b7", "cedil", "\u00b8", "sup1", "\u00b9", "ordm", "\u00ba", "raquo", "\u00bb", "frac14", "\u00bc", "frac12", "\u00bd", "frac34", "\u00be", "iquest", "\u00bf", "Agrave", "\u00c0", "Aacute", "\u00c1", "Acirc", "\u00c2", "Atilde", "\u00c3", "Auml", "\u00c4", "Aring", "\u00c5", "AElig", "\u00c6", "Ccedil", "\u00c7", "Egrave", "\u00c8", "Eacute", "\u00c9", "Ecirc", "\u00ca", "Euml", "\u00cb", "Igrave", "\u00cc", "Iacute", "\u00cd", "Icirc", "\u00ce", "Iuml", "\u00cf", "ETH", "\u00d0", "Ntilde", "\u00d1", "Ograve", "\u00d2", "Oacute", "\u00d3", "Ocirc", "\u00d4", "Otilde", "\u00d5", "Ouml", "\u00d6", "times", "\u00d7", "Oslash", "\u00d8", "Ugrave", "\u00d9", "Uacute", "\u00da", "Ucirc", "\u00db", "Uuml", "\u00dc", "Yacute", "\u00dd", "THORN", "\u00de", "szlig", "\u00df", "agrave", "\u00e0", "aacute", "\u00e1", "acirc", "\u00e2", "atilde", "\u00e3", "auml", "\u00e4", "aring", "\u00e5", "aelig", "\u00e6", "ccedil", "\u00e7", "egrave", "\u00e8", "eacute", "\u00e9", "ecirc", "\u00ea", "euml", "\u00eb", "igrave", "\u00ec", "iacute", "\u00ed", "icirc", "\u00ee", "iuml", "\u00ef", "eth", "\u00f0", "ntilde", "\u00f1", "ograve", "\u00f2", "oacute", "\u00f3", "ocirc", "\u00f4", "otilde", "\u00f5", "ouml", "\u00f6", "divide", "\u00f7", "oslash", "\u00f8", "ugrave", "\u00f9", "uacute", "\u00fa", "ucirc", "\u00fb", "uuml", "\u00fc", "yacute", "\u00fd", "thorn", "\u00fe", "yuml", "\u00ff", "ensp", " ", "emsp", " ", "endash", "-", "emdash", "-"};
    private HTMLTokenGenerator tokenGenerator;
    private HTMLParsingRules rules;
    private Class defaultContainerClass;
    private Class defaultMarkerClass;
    private boolean throwsException = false;
    private boolean appletInitialized = false;
    private FoundationApplet applet;

    public HTMLParser(InputStream in) {
        this(in, new HTMLParsingRules());
    }

    public HTMLParser(InputStream in, HTMLParsingRules rules) {
        super(in);
        this.rules = rules;
        this.tokenGenerator = new HTMLTokenGenerator(in);
    }

    public void setThrowsExceptionOnHTMLError(boolean flag) {
        this.throwsException = flag;
    }

    public boolean throwsExceptionOnHTMLError() {
        return this.throwsException;
    }

    public HTMLElement nextHTMLElement() throws IOException, HTMLParsingException, InstantiationException, IllegalAccessException {
        while (this.tokenGenerator.hasMoreTokens()) {
            HTMLElement result = this.parseNextHTMLElement(true, true, null);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Hashtable hashtableForAttributeString(String attributesString) throws HTMLParsingException {
        result = new Hashtable();
        fb = new FastStringBuffer();
        if (attributesString == null) {
            return result;
        }
        c = attributesString.length();
        i = 0;
        ** GOTO lbl33
        {
            ++i;
            do {
                if (i < c && HTMLParser.isSpace(attributesString.charAt(i))) continue block0;
                if (i == c) break block0;
                fb.truncateToLength(0);
                offset = HTMLParser.parseKeyOrValue(attributesString, i, fb);
                if (offset == 0) {
                    throw new HTMLParsingException("Error while parsing attributes " + attributesString, 0);
                }
                key = HTMLParser.filterKeyOrValue(fb);
                key = key.toUpperCase();
                i += offset;
                if (!key.equals("")) ** GOTO lbl22
                continue;
lbl-1000:
                // 1 sources

                {
                    ++i;
lbl22:
                    // 2 sources

                    ** while (i < c && HTMLParser.isSpace((char)attributesString.charAt((int)i)))
                }
lbl23:
                // 1 sources

                if (i < c && attributesString.charAt(i) == '=') {
                    fb.truncateToLength(0);
                    offset = HTMLParser.parseKeyOrValue(attributesString, ++i, fb);
                    value = HTMLParser.filterKeyOrValue(fb);
                    i += offset;
                    result.put(key, value);
                    continue;
                }
                result.put(key, "");
lbl33:
                // 4 sources

            } while (i < c);
        }
        return result;
    }

    public void reportSyntaxError(String description) throws HTMLParsingException {
        if (this.throwsException) {
            throw new HTMLParsingException(description, this.tokenGenerator.lineForLastToken());
        }
    }

    public void setClassForMarker(Class aClass, String aMarker) {
        this.rules.setClassNameForMarker(aClass.getName(), aMarker);
    }

    private final char unicodeCharForBytes(String bytes) {
        String s = bytes;
        if (s.length() > 0 && s.charAt(0) == '#') {
            return (char)Integer.parseInt(s.substring(1, s.length()));
        }
        int i = 0;
        int c = specialChars.length;
        while (i < c) {
            if (specialChars[i].equals(s)) {
                return specialChars[i + 1].charAt(0);
            }
            i += 2;
        }
        return '\u0000';
    }

    private final int convertSpecialCharacter(String s, int startIndex, FastStringBuffer result) {
        int length = s.length();
        if (startIndex + 1 < length) {
            int start;
            int end = start = startIndex + 1;
            char ch = s.charAt(end);
            while (end < length && ch != ';' && ch != ' ' && ch != '\n' && ch != '\t') {
                ch = ++end < length ? s.charAt(end) : (char)'\u0000';
            }
            if (end > start) {
                String subStr = s.substring(start, start + (end - start));
                char theChar = this.unicodeCharForBytes(subStr);
                if (theChar != '\u0000' && theChar != '\b') {
                    result.append(theChar);
                }
                if (end < length && s.charAt(end) == ';') {
                    return subStr.length() + 2;
                }
                return subStr.length() + 1;
            }
        }
        return 0;
    }

    private final String filterHTMLString(String s, boolean filterSpaces, boolean allowSpaceForFirstChar) {
        FastStringBuffer sb = new FastStringBuffer();
        boolean previousCharWasSpace = false;
        boolean nonSpaceCharFound = false;
        int i = 0;
        int c = s.length();
        while (i < c) {
            char ch = s.charAt(i);
            if (filterSpaces && (ch == ' ' || ch == '\t' || ch == '\n')) {
                if ((nonSpaceCharFound || (!allowSpaceForFirstChar || ch != '\t' && ch != '\n') && (allowSpaceForFirstChar || ch != '\t' && ch != '\n' && ch != ' ')) && !previousCharWasSpace) {
                    previousCharWasSpace = true;
                    sb.append(' ');
                }
            } else if (ch == '&') {
                int delta = this.convertSpecialCharacter(s, i, sb);
                if (delta > 0) {
                    i += delta - 1;
                }
                previousCharWasSpace = false;
                nonSpaceCharFound = true;
            } else if (ch == '\n' || ch == '\t' || ch >= ' ' && ch <= '~') {
                previousCharWasSpace = false;
                nonSpaceCharFound = true;
                sb.append(ch);
            }
            ++i;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private Class classForMarker(String aMarker) {
        String className = this.rules.classNameForMarker(aMarker);
        if (className != null) {
            Class c;
            try {
                if (!this.appletInitialized) {
                    this.applet = (FoundationApplet)AWTCompatibility.awtApplet();
                    this.appletInitialized = true;
                }
                c = this.applet != null ? this.applet.classForName(className) : Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                System.err.println(String.valueOf(e));
                c = null;
            }
            return c;
        }
        return null;
    }

    private final HTMLElement parseNextHTMLElement(boolean doFilterStrings, boolean allowSpaceAsFirstChar, String pMarker) throws IOException, HTMLParsingException, InstantiationException, IllegalAccessException {
        HTMLElement result = null;
        int token = this.tokenGenerator.nextToken();
        switch (token) {
            case 1: {
                Class c = this.classForMarker("IFCSTRING");
                if (c == null) break;
                String s = this.tokenGenerator.stringForLastToken();
                if ((s = this.filterHTMLString(s, doFilterStrings, allowSpaceAsFirstChar)) == null) break;
                result = (HTMLElement)c.newInstance();
                result.setMarker("IFCSTRING");
                result.setString(s);
                return result;
            }
            case 2: {
                String marker = this.tokenGenerator.stringForLastToken();
                Hashtable markerRules = this.rules.rulesForMarker(marker);
                Class c = this.classForMarker(marker);
                if (c == null) break;
                if (this.rules.isContainer(markerRules)) {
                    Vector beginTerminators = null;
                    Vector endTerminators = null;
                    boolean endMarkerFound = false;
                    boolean notFirstChild = false;
                    result = (HTMLElement)c.newInstance();
                    result.setMarker(marker);
                    result.setAttributes(this.tokenGenerator.attributesForLastToken());
                    Object[] children = new Object[2];
                    int childrenCount = 0;
                    if (markerRules != null) {
                        beginTerminators = (Vector)markerRules.get("BeginTermination");
                        endTerminators = (Vector)markerRules.get("EndTermination");
                    }
                    while (this.tokenGenerator.hasMoreTokens()) {
                        token = this.tokenGenerator.peekNextToken();
                        if (token == 3) {
                            String endMarker = this.tokenGenerator.stringForLastToken();
                            if (marker.equals(endMarker)) {
                                this.tokenGenerator.nextToken();
                                endMarkerFound = true;
                                break;
                            }
                            if (endTerminators != null && endTerminators.indexOf(endMarker) != -1) {
                                endMarkerFound = true;
                                break;
                            }
                            if (this.classForMarker(endMarker) != null) {
                                this.reportSyntaxError("Unexcpected closing " + endMarker + " while parsing contents for " + marker);
                                endMarkerFound = true;
                                break;
                            }
                        } else if (token == 2 && beginTerminators != null && beginTerminators.indexOf(this.tokenGenerator.stringForLastToken()) != -1) {
                            endMarkerFound = true;
                            break;
                        }
                        HTMLElement nextChild = this.rules.shouldFilterStringsForChildren(markerRules) && doFilterStrings ? this.parseNextHTMLElement(true, notFirstChild, marker) : this.parseNextHTMLElement(false, notFirstChild, marker);
                        notFirstChild = true;
                        if (nextChild == null) {
                            if (this.tokenGenerator.hasMoreTokens()) continue;
                            this.reportSyntaxError("Unterminated marker " + marker);
                            break;
                        }
                        children[childrenCount++] = nextChild;
                        if (childrenCount != children.length) continue;
                        Object[] newChildren = new Object[children.length * 2];
                        System.arraycopy(children, 0, newChildren, 0, childrenCount);
                        children = newChildren;
                    }
                    if (childrenCount > 0) {
                        Object[] tmp = new Object[childrenCount];
                        System.arraycopy(children, 0, tmp, 0, childrenCount);
                        result.setChildren(tmp);
                    } else {
                        result.setChildren(null);
                    }
                    if (!endMarkerFound) {
                        this.reportSyntaxError("No end found for marker " + marker);
                    }
                    return result;
                }
                result = (HTMLElement)c.newInstance();
                result.setMarker(marker);
                result.setAttributes(this.tokenGenerator.attributesForLastToken());
                return result;
            }
            case 4: {
                Class c = this.classForMarker("IFCCOMMENT");
                if (c == null) break;
                String s = this.tokenGenerator.stringForLastToken();
                result = (HTMLElement)c.newInstance();
                result.setMarker("IFCCOMMENT");
                result.setString(s);
                return result;
            }
            case 3: {
                String marker = this.tokenGenerator.stringForLastToken();
                Class c = this.classForMarker(marker);
                if (c == null || this.rules.shouldIgnoreEnd(this.rules.rulesForMarker(marker))) break;
                this.reportSyntaxError("Unexpected closing " + marker + " while parsing contents for marker " + pMarker);
                break;
            }
            default: {
                this.reportSyntaxError("Unexpected statement");
            }
        }
        return null;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    private static int parseKeyOrValue(String source, int index, FastStringBuffer dest) {
        int start = index;
        int length = source.length();
        char endChar = '\u0000';
        while (start < length && HTMLParser.isSpace(source.charAt(start))) {
            ++start;
        }
        if (start == length) {
            return 0;
        }
        int end = start;
        if (source.charAt(end) == '\'' || source.charAt(end) == '\"') {
            endChar = source.charAt(end);
        }
        do {
            dest.append(source.charAt(end));
        } while (++end < length && (endChar == '\u0000' && !HTMLParser.isSpace(source.charAt(end)) && source.charAt(end) != '=' || endChar != '\u0000' && source.charAt(end) != endChar));
        if (end < length && source.charAt(end) == endChar) {
            dest.append(source.charAt(end));
            ++end;
        }
        return end - start;
    }

    private static String filterKeyOrValue(FastStringBuffer source) {
        int c = source.length();
        if (c == 0) {
            return "";
        }
        if (source.charAt(0) == '\'' || source.charAt(0) == '\"') {
            if (c <= 2) {
                return "";
            }
            return source.toString().substring(1, c - 1);
        }
        return source.toString();
    }
}

