/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

#include "CMiniSecurityButton.h"
#include "CSharedPatternWorld.h"

CMiniSecurityButton::CMiniSecurityButton(LStream* inStream)
:	CBrowserSecurityButton(inStream)
{
}

ResIDT CMiniSecurityButton::GetIconID(ESecurityState inSecurityState)
{
	ResIDT result = ResID_UnsecureIcon;
	if (inSecurityState == eSecureState)
		result = ResID_SecureIcon;
	return result;
}


// 
//		DrawButtonContent
// 
	
void CMiniSecurityButton::DrawButtonContent(void)
{
	CGrafPtr thePort;
	::GetPort(&(GrafPtr)thePort);
	
	Rect theFrame = mCachedButtonFrame;
	Point theAlignment;
	
	CalcOrientationPoint(theAlignment);
	mPatternWorld->Fill(thePort, theFrame, theAlignment);
}

// 
//		DrawButtonGraphic
// 

void CMiniSecurityButton::DrawButtonGraphic(void)
{
	CToolbarButton::DrawButtonGraphic();
}
