// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1992,93,94,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        scenedata.h
//
// Purpose:     interface to 3D scene data (abstract)
//              (no implementation associated with class SceneData)
//
// Created:     24 Apr 95   Michael Pichler (extracted from scene3d.h)
//
// Changed:     20 Feb 97   Alexander Nussbaumer (editing)
//
// Changed:     27 Feb 97   Michael Pichler
//
// $Id: scenedata.h,v 1.21 1997/04/30 10:38:39 mpichler Exp $
//
//</file>


#ifndef harmony_scene_scenedata_h
#define harmony_scene_scenedata_h

class Camera;
class GeometricObject;
class Material;
class Scene3D;
class StringArray;
class IntArray;
class QvGroup;
class QvNode;
class QvPerspectiveCamera;
class QvOrthographicCamera;
class QvTexture2;
class QvTransform;
class QvWWWAnchor;
class QvWWWInline;
class RString;


#include <ge3d/vectors.h>

#include <stdio.h>
class ostream;


class SceneData
{ 
  public:
    SceneData (Scene3D* scene)
    { scene_ = scene; }
    virtual ~SceneData ()  { }

    // *** input ***
    // readInput arguments format dependent (no virtual function)
    virtual void loadTextures ()  { }  // request all in-file textures (SDF)
    virtual const char* formatName () const = 0;  // "SDF", "VRML" etc.
    virtual int readInlineVRML (QvWWWInline*, FILE*)  { return 0; }

    // *** output ***
    virtual int writeData (ostream& /*os*/, int /*format*/)  { return 0; }
    // write file to output stream (format: Scene3D::write_*); return error flag
    virtual void printInfo (int /*all*/)  { }   // print scene information
    virtual unsigned long getNumFaces () const = 0;  // number of faces (polygons)
    virtual unsigned long getNumPrimitives () const  { return 0; }  // number of primitives
    virtual unsigned long getNumBSPFaces () const  { return 0; }  // gmes, 19960405
    virtual unsigned long getNumBSPNodes () const  { return 0; }  // gmes, 19960405    
    virtual int doesHaveTextures () const  { return 0; }  // texture flag
    virtual int supportsOutputformat (int  /*format*/)  { return 0; }

    // *** drawing ***
    virtual void draw (int mode) = 0;   // draw whole scene

    // *** picking ***
    virtual void* pickObject (
      const point3D& A,                 //   ray start
      const vector3D& b,                //   ray direction
      float tnear,                      //   near distance
      float tfar,                       //   far distance
      GeometricObject** gobj = 0,       //   GeometricObject hit (return)
      QvNode** node = 0,                //   node hit (return)
      QvWWWAnchor** anchor = 0,         //   anchor hit (return)
      point3D* hitpoint = 0,            //   optionally calculates hit point
      vector3D* normal = 0,             //   and face normal vector (normalized)
      const StringArray** groups = 0,   //   optionally determines groups hit
      IntArray** hitpath = 0,           //   optionally creates path to VRML node hit
      float* hittime = 0                //   optionally returns the hit time
    ) = 0;
    virtual void selectedPosition (     // get position of selected node
      RString& /*pos*/                  // (to be used for VRML anchor definition)
    )  { }

    // *** anchors ***
    virtual void clearAnchors ()  { }   // clear all anchor definitions
    virtual void defineHyperGanchor (   // store Hyper-G source anchor
      long /*id*/,                      //   anchor id
      const RString& /*aobj*/,          //   anchor object
      const char* /*posstr*/,           //   anchor position field
      const RString& /*title*/          //   anchor title (descr.)
    )  { }
    virtual void findTextureMaterial (  // find texture material
      const char* /*name*/,             //   name (Hyper-G texture anchor)
      Material*& /*material*/,          //   returns either SDF material
      QvTexture2*& /*texture*/          //   or VRML texture node
    )  { }
    virtual void rebuild (int /*extras*/)  { }  // rebuild scene data
    virtual void colorRebuild ()  { }   // rebuild after anchor color change

    // *** camera ***
    virtual Camera* getCamera () const = 0;     // get active camera
    virtual void storeCamera () = 0;            // store active camera
    virtual void restoreCamera () = 0;          // reset camera (to one read from file or latest stored)
    virtual void activateCamera (
      const char*,
      QvPerspectiveCamera*, QvOrthographicCamera*
    )  { }

    // *** editing ***
    virtual void startEditing ()  { }   // set when activating edit mode for this scene
    virtual int startedEditing () const  { return 0; }

    virtual void translateSelected (    // translate selected object
      const vector3D&)  { }
    virtual void rotateSelected (       // rotate selected object
      vector3D&, float) { }             //   axis, angle (radians)
    virtual void scaleSelected (        // scale selected object
      const vector3D&)  { }
    virtual void storeRotation ()  { }  // store rotation at time of press

    virtual int checkVRMLScene (QvGroup* = 0)  { return 0; }   // check the vrml scene graph and prepares it for editing
    virtual void updateEditContext ()  { }  // update dialogs
    virtual int viewSelectedNode ()  { return 0; }
    virtual void viewAll ()  { }
    virtual int selectParent ()  { return 0; }
    virtual int selectChild ()  { return 0; }
    virtual int selectNext (int /*step*/)  { return 0; }

    virtual void unselectPropertyNodes ()  { }
    virtual void storeForUndo ()  { }  // for undo
    virtual int undoManipulation ()  { return 0; }  // for undo
    virtual QvTransform* selectedTransform () const  { return 0; }
    virtual void constraints (int)  { }
    virtual int constraints ()  { return 0; }
    virtual void debugScenegraph ()  { }
    virtual void calculateCameraMatrix ()  { }
    virtual int deleteSelectedNode  ()  { return 0; }
    virtual int cutSelectedNode ()  { return 0; }
    virtual int copySelectedNode ()  { return 0; }
    virtual int pasteSelectedNode ()  { return 0; }
    virtual void updateWWWAnchorDialog ()  { }

  protected:
    Scene3D* scene_;

}; // SceneData


#endif
