// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        menus.h
//
// Purpose:     interface to menus
//
// Created:     12 Jan 93   Michael Pichler
//
// Changed:     24 May 93   Juergen Schipflinger
//
// Changed:     27 May 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_menus_h
#define harmony_widgets_menus_h

#include "libwidgets.h"

#include <InterViews/enter-scope.h>
class Action;
class LayoutKit;
class Menu;
class MenuItem;
class WidgetKit;
class TelltaleGroup;
class TelltaleState;


//<class>
//
// Name:    MenuKit
//
// Purpose: generating menu items
//
// Menu items are generated with glue on the right side, such that the
// selection bar is always full width.
// An accelerator label (tells the keyboard equivalent of a function)
// is placed on the right margin; menu items with an associated submenu
// (pullright) have an arrow at that place.
// If the menu item action opens a dialog box, "..." should be appended
// to the label.
// Contrary to InterViews' menu classes, check menu items and radio menu
// items have MenuItem as primary style name (not as alias) to make for
// a consistent look of menu items.
// "Help" menu item should be on right margin; therefore append menubarGlue
// to the menubar, just before appending the help menubar item.
//
// Style names (aliases):    for:
//   MenuBar (Menu)            menubarItem
//   MenuItem (Menu)           menuItem
//   MenuItem (ToggleButton)   checkMenuItem
//   MenuItem (RadioButton)    radioMenuItem
//
// style attributes: font, foreground, background (IV)
//
//</class>

class MenuKit
{
  public:
    static Menu* menubar(               // create a menu bar
      WidgetKit& kit,                   //   to be used instead of kit.menubar()
      const LayoutKit& layout           //   when menubarGlue should be used
    );

    static MenuItem* menubarGlue(       // create glue (between menu bar items)
      const LayoutKit& layout
    );

    static MenuItem* menubarItem(       // menubar item with submenu
      WidgetKit& kit,
      const char* label,
      Menu* submenu                     //   pulldown submenu
    );

    static MenuItem* menuItem(          // menu item with action
      WidgetKit& kit,
      const LayoutKit& layout,
      const char* label,
      Action* action,                   //   action
      const char* acc = 0,              //   optional acc. label
      TelltaleState* t = nil            //   opt. telltale state
    );

    static MenuItem* menuItem(          // menu item with submenu (pullright)
      WidgetKit& kit,
      const LayoutKit& layout,
      const char* label,
      Menu* submenu                     //   pullright submenu
    );

   static MenuItem* checkMenuItem(      // check menu item
     WidgetKit& kit,
     const LayoutKit& layout,
     const char* label,
     Action* action,                    //   action
     int choose = 0,                    //   initial state: chosen or not
     const char* acc = 0,               //   optional acc. label
     TelltaleState* t = nil             //   opt. telltale state
   );

   static MenuItem* radioMenuItem(      // radio menu item
     WidgetKit& kit,
     const LayoutKit& layout,
     TelltaleGroup* group,              //   telltale group
     const char* label,
     Action* action,                    //   action
     int choose = 0,                    //   initial state: chosen or not
     const char* acc = 0,               //   optional acc. label
     TelltaleState* t = nil             //   opt. telltale state
   );

   static MenuItem* enable(MenuItem*);  // enable menu item

   static MenuItem* disable(MenuItem*); // disable menu item

}; // MenuKit



#endif
